<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PointsTotalDetail StructType
 * @subpackage Structs
 */
class Payment_PointsTotalDetail extends AnyEntity
{
    /**
     * The BankedBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BankedBalance;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The PendingBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PendingBalance;
    /**
     * The PointsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PointsType;
    /**
     * The TotalBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalBalance;
    /**
     * Constructor method for Payment.PointsTotalDetail
     * @uses Payment_PointsTotalDetail::setBankedBalance()
     * @uses Payment_PointsTotalDetail::setClientId()
     * @uses Payment_PointsTotalDetail::setHolderCompanyId()
     * @uses Payment_PointsTotalDetail::setKey()
     * @uses Payment_PointsTotalDetail::setPendingBalance()
     * @uses Payment_PointsTotalDetail::setPointsType()
     * @uses Payment_PointsTotalDetail::setTotalBalance()
     * @param float $bankedBalance
     * @param string $clientId
     * @param int $holderCompanyId
     * @param string $key
     * @param float $pendingBalance
     * @param string $pointsType
     * @param float $totalBalance
     */
    public function __construct($bankedBalance = null, $clientId = null, $holderCompanyId = null, $key = null, $pendingBalance = null, $pointsType = null, $totalBalance = null)
    {
        $this
            ->setBankedBalance($bankedBalance)
            ->setClientId($clientId)
            ->setHolderCompanyId($holderCompanyId)
            ->setKey($key)
            ->setPendingBalance($pendingBalance)
            ->setPointsType($pointsType)
            ->setTotalBalance($totalBalance);
    }
    /**
     * Get BankedBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBankedBalance()
    {
        return isset($this->BankedBalance) ? $this->BankedBalance : null;
    }
    /**
     * Set BankedBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bankedBalance
     * @return \patest\StructType\Payment_PointsTotalDetail
     */
    public function setBankedBalance($bankedBalance = null)
    {
        // validation for constraint: float
        if (!is_null($bankedBalance) && !(is_float($bankedBalance) || is_numeric($bankedBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bankedBalance, true), gettype($bankedBalance)), __LINE__);
        }
        if (is_null($bankedBalance) || (is_array($bankedBalance) && empty($bankedBalance))) {
            unset($this->BankedBalance);
        } else {
            $this->BankedBalance = $bankedBalance;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_PointsTotalDetail
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Payment_PointsTotalDetail
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \patest\StructType\Payment_PointsTotalDetail
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get PendingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPendingBalance()
    {
        return isset($this->PendingBalance) ? $this->PendingBalance : null;
    }
    /**
     * Set PendingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pendingBalance
     * @return \patest\StructType\Payment_PointsTotalDetail
     */
    public function setPendingBalance($pendingBalance = null)
    {
        // validation for constraint: float
        if (!is_null($pendingBalance) && !(is_float($pendingBalance) || is_numeric($pendingBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pendingBalance, true), gettype($pendingBalance)), __LINE__);
        }
        if (is_null($pendingBalance) || (is_array($pendingBalance) && empty($pendingBalance))) {
            unset($this->PendingBalance);
        } else {
            $this->PendingBalance = $pendingBalance;
        }
        return $this;
    }
    /**
     * Get PointsType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPointsType()
    {
        return isset($this->PointsType) ? $this->PointsType : null;
    }
    /**
     * Set PointsType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LoyaltyPointsMode::valueIsValid()
     * @uses \patest\EnumType\LoyaltyPointsMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pointsType
     * @return \patest\StructType\Payment_PointsTotalDetail
     */
    public function setPointsType($pointsType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LoyaltyPointsMode::valueIsValid($pointsType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LoyaltyPointsMode', is_array($pointsType) ? implode(', ', $pointsType) : var_export($pointsType, true), implode(', ', \patest\EnumType\LoyaltyPointsMode::getValidValues())), __LINE__);
        }
        if (is_null($pointsType) || (is_array($pointsType) && empty($pointsType))) {
            unset($this->PointsType);
        } else {
            $this->PointsType = $pointsType;
        }
        return $this;
    }
    /**
     * Get TotalBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalBalance()
    {
        return isset($this->TotalBalance) ? $this->TotalBalance : null;
    }
    /**
     * Set TotalBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalBalance
     * @return \patest\StructType\Payment_PointsTotalDetail
     */
    public function setTotalBalance($totalBalance = null)
    {
        // validation for constraint: float
        if (!is_null($totalBalance) && !(is_float($totalBalance) || is_numeric($totalBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalBalance, true), gettype($totalBalance)), __LINE__);
        }
        if (is_null($totalBalance) || (is_array($totalBalance) && empty($totalBalance))) {
            unset($this->TotalBalance);
        } else {
            $this->TotalBalance = $totalBalance;
        }
        return $this;
    }
}
