<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentSessionForInvoice StructType
 * @subpackage Structs
 */
class Payment_PaymentSessionForInvoice extends PersistableEntity
{
    /**
     * The ResultCardCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ResultCardCompanyId;
    /**
     * The ResultCardCompanyName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ResultCardCompanyName;
    /**
     * The ResultCardExpirationMM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardExpirationMM;
    /**
     * The ResultCardExpirationYY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardExpirationYY;
    /**
     * The ResultCardPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardPrefix;
    /**
     * The ResultCardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardSuffix;
    /**
     * Constructor method for Payment.PaymentSessionForInvoice
     * @uses Payment_PaymentSessionForInvoice::setResultCardCompanyId()
     * @uses Payment_PaymentSessionForInvoice::setResultCardCompanyName()
     * @uses Payment_PaymentSessionForInvoice::setResultCardExpirationMM()
     * @uses Payment_PaymentSessionForInvoice::setResultCardExpirationYY()
     * @uses Payment_PaymentSessionForInvoice::setResultCardPrefix()
     * @uses Payment_PaymentSessionForInvoice::setResultCardSuffix()
     * @param string $resultCardCompanyId
     * @param \patest\StructType\GlobalString $resultCardCompanyName
     * @param string $resultCardExpirationMM
     * @param string $resultCardExpirationYY
     * @param string $resultCardPrefix
     * @param string $resultCardSuffix
     */
    public function __construct($resultCardCompanyId = null, \patest\StructType\GlobalString $resultCardCompanyName = null, $resultCardExpirationMM = null, $resultCardExpirationYY = null, $resultCardPrefix = null, $resultCardSuffix = null)
    {
        $this
            ->setResultCardCompanyId($resultCardCompanyId)
            ->setResultCardCompanyName($resultCardCompanyName)
            ->setResultCardExpirationMM($resultCardExpirationMM)
            ->setResultCardExpirationYY($resultCardExpirationYY)
            ->setResultCardPrefix($resultCardPrefix)
            ->setResultCardSuffix($resultCardSuffix);
    }
    /**
     * Get ResultCardCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardCompanyId()
    {
        return isset($this->ResultCardCompanyId) ? $this->ResultCardCompanyId : null;
    }
    /**
     * Set ResultCardCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardCompanyId
     * @return \patest\StructType\Payment_PaymentSessionForInvoice
     */
    public function setResultCardCompanyId($resultCardCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardCompanyId) && !is_string($resultCardCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardCompanyId, true), gettype($resultCardCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($resultCardCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $resultCardCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($resultCardCompanyId, true)), __LINE__);
        }
        if (is_null($resultCardCompanyId) || (is_array($resultCardCompanyId) && empty($resultCardCompanyId))) {
            unset($this->ResultCardCompanyId);
        } else {
            $this->ResultCardCompanyId = $resultCardCompanyId;
        }
        return $this;
    }
    /**
     * Get ResultCardCompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getResultCardCompanyName()
    {
        return isset($this->ResultCardCompanyName) ? $this->ResultCardCompanyName : null;
    }
    /**
     * Set ResultCardCompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $resultCardCompanyName
     * @return \patest\StructType\Payment_PaymentSessionForInvoice
     */
    public function setResultCardCompanyName(\patest\StructType\GlobalString $resultCardCompanyName = null)
    {
        if (is_null($resultCardCompanyName) || (is_array($resultCardCompanyName) && empty($resultCardCompanyName))) {
            unset($this->ResultCardCompanyName);
        } else {
            $this->ResultCardCompanyName = $resultCardCompanyName;
        }
        return $this;
    }
    /**
     * Get ResultCardExpirationMM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardExpirationMM()
    {
        return isset($this->ResultCardExpirationMM) ? $this->ResultCardExpirationMM : null;
    }
    /**
     * Set ResultCardExpirationMM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardExpirationMM
     * @return \patest\StructType\Payment_PaymentSessionForInvoice
     */
    public function setResultCardExpirationMM($resultCardExpirationMM = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardExpirationMM) && !is_string($resultCardExpirationMM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardExpirationMM, true), gettype($resultCardExpirationMM)), __LINE__);
        }
        if (is_null($resultCardExpirationMM) || (is_array($resultCardExpirationMM) && empty($resultCardExpirationMM))) {
            unset($this->ResultCardExpirationMM);
        } else {
            $this->ResultCardExpirationMM = $resultCardExpirationMM;
        }
        return $this;
    }
    /**
     * Get ResultCardExpirationYY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardExpirationYY()
    {
        return isset($this->ResultCardExpirationYY) ? $this->ResultCardExpirationYY : null;
    }
    /**
     * Set ResultCardExpirationYY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardExpirationYY
     * @return \patest\StructType\Payment_PaymentSessionForInvoice
     */
    public function setResultCardExpirationYY($resultCardExpirationYY = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardExpirationYY) && !is_string($resultCardExpirationYY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardExpirationYY, true), gettype($resultCardExpirationYY)), __LINE__);
        }
        if (is_null($resultCardExpirationYY) || (is_array($resultCardExpirationYY) && empty($resultCardExpirationYY))) {
            unset($this->ResultCardExpirationYY);
        } else {
            $this->ResultCardExpirationYY = $resultCardExpirationYY;
        }
        return $this;
    }
    /**
     * Get ResultCardPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardPrefix()
    {
        return isset($this->ResultCardPrefix) ? $this->ResultCardPrefix : null;
    }
    /**
     * Set ResultCardPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardPrefix
     * @return \patest\StructType\Payment_PaymentSessionForInvoice
     */
    public function setResultCardPrefix($resultCardPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardPrefix) && !is_string($resultCardPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardPrefix, true), gettype($resultCardPrefix)), __LINE__);
        }
        if (is_null($resultCardPrefix) || (is_array($resultCardPrefix) && empty($resultCardPrefix))) {
            unset($this->ResultCardPrefix);
        } else {
            $this->ResultCardPrefix = $resultCardPrefix;
        }
        return $this;
    }
    /**
     * Get ResultCardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardSuffix()
    {
        return isset($this->ResultCardSuffix) ? $this->ResultCardSuffix : null;
    }
    /**
     * Set ResultCardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardSuffix
     * @return \patest\StructType\Payment_PaymentSessionForInvoice
     */
    public function setResultCardSuffix($resultCardSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardSuffix) && !is_string($resultCardSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardSuffix, true), gettype($resultCardSuffix)), __LINE__);
        }
        if (is_null($resultCardSuffix) || (is_array($resultCardSuffix) && empty($resultCardSuffix))) {
            unset($this->ResultCardSuffix);
        } else {
            $this->ResultCardSuffix = $resultCardSuffix;
        }
        return $this;
    }
}
