<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentSession StructType
 * @subpackage Structs
 */
class Payment_PaymentSession extends VolatileEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The ClientAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientAddress;
    /**
     * The ClientAddressLine1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientAddressLine1;
    /**
     * The ClientAddressLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientAddressLine2;
    /**
     * The ClientAddressLine3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientAddressLine3;
    /**
     * The ClientAddressLine4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientAddressLine4;
    /**
     * The ClientAddressLine5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientAddressLine5;
    /**
     * The ClientCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCity;
    /**
     * The ClientCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCountry;
    /**
     * The ClientCountryIsoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCountryIsoCode;
    /**
     * The ClientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientEmail;
    /**
     * The ClientFirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientFirstName;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientIdentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientIdentNumber;
    /**
     * The ClientIsNew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ClientIsNew;
    /**
     * The ClientLastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientLastName;
    /**
     * The ClientPhone1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientPhone1;
    /**
     * The ClientPhone1Digits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientPhone1Digits;
    /**
     * The ClientPhone2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientPhone2;
    /**
     * The ClientPhone2Digits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientPhone2Digits;
    /**
     * The ClientRegion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientRegion;
    /**
     * The ClientRemark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientRemark;
    /**
     * The ClientState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientState;
    /**
     * The ClientStateIsoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientStateIsoCode;
    /**
     * The ClientZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientZipCode;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The CompletionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompletionCode;
    /**
     * The CompletionProblem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompletionProblem;
    /**
     * The CreationAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreationAuditId;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ExecutionHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionHistory;
    /**
     * The ExecutionStep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionStep;
    /**
     * The ExecutionStepDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionStepDate;
    /**
     * The ExtraData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraData;
    /**
     * The HasErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasErrors;
    /**
     * The HasWarnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasWarnings;
    /**
     * The IsAuthorized
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAuthorized;
    /**
     * The IsIndeterminate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIndeterminate;
    /**
     * The IsInProcess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInProcess;
    /**
     * The IsOperationDone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOperationDone;
    /**
     * The IsProblemResolved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsProblemResolved;
    /**
     * The IsRolledBack
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRolledBack;
    /**
     * The KnownSaleTranState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KnownSaleTranState;
    /**
     * The LocalRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalRefNumber;
    /**
     * The LockedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LockedAt;
    /**
     * The Messages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Messages;
    /**
     * The NextStatusCheckDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NextStatusCheckDate;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operation;
    /**
     * The OperationMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationMode;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OriginalTokenIdToReplace
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTokenIdToReplace;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemId;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The ResultBillingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultBillingAddress;
    /**
     * The ResultCardCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ResultCardCompanyId;
    /**
     * The ResultCardExpirationMM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardExpirationMM;
    /**
     * The ResultCardExpirationYY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardExpirationYY;
    /**
     * The ResultCardHolderName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardHolderName;
    /**
     * The ResultCardNumberMask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardNumberMask;
    /**
     * The ResultCardPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardPrefix;
    /**
     * The ResultCardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardSuffix;
    /**
     * The ResultCardToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardToken;
    /**
     * The ResultCardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultCardType;
    /**
     * The ResultClearingCompany
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultClearingCompany;
    /**
     * The ResultClearingCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ResultClearingCompanyId;
    /**
     * The ResultConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultConfirmationNumber;
    /**
     * The ResultExtraData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultExtraData;
    /**
     * The ResultGatewayTransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultGatewayTransactionId;
    /**
     * The ResultRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultRefNumber;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The SysAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SysAmount;
    /**
     * The SysCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SysCurrencyCode;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for Payment.PaymentSession
     * @uses Payment_PaymentSession::setAmount()
     * @uses Payment_PaymentSession::setApplicationChannel()
     * @uses Payment_PaymentSession::setClientAddress()
     * @uses Payment_PaymentSession::setClientAddressLine1()
     * @uses Payment_PaymentSession::setClientAddressLine2()
     * @uses Payment_PaymentSession::setClientAddressLine3()
     * @uses Payment_PaymentSession::setClientAddressLine4()
     * @uses Payment_PaymentSession::setClientAddressLine5()
     * @uses Payment_PaymentSession::setClientCity()
     * @uses Payment_PaymentSession::setClientCountry()
     * @uses Payment_PaymentSession::setClientCountryIsoCode()
     * @uses Payment_PaymentSession::setClientEmail()
     * @uses Payment_PaymentSession::setClientFirstName()
     * @uses Payment_PaymentSession::setClientId()
     * @uses Payment_PaymentSession::setClientIdentNumber()
     * @uses Payment_PaymentSession::setClientIsNew()
     * @uses Payment_PaymentSession::setClientLastName()
     * @uses Payment_PaymentSession::setClientPhone1()
     * @uses Payment_PaymentSession::setClientPhone1Digits()
     * @uses Payment_PaymentSession::setClientPhone2()
     * @uses Payment_PaymentSession::setClientPhone2Digits()
     * @uses Payment_PaymentSession::setClientRegion()
     * @uses Payment_PaymentSession::setClientRemark()
     * @uses Payment_PaymentSession::setClientState()
     * @uses Payment_PaymentSession::setClientStateIsoCode()
     * @uses Payment_PaymentSession::setClientZipCode()
     * @uses Payment_PaymentSession::setComments()
     * @uses Payment_PaymentSession::setCompletionCode()
     * @uses Payment_PaymentSession::setCompletionProblem()
     * @uses Payment_PaymentSession::setCreationAuditId()
     * @uses Payment_PaymentSession::setCurrencyCode()
     * @uses Payment_PaymentSession::setEndDate()
     * @uses Payment_PaymentSession::setExecutionHistory()
     * @uses Payment_PaymentSession::setExecutionStep()
     * @uses Payment_PaymentSession::setExecutionStepDate()
     * @uses Payment_PaymentSession::setExtraData()
     * @uses Payment_PaymentSession::setHasErrors()
     * @uses Payment_PaymentSession::setHasWarnings()
     * @uses Payment_PaymentSession::setIsAuthorized()
     * @uses Payment_PaymentSession::setIsIndeterminate()
     * @uses Payment_PaymentSession::setIsInProcess()
     * @uses Payment_PaymentSession::setIsOperationDone()
     * @uses Payment_PaymentSession::setIsProblemResolved()
     * @uses Payment_PaymentSession::setIsRolledBack()
     * @uses Payment_PaymentSession::setKnownSaleTranState()
     * @uses Payment_PaymentSession::setLocalRefNumber()
     * @uses Payment_PaymentSession::setLockedAt()
     * @uses Payment_PaymentSession::setMessages()
     * @uses Payment_PaymentSession::setNextStatusCheckDate()
     * @uses Payment_PaymentSession::setOperation()
     * @uses Payment_PaymentSession::setOperationMode()
     * @uses Payment_PaymentSession::setOrganizationUnitId()
     * @uses Payment_PaymentSession::setOriginalTokenIdToReplace()
     * @uses Payment_PaymentSession::setPaymentItemId()
     * @uses Payment_PaymentSession::setPaymentMethodId()
     * @uses Payment_PaymentSession::setResultBillingAddress()
     * @uses Payment_PaymentSession::setResultCardCompanyId()
     * @uses Payment_PaymentSession::setResultCardExpirationMM()
     * @uses Payment_PaymentSession::setResultCardExpirationYY()
     * @uses Payment_PaymentSession::setResultCardHolderName()
     * @uses Payment_PaymentSession::setResultCardNumberMask()
     * @uses Payment_PaymentSession::setResultCardPrefix()
     * @uses Payment_PaymentSession::setResultCardSuffix()
     * @uses Payment_PaymentSession::setResultCardToken()
     * @uses Payment_PaymentSession::setResultCardType()
     * @uses Payment_PaymentSession::setResultClearingCompany()
     * @uses Payment_PaymentSession::setResultClearingCompanyId()
     * @uses Payment_PaymentSession::setResultConfirmationNumber()
     * @uses Payment_PaymentSession::setResultExtraData()
     * @uses Payment_PaymentSession::setResultGatewayTransactionId()
     * @uses Payment_PaymentSession::setResultRefNumber()
     * @uses Payment_PaymentSession::setSalePointId()
     * @uses Payment_PaymentSession::setStartDate()
     * @uses Payment_PaymentSession::setSysAmount()
     * @uses Payment_PaymentSession::setSysCurrencyCode()
     * @uses Payment_PaymentSession::setTransactionGuid()
     * @param \patest\StructType\Money $amount
     * @param string $applicationChannel
     * @param string $clientAddress
     * @param string $clientAddressLine1
     * @param string $clientAddressLine2
     * @param string $clientAddressLine3
     * @param string $clientAddressLine4
     * @param string $clientAddressLine5
     * @param string $clientCity
     * @param string $clientCountry
     * @param string $clientCountryIsoCode
     * @param string $clientEmail
     * @param string $clientFirstName
     * @param string $clientId
     * @param string $clientIdentNumber
     * @param bool $clientIsNew
     * @param string $clientLastName
     * @param string $clientPhone1
     * @param string $clientPhone1Digits
     * @param string $clientPhone2
     * @param string $clientPhone2Digits
     * @param string $clientRegion
     * @param string $clientRemark
     * @param string $clientState
     * @param string $clientStateIsoCode
     * @param string $clientZipCode
     * @param string $comments
     * @param string $completionCode
     * @param string $completionProblem
     * @param int $creationAuditId
     * @param string $currencyCode
     * @param string $endDate
     * @param string $executionHistory
     * @param string $executionStep
     * @param string $executionStepDate
     * @param string $extraData
     * @param bool $hasErrors
     * @param bool $hasWarnings
     * @param bool $isAuthorized
     * @param bool $isIndeterminate
     * @param bool $isInProcess
     * @param bool $isOperationDone
     * @param bool $isProblemResolved
     * @param bool $isRolledBack
     * @param string $knownSaleTranState
     * @param int $localRefNumber
     * @param string $lockedAt
     * @param string $messages
     * @param string $nextStatusCheckDate
     * @param string $operation
     * @param string $operationMode
     * @param string $organizationUnitId
     * @param string $originalTokenIdToReplace
     * @param string $paymentItemId
     * @param string $paymentMethodId
     * @param string $resultBillingAddress
     * @param string $resultCardCompanyId
     * @param string $resultCardExpirationMM
     * @param string $resultCardExpirationYY
     * @param string $resultCardHolderName
     * @param string $resultCardNumberMask
     * @param string $resultCardPrefix
     * @param string $resultCardSuffix
     * @param string $resultCardToken
     * @param string $resultCardType
     * @param string $resultClearingCompany
     * @param string $resultClearingCompanyId
     * @param string $resultConfirmationNumber
     * @param string $resultExtraData
     * @param string $resultGatewayTransactionId
     * @param string $resultRefNumber
     * @param string $salePointId
     * @param string $startDate
     * @param \patest\StructType\Money $sysAmount
     * @param string $sysCurrencyCode
     * @param string $transactionGuid
     */
    public function __construct(\patest\StructType\Money $amount = null, $applicationChannel = null, $clientAddress = null, $clientAddressLine1 = null, $clientAddressLine2 = null, $clientAddressLine3 = null, $clientAddressLine4 = null, $clientAddressLine5 = null, $clientCity = null, $clientCountry = null, $clientCountryIsoCode = null, $clientEmail = null, $clientFirstName = null, $clientId = null, $clientIdentNumber = null, $clientIsNew = null, $clientLastName = null, $clientPhone1 = null, $clientPhone1Digits = null, $clientPhone2 = null, $clientPhone2Digits = null, $clientRegion = null, $clientRemark = null, $clientState = null, $clientStateIsoCode = null, $clientZipCode = null, $comments = null, $completionCode = null, $completionProblem = null, $creationAuditId = null, $currencyCode = null, $endDate = null, $executionHistory = null, $executionStep = null, $executionStepDate = null, $extraData = null, $hasErrors = null, $hasWarnings = null, $isAuthorized = null, $isIndeterminate = null, $isInProcess = null, $isOperationDone = null, $isProblemResolved = null, $isRolledBack = null, $knownSaleTranState = null, $localRefNumber = null, $lockedAt = null, $messages = null, $nextStatusCheckDate = null, $operation = null, $operationMode = null, $organizationUnitId = null, $originalTokenIdToReplace = null, $paymentItemId = null, $paymentMethodId = null, $resultBillingAddress = null, $resultCardCompanyId = null, $resultCardExpirationMM = null, $resultCardExpirationYY = null, $resultCardHolderName = null, $resultCardNumberMask = null, $resultCardPrefix = null, $resultCardSuffix = null, $resultCardToken = null, $resultCardType = null, $resultClearingCompany = null, $resultClearingCompanyId = null, $resultConfirmationNumber = null, $resultExtraData = null, $resultGatewayTransactionId = null, $resultRefNumber = null, $salePointId = null, $startDate = null, \patest\StructType\Money $sysAmount = null, $sysCurrencyCode = null, $transactionGuid = null)
    {
        $this
            ->setAmount($amount)
            ->setApplicationChannel($applicationChannel)
            ->setClientAddress($clientAddress)
            ->setClientAddressLine1($clientAddressLine1)
            ->setClientAddressLine2($clientAddressLine2)
            ->setClientAddressLine3($clientAddressLine3)
            ->setClientAddressLine4($clientAddressLine4)
            ->setClientAddressLine5($clientAddressLine5)
            ->setClientCity($clientCity)
            ->setClientCountry($clientCountry)
            ->setClientCountryIsoCode($clientCountryIsoCode)
            ->setClientEmail($clientEmail)
            ->setClientFirstName($clientFirstName)
            ->setClientId($clientId)
            ->setClientIdentNumber($clientIdentNumber)
            ->setClientIsNew($clientIsNew)
            ->setClientLastName($clientLastName)
            ->setClientPhone1($clientPhone1)
            ->setClientPhone1Digits($clientPhone1Digits)
            ->setClientPhone2($clientPhone2)
            ->setClientPhone2Digits($clientPhone2Digits)
            ->setClientRegion($clientRegion)
            ->setClientRemark($clientRemark)
            ->setClientState($clientState)
            ->setClientStateIsoCode($clientStateIsoCode)
            ->setClientZipCode($clientZipCode)
            ->setComments($comments)
            ->setCompletionCode($completionCode)
            ->setCompletionProblem($completionProblem)
            ->setCreationAuditId($creationAuditId)
            ->setCurrencyCode($currencyCode)
            ->setEndDate($endDate)
            ->setExecutionHistory($executionHistory)
            ->setExecutionStep($executionStep)
            ->setExecutionStepDate($executionStepDate)
            ->setExtraData($extraData)
            ->setHasErrors($hasErrors)
            ->setHasWarnings($hasWarnings)
            ->setIsAuthorized($isAuthorized)
            ->setIsIndeterminate($isIndeterminate)
            ->setIsInProcess($isInProcess)
            ->setIsOperationDone($isOperationDone)
            ->setIsProblemResolved($isProblemResolved)
            ->setIsRolledBack($isRolledBack)
            ->setKnownSaleTranState($knownSaleTranState)
            ->setLocalRefNumber($localRefNumber)
            ->setLockedAt($lockedAt)
            ->setMessages($messages)
            ->setNextStatusCheckDate($nextStatusCheckDate)
            ->setOperation($operation)
            ->setOperationMode($operationMode)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOriginalTokenIdToReplace($originalTokenIdToReplace)
            ->setPaymentItemId($paymentItemId)
            ->setPaymentMethodId($paymentMethodId)
            ->setResultBillingAddress($resultBillingAddress)
            ->setResultCardCompanyId($resultCardCompanyId)
            ->setResultCardExpirationMM($resultCardExpirationMM)
            ->setResultCardExpirationYY($resultCardExpirationYY)
            ->setResultCardHolderName($resultCardHolderName)
            ->setResultCardNumberMask($resultCardNumberMask)
            ->setResultCardPrefix($resultCardPrefix)
            ->setResultCardSuffix($resultCardSuffix)
            ->setResultCardToken($resultCardToken)
            ->setResultCardType($resultCardType)
            ->setResultClearingCompany($resultClearingCompany)
            ->setResultClearingCompanyId($resultClearingCompanyId)
            ->setResultConfirmationNumber($resultConfirmationNumber)
            ->setResultExtraData($resultExtraData)
            ->setResultGatewayTransactionId($resultGatewayTransactionId)
            ->setResultRefNumber($resultRefNumber)
            ->setSalePointId($salePointId)
            ->setStartDate($startDate)
            ->setSysAmount($sysAmount)
            ->setSysCurrencyCode($sysCurrencyCode)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get ClientAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientAddress()
    {
        return isset($this->ClientAddress) ? $this->ClientAddress : null;
    }
    /**
     * Set ClientAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientAddress
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientAddress($clientAddress = null)
    {
        // validation for constraint: string
        if (!is_null($clientAddress) && !is_string($clientAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientAddress, true), gettype($clientAddress)), __LINE__);
        }
        if (is_null($clientAddress) || (is_array($clientAddress) && empty($clientAddress))) {
            unset($this->ClientAddress);
        } else {
            $this->ClientAddress = $clientAddress;
        }
        return $this;
    }
    /**
     * Get ClientAddressLine1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientAddressLine1()
    {
        return isset($this->ClientAddressLine1) ? $this->ClientAddressLine1 : null;
    }
    /**
     * Set ClientAddressLine1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientAddressLine1
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientAddressLine1($clientAddressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($clientAddressLine1) && !is_string($clientAddressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientAddressLine1, true), gettype($clientAddressLine1)), __LINE__);
        }
        if (is_null($clientAddressLine1) || (is_array($clientAddressLine1) && empty($clientAddressLine1))) {
            unset($this->ClientAddressLine1);
        } else {
            $this->ClientAddressLine1 = $clientAddressLine1;
        }
        return $this;
    }
    /**
     * Get ClientAddressLine2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientAddressLine2()
    {
        return isset($this->ClientAddressLine2) ? $this->ClientAddressLine2 : null;
    }
    /**
     * Set ClientAddressLine2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientAddressLine2
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientAddressLine2($clientAddressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($clientAddressLine2) && !is_string($clientAddressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientAddressLine2, true), gettype($clientAddressLine2)), __LINE__);
        }
        if (is_null($clientAddressLine2) || (is_array($clientAddressLine2) && empty($clientAddressLine2))) {
            unset($this->ClientAddressLine2);
        } else {
            $this->ClientAddressLine2 = $clientAddressLine2;
        }
        return $this;
    }
    /**
     * Get ClientAddressLine3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientAddressLine3()
    {
        return isset($this->ClientAddressLine3) ? $this->ClientAddressLine3 : null;
    }
    /**
     * Set ClientAddressLine3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientAddressLine3
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientAddressLine3($clientAddressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($clientAddressLine3) && !is_string($clientAddressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientAddressLine3, true), gettype($clientAddressLine3)), __LINE__);
        }
        if (is_null($clientAddressLine3) || (is_array($clientAddressLine3) && empty($clientAddressLine3))) {
            unset($this->ClientAddressLine3);
        } else {
            $this->ClientAddressLine3 = $clientAddressLine3;
        }
        return $this;
    }
    /**
     * Get ClientAddressLine4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientAddressLine4()
    {
        return isset($this->ClientAddressLine4) ? $this->ClientAddressLine4 : null;
    }
    /**
     * Set ClientAddressLine4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientAddressLine4
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientAddressLine4($clientAddressLine4 = null)
    {
        // validation for constraint: string
        if (!is_null($clientAddressLine4) && !is_string($clientAddressLine4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientAddressLine4, true), gettype($clientAddressLine4)), __LINE__);
        }
        if (is_null($clientAddressLine4) || (is_array($clientAddressLine4) && empty($clientAddressLine4))) {
            unset($this->ClientAddressLine4);
        } else {
            $this->ClientAddressLine4 = $clientAddressLine4;
        }
        return $this;
    }
    /**
     * Get ClientAddressLine5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientAddressLine5()
    {
        return isset($this->ClientAddressLine5) ? $this->ClientAddressLine5 : null;
    }
    /**
     * Set ClientAddressLine5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientAddressLine5
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientAddressLine5($clientAddressLine5 = null)
    {
        // validation for constraint: string
        if (!is_null($clientAddressLine5) && !is_string($clientAddressLine5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientAddressLine5, true), gettype($clientAddressLine5)), __LINE__);
        }
        if (is_null($clientAddressLine5) || (is_array($clientAddressLine5) && empty($clientAddressLine5))) {
            unset($this->ClientAddressLine5);
        } else {
            $this->ClientAddressLine5 = $clientAddressLine5;
        }
        return $this;
    }
    /**
     * Get ClientCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCity()
    {
        return isset($this->ClientCity) ? $this->ClientCity : null;
    }
    /**
     * Set ClientCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCity
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientCity($clientCity = null)
    {
        // validation for constraint: string
        if (!is_null($clientCity) && !is_string($clientCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCity, true), gettype($clientCity)), __LINE__);
        }
        if (is_null($clientCity) || (is_array($clientCity) && empty($clientCity))) {
            unset($this->ClientCity);
        } else {
            $this->ClientCity = $clientCity;
        }
        return $this;
    }
    /**
     * Get ClientCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCountry()
    {
        return isset($this->ClientCountry) ? $this->ClientCountry : null;
    }
    /**
     * Set ClientCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCountry
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientCountry($clientCountry = null)
    {
        // validation for constraint: string
        if (!is_null($clientCountry) && !is_string($clientCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCountry, true), gettype($clientCountry)), __LINE__);
        }
        if (is_null($clientCountry) || (is_array($clientCountry) && empty($clientCountry))) {
            unset($this->ClientCountry);
        } else {
            $this->ClientCountry = $clientCountry;
        }
        return $this;
    }
    /**
     * Get ClientCountryIsoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCountryIsoCode()
    {
        return isset($this->ClientCountryIsoCode) ? $this->ClientCountryIsoCode : null;
    }
    /**
     * Set ClientCountryIsoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCountryIsoCode
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientCountryIsoCode($clientCountryIsoCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCountryIsoCode) && !is_string($clientCountryIsoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCountryIsoCode, true), gettype($clientCountryIsoCode)), __LINE__);
        }
        if (is_null($clientCountryIsoCode) || (is_array($clientCountryIsoCode) && empty($clientCountryIsoCode))) {
            unset($this->ClientCountryIsoCode);
        } else {
            $this->ClientCountryIsoCode = $clientCountryIsoCode;
        }
        return $this;
    }
    /**
     * Get ClientEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientEmail()
    {
        return isset($this->ClientEmail) ? $this->ClientEmail : null;
    }
    /**
     * Set ClientEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientEmail
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientEmail($clientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($clientEmail) && !is_string($clientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientEmail, true), gettype($clientEmail)), __LINE__);
        }
        if (is_null($clientEmail) || (is_array($clientEmail) && empty($clientEmail))) {
            unset($this->ClientEmail);
        } else {
            $this->ClientEmail = $clientEmail;
        }
        return $this;
    }
    /**
     * Get ClientFirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientFirstName()
    {
        return isset($this->ClientFirstName) ? $this->ClientFirstName : null;
    }
    /**
     * Set ClientFirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientFirstName
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientFirstName($clientFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($clientFirstName) && !is_string($clientFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientFirstName, true), gettype($clientFirstName)), __LINE__);
        }
        if (is_null($clientFirstName) || (is_array($clientFirstName) && empty($clientFirstName))) {
            unset($this->ClientFirstName);
        } else {
            $this->ClientFirstName = $clientFirstName;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientIdentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientIdentNumber()
    {
        return isset($this->ClientIdentNumber) ? $this->ClientIdentNumber : null;
    }
    /**
     * Set ClientIdentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientIdentNumber
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientIdentNumber($clientIdentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($clientIdentNumber) && !is_string($clientIdentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIdentNumber, true), gettype($clientIdentNumber)), __LINE__);
        }
        if (is_null($clientIdentNumber) || (is_array($clientIdentNumber) && empty($clientIdentNumber))) {
            unset($this->ClientIdentNumber);
        } else {
            $this->ClientIdentNumber = $clientIdentNumber;
        }
        return $this;
    }
    /**
     * Get ClientIsNew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getClientIsNew()
    {
        return isset($this->ClientIsNew) ? $this->ClientIsNew : null;
    }
    /**
     * Set ClientIsNew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $clientIsNew
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientIsNew($clientIsNew = null)
    {
        // validation for constraint: boolean
        if (!is_null($clientIsNew) && !is_bool($clientIsNew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($clientIsNew, true), gettype($clientIsNew)), __LINE__);
        }
        if (is_null($clientIsNew) || (is_array($clientIsNew) && empty($clientIsNew))) {
            unset($this->ClientIsNew);
        } else {
            $this->ClientIsNew = $clientIsNew;
        }
        return $this;
    }
    /**
     * Get ClientLastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientLastName()
    {
        return isset($this->ClientLastName) ? $this->ClientLastName : null;
    }
    /**
     * Set ClientLastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientLastName
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientLastName($clientLastName = null)
    {
        // validation for constraint: string
        if (!is_null($clientLastName) && !is_string($clientLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientLastName, true), gettype($clientLastName)), __LINE__);
        }
        if (is_null($clientLastName) || (is_array($clientLastName) && empty($clientLastName))) {
            unset($this->ClientLastName);
        } else {
            $this->ClientLastName = $clientLastName;
        }
        return $this;
    }
    /**
     * Get ClientPhone1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientPhone1()
    {
        return isset($this->ClientPhone1) ? $this->ClientPhone1 : null;
    }
    /**
     * Set ClientPhone1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientPhone1
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientPhone1($clientPhone1 = null)
    {
        // validation for constraint: string
        if (!is_null($clientPhone1) && !is_string($clientPhone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientPhone1, true), gettype($clientPhone1)), __LINE__);
        }
        if (is_null($clientPhone1) || (is_array($clientPhone1) && empty($clientPhone1))) {
            unset($this->ClientPhone1);
        } else {
            $this->ClientPhone1 = $clientPhone1;
        }
        return $this;
    }
    /**
     * Get ClientPhone1Digits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientPhone1Digits()
    {
        return isset($this->ClientPhone1Digits) ? $this->ClientPhone1Digits : null;
    }
    /**
     * Set ClientPhone1Digits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientPhone1Digits
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientPhone1Digits($clientPhone1Digits = null)
    {
        // validation for constraint: string
        if (!is_null($clientPhone1Digits) && !is_string($clientPhone1Digits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientPhone1Digits, true), gettype($clientPhone1Digits)), __LINE__);
        }
        if (is_null($clientPhone1Digits) || (is_array($clientPhone1Digits) && empty($clientPhone1Digits))) {
            unset($this->ClientPhone1Digits);
        } else {
            $this->ClientPhone1Digits = $clientPhone1Digits;
        }
        return $this;
    }
    /**
     * Get ClientPhone2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientPhone2()
    {
        return isset($this->ClientPhone2) ? $this->ClientPhone2 : null;
    }
    /**
     * Set ClientPhone2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientPhone2
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientPhone2($clientPhone2 = null)
    {
        // validation for constraint: string
        if (!is_null($clientPhone2) && !is_string($clientPhone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientPhone2, true), gettype($clientPhone2)), __LINE__);
        }
        if (is_null($clientPhone2) || (is_array($clientPhone2) && empty($clientPhone2))) {
            unset($this->ClientPhone2);
        } else {
            $this->ClientPhone2 = $clientPhone2;
        }
        return $this;
    }
    /**
     * Get ClientPhone2Digits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientPhone2Digits()
    {
        return isset($this->ClientPhone2Digits) ? $this->ClientPhone2Digits : null;
    }
    /**
     * Set ClientPhone2Digits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientPhone2Digits
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientPhone2Digits($clientPhone2Digits = null)
    {
        // validation for constraint: string
        if (!is_null($clientPhone2Digits) && !is_string($clientPhone2Digits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientPhone2Digits, true), gettype($clientPhone2Digits)), __LINE__);
        }
        if (is_null($clientPhone2Digits) || (is_array($clientPhone2Digits) && empty($clientPhone2Digits))) {
            unset($this->ClientPhone2Digits);
        } else {
            $this->ClientPhone2Digits = $clientPhone2Digits;
        }
        return $this;
    }
    /**
     * Get ClientRegion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientRegion()
    {
        return isset($this->ClientRegion) ? $this->ClientRegion : null;
    }
    /**
     * Set ClientRegion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientRegion
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientRegion($clientRegion = null)
    {
        // validation for constraint: string
        if (!is_null($clientRegion) && !is_string($clientRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientRegion, true), gettype($clientRegion)), __LINE__);
        }
        if (is_null($clientRegion) || (is_array($clientRegion) && empty($clientRegion))) {
            unset($this->ClientRegion);
        } else {
            $this->ClientRegion = $clientRegion;
        }
        return $this;
    }
    /**
     * Get ClientRemark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientRemark()
    {
        return isset($this->ClientRemark) ? $this->ClientRemark : null;
    }
    /**
     * Set ClientRemark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientRemark
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientRemark($clientRemark = null)
    {
        // validation for constraint: string
        if (!is_null($clientRemark) && !is_string($clientRemark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientRemark, true), gettype($clientRemark)), __LINE__);
        }
        if (is_null($clientRemark) || (is_array($clientRemark) && empty($clientRemark))) {
            unset($this->ClientRemark);
        } else {
            $this->ClientRemark = $clientRemark;
        }
        return $this;
    }
    /**
     * Get ClientState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientState()
    {
        return isset($this->ClientState) ? $this->ClientState : null;
    }
    /**
     * Set ClientState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientState
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientState($clientState = null)
    {
        // validation for constraint: string
        if (!is_null($clientState) && !is_string($clientState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientState, true), gettype($clientState)), __LINE__);
        }
        if (is_null($clientState) || (is_array($clientState) && empty($clientState))) {
            unset($this->ClientState);
        } else {
            $this->ClientState = $clientState;
        }
        return $this;
    }
    /**
     * Get ClientStateIsoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientStateIsoCode()
    {
        return isset($this->ClientStateIsoCode) ? $this->ClientStateIsoCode : null;
    }
    /**
     * Set ClientStateIsoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientStateIsoCode
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientStateIsoCode($clientStateIsoCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientStateIsoCode) && !is_string($clientStateIsoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientStateIsoCode, true), gettype($clientStateIsoCode)), __LINE__);
        }
        if (is_null($clientStateIsoCode) || (is_array($clientStateIsoCode) && empty($clientStateIsoCode))) {
            unset($this->ClientStateIsoCode);
        } else {
            $this->ClientStateIsoCode = $clientStateIsoCode;
        }
        return $this;
    }
    /**
     * Get ClientZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientZipCode()
    {
        return isset($this->ClientZipCode) ? $this->ClientZipCode : null;
    }
    /**
     * Set ClientZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientZipCode
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setClientZipCode($clientZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientZipCode) && !is_string($clientZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientZipCode, true), gettype($clientZipCode)), __LINE__);
        }
        if (is_null($clientZipCode) || (is_array($clientZipCode) && empty($clientZipCode))) {
            unset($this->ClientZipCode);
        } else {
            $this->ClientZipCode = $clientZipCode;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comments
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get CompletionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompletionCode()
    {
        return isset($this->CompletionCode) ? $this->CompletionCode : null;
    }
    /**
     * Set CompletionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentSessionCompletionCode::valueIsValid()
     * @uses \patest\EnumType\PaymentSessionCompletionCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $completionCode
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setCompletionCode($completionCode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentSessionCompletionCode::valueIsValid($completionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentSessionCompletionCode', is_array($completionCode) ? implode(', ', $completionCode) : var_export($completionCode, true), implode(', ', \patest\EnumType\PaymentSessionCompletionCode::getValidValues())), __LINE__);
        }
        if (is_null($completionCode) || (is_array($completionCode) && empty($completionCode))) {
            unset($this->CompletionCode);
        } else {
            $this->CompletionCode = $completionCode;
        }
        return $this;
    }
    /**
     * Get CompletionProblem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompletionProblem()
    {
        return isset($this->CompletionProblem) ? $this->CompletionProblem : null;
    }
    /**
     * Set CompletionProblem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentSessionCompletionProblem::valueIsValid()
     * @uses \patest\EnumType\PaymentSessionCompletionProblem::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $completionProblem
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setCompletionProblem($completionProblem = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentSessionCompletionProblem::valueIsValid($completionProblem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentSessionCompletionProblem', is_array($completionProblem) ? implode(', ', $completionProblem) : var_export($completionProblem, true), implode(', ', \patest\EnumType\PaymentSessionCompletionProblem::getValidValues())), __LINE__);
        }
        if (is_null($completionProblem) || (is_array($completionProblem) && empty($completionProblem))) {
            unset($this->CompletionProblem);
        } else {
            $this->CompletionProblem = $completionProblem;
        }
        return $this;
    }
    /**
     * Get CreationAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreationAuditId()
    {
        return isset($this->CreationAuditId) ? $this->CreationAuditId : null;
    }
    /**
     * Set CreationAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creationAuditId
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setCreationAuditId($creationAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($creationAuditId) && !(is_int($creationAuditId) || ctype_digit($creationAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationAuditId, true), gettype($creationAuditId)), __LINE__);
        }
        if (is_null($creationAuditId) || (is_array($creationAuditId) && empty($creationAuditId))) {
            unset($this->CreationAuditId);
        } else {
            $this->CreationAuditId = $creationAuditId;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get ExecutionHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionHistory()
    {
        return isset($this->ExecutionHistory) ? $this->ExecutionHistory : null;
    }
    /**
     * Set ExecutionHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionHistory
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setExecutionHistory($executionHistory = null)
    {
        // validation for constraint: string
        if (!is_null($executionHistory) && !is_string($executionHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionHistory, true), gettype($executionHistory)), __LINE__);
        }
        if (is_null($executionHistory) || (is_array($executionHistory) && empty($executionHistory))) {
            unset($this->ExecutionHistory);
        } else {
            $this->ExecutionHistory = $executionHistory;
        }
        return $this;
    }
    /**
     * Get ExecutionStep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionStep()
    {
        return isset($this->ExecutionStep) ? $this->ExecutionStep : null;
    }
    /**
     * Set ExecutionStep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionStep
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setExecutionStep($executionStep = null)
    {
        // validation for constraint: string
        if (!is_null($executionStep) && !is_string($executionStep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionStep, true), gettype($executionStep)), __LINE__);
        }
        if (is_null($executionStep) || (is_array($executionStep) && empty($executionStep))) {
            unset($this->ExecutionStep);
        } else {
            $this->ExecutionStep = $executionStep;
        }
        return $this;
    }
    /**
     * Get ExecutionStepDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionStepDate()
    {
        return isset($this->ExecutionStepDate) ? $this->ExecutionStepDate : null;
    }
    /**
     * Set ExecutionStepDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionStepDate
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setExecutionStepDate($executionStepDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionStepDate) && !is_string($executionStepDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionStepDate, true), gettype($executionStepDate)), __LINE__);
        }
        if (is_null($executionStepDate) || (is_array($executionStepDate) && empty($executionStepDate))) {
            unset($this->ExecutionStepDate);
        } else {
            $this->ExecutionStepDate = $executionStepDate;
        }
        return $this;
    }
    /**
     * Get ExtraData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraData()
    {
        return isset($this->ExtraData) ? $this->ExtraData : null;
    }
    /**
     * Set ExtraData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraData
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setExtraData($extraData = null)
    {
        // validation for constraint: string
        if (!is_null($extraData) && !is_string($extraData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraData, true), gettype($extraData)), __LINE__);
        }
        if (is_null($extraData) || (is_array($extraData) && empty($extraData))) {
            unset($this->ExtraData);
        } else {
            $this->ExtraData = $extraData;
        }
        return $this;
    }
    /**
     * Get HasErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasErrors()
    {
        return isset($this->HasErrors) ? $this->HasErrors : null;
    }
    /**
     * Set HasErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasErrors
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setHasErrors($hasErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasErrors) && !is_bool($hasErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasErrors, true), gettype($hasErrors)), __LINE__);
        }
        if (is_null($hasErrors) || (is_array($hasErrors) && empty($hasErrors))) {
            unset($this->HasErrors);
        } else {
            $this->HasErrors = $hasErrors;
        }
        return $this;
    }
    /**
     * Get HasWarnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasWarnings()
    {
        return isset($this->HasWarnings) ? $this->HasWarnings : null;
    }
    /**
     * Set HasWarnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasWarnings
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setHasWarnings($hasWarnings = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasWarnings) && !is_bool($hasWarnings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasWarnings, true), gettype($hasWarnings)), __LINE__);
        }
        if (is_null($hasWarnings) || (is_array($hasWarnings) && empty($hasWarnings))) {
            unset($this->HasWarnings);
        } else {
            $this->HasWarnings = $hasWarnings;
        }
        return $this;
    }
    /**
     * Get IsAuthorized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAuthorized()
    {
        return isset($this->IsAuthorized) ? $this->IsAuthorized : null;
    }
    /**
     * Set IsAuthorized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAuthorized
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setIsAuthorized($isAuthorized = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAuthorized) && !is_bool($isAuthorized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAuthorized, true), gettype($isAuthorized)), __LINE__);
        }
        if (is_null($isAuthorized) || (is_array($isAuthorized) && empty($isAuthorized))) {
            unset($this->IsAuthorized);
        } else {
            $this->IsAuthorized = $isAuthorized;
        }
        return $this;
    }
    /**
     * Get IsIndeterminate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIndeterminate()
    {
        return isset($this->IsIndeterminate) ? $this->IsIndeterminate : null;
    }
    /**
     * Set IsIndeterminate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIndeterminate
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setIsIndeterminate($isIndeterminate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIndeterminate) && !is_bool($isIndeterminate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIndeterminate, true), gettype($isIndeterminate)), __LINE__);
        }
        if (is_null($isIndeterminate) || (is_array($isIndeterminate) && empty($isIndeterminate))) {
            unset($this->IsIndeterminate);
        } else {
            $this->IsIndeterminate = $isIndeterminate;
        }
        return $this;
    }
    /**
     * Get IsInProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInProcess()
    {
        return isset($this->IsInProcess) ? $this->IsInProcess : null;
    }
    /**
     * Set IsInProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInProcess
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setIsInProcess($isInProcess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInProcess) && !is_bool($isInProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInProcess, true), gettype($isInProcess)), __LINE__);
        }
        if (is_null($isInProcess) || (is_array($isInProcess) && empty($isInProcess))) {
            unset($this->IsInProcess);
        } else {
            $this->IsInProcess = $isInProcess;
        }
        return $this;
    }
    /**
     * Get IsOperationDone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOperationDone()
    {
        return isset($this->IsOperationDone) ? $this->IsOperationDone : null;
    }
    /**
     * Set IsOperationDone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOperationDone
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setIsOperationDone($isOperationDone = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOperationDone) && !is_bool($isOperationDone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOperationDone, true), gettype($isOperationDone)), __LINE__);
        }
        if (is_null($isOperationDone) || (is_array($isOperationDone) && empty($isOperationDone))) {
            unset($this->IsOperationDone);
        } else {
            $this->IsOperationDone = $isOperationDone;
        }
        return $this;
    }
    /**
     * Get IsProblemResolved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsProblemResolved()
    {
        return isset($this->IsProblemResolved) ? $this->IsProblemResolved : null;
    }
    /**
     * Set IsProblemResolved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isProblemResolved
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setIsProblemResolved($isProblemResolved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProblemResolved) && !is_bool($isProblemResolved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProblemResolved, true), gettype($isProblemResolved)), __LINE__);
        }
        if (is_null($isProblemResolved) || (is_array($isProblemResolved) && empty($isProblemResolved))) {
            unset($this->IsProblemResolved);
        } else {
            $this->IsProblemResolved = $isProblemResolved;
        }
        return $this;
    }
    /**
     * Get IsRolledBack value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRolledBack()
    {
        return isset($this->IsRolledBack) ? $this->IsRolledBack : null;
    }
    /**
     * Set IsRolledBack value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRolledBack
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setIsRolledBack($isRolledBack = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRolledBack) && !is_bool($isRolledBack)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRolledBack, true), gettype($isRolledBack)), __LINE__);
        }
        if (is_null($isRolledBack) || (is_array($isRolledBack) && empty($isRolledBack))) {
            unset($this->IsRolledBack);
        } else {
            $this->IsRolledBack = $isRolledBack;
        }
        return $this;
    }
    /**
     * Get KnownSaleTranState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKnownSaleTranState()
    {
        return isset($this->KnownSaleTranState) ? $this->KnownSaleTranState : null;
    }
    /**
     * Set KnownSaleTranState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionState::valueIsValid()
     * @uses \patest\EnumType\TransactionState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $knownSaleTranState
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setKnownSaleTranState($knownSaleTranState = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionState::valueIsValid($knownSaleTranState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionState', is_array($knownSaleTranState) ? implode(', ', $knownSaleTranState) : var_export($knownSaleTranState, true), implode(', ', \patest\EnumType\TransactionState::getValidValues())), __LINE__);
        }
        if (is_null($knownSaleTranState) || (is_array($knownSaleTranState) && empty($knownSaleTranState))) {
            unset($this->KnownSaleTranState);
        } else {
            $this->KnownSaleTranState = $knownSaleTranState;
        }
        return $this;
    }
    /**
     * Get LocalRefNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalRefNumber()
    {
        return isset($this->LocalRefNumber) ? $this->LocalRefNumber : null;
    }
    /**
     * Set LocalRefNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localRefNumber
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setLocalRefNumber($localRefNumber = null)
    {
        // validation for constraint: int
        if (!is_null($localRefNumber) && !(is_int($localRefNumber) || ctype_digit($localRefNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localRefNumber, true), gettype($localRefNumber)), __LINE__);
        }
        if (is_null($localRefNumber) || (is_array($localRefNumber) && empty($localRefNumber))) {
            unset($this->LocalRefNumber);
        } else {
            $this->LocalRefNumber = $localRefNumber;
        }
        return $this;
    }
    /**
     * Get LockedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockedAt()
    {
        return isset($this->LockedAt) ? $this->LockedAt : null;
    }
    /**
     * Set LockedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockedAt
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setLockedAt($lockedAt = null)
    {
        // validation for constraint: string
        if (!is_null($lockedAt) && !is_string($lockedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockedAt, true), gettype($lockedAt)), __LINE__);
        }
        if (is_null($lockedAt) || (is_array($lockedAt) && empty($lockedAt))) {
            unset($this->LockedAt);
        } else {
            $this->LockedAt = $lockedAt;
        }
        return $this;
    }
    /**
     * Get Messages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessages()
    {
        return isset($this->Messages) ? $this->Messages : null;
    }
    /**
     * Set Messages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messages
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setMessages($messages = null)
    {
        // validation for constraint: string
        if (!is_null($messages) && !is_string($messages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messages, true), gettype($messages)), __LINE__);
        }
        if (is_null($messages) || (is_array($messages) && empty($messages))) {
            unset($this->Messages);
        } else {
            $this->Messages = $messages;
        }
        return $this;
    }
    /**
     * Get NextStatusCheckDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNextStatusCheckDate()
    {
        return isset($this->NextStatusCheckDate) ? $this->NextStatusCheckDate : null;
    }
    /**
     * Set NextStatusCheckDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nextStatusCheckDate
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setNextStatusCheckDate($nextStatusCheckDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextStatusCheckDate) && !is_string($nextStatusCheckDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextStatusCheckDate, true), gettype($nextStatusCheckDate)), __LINE__);
        }
        if (is_null($nextStatusCheckDate) || (is_array($nextStatusCheckDate) && empty($nextStatusCheckDate))) {
            unset($this->NextStatusCheckDate);
        } else {
            $this->NextStatusCheckDate = $nextStatusCheckDate;
        }
        return $this;
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentSessionOperationKind::valueIsValid()
     * @uses \patest\EnumType\PaymentSessionOperationKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentSessionOperationKind::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentSessionOperationKind', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \patest\EnumType\PaymentSessionOperationKind::getValidValues())), __LINE__);
        }
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get OperationMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationMode()
    {
        return isset($this->OperationMode) ? $this->OperationMode : null;
    }
    /**
     * Set OperationMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationMode
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setOperationMode($operationMode = null)
    {
        // validation for constraint: string
        if (!is_null($operationMode) && !is_string($operationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationMode, true), gettype($operationMode)), __LINE__);
        }
        if (is_null($operationMode) || (is_array($operationMode) && empty($operationMode))) {
            unset($this->OperationMode);
        } else {
            $this->OperationMode = $operationMode;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OriginalTokenIdToReplace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTokenIdToReplace()
    {
        return isset($this->OriginalTokenIdToReplace) ? $this->OriginalTokenIdToReplace : null;
    }
    /**
     * Set OriginalTokenIdToReplace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTokenIdToReplace
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setOriginalTokenIdToReplace($originalTokenIdToReplace = null)
    {
        // validation for constraint: string
        if (!is_null($originalTokenIdToReplace) && !is_string($originalTokenIdToReplace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTokenIdToReplace, true), gettype($originalTokenIdToReplace)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTokenIdToReplace) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTokenIdToReplace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTokenIdToReplace, true)), __LINE__);
        }
        if (is_null($originalTokenIdToReplace) || (is_array($originalTokenIdToReplace) && empty($originalTokenIdToReplace))) {
            unset($this->OriginalTokenIdToReplace);
        } else {
            $this->OriginalTokenIdToReplace = $originalTokenIdToReplace;
        }
        return $this;
    }
    /**
     * Get PaymentItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemId()
    {
        return isset($this->PaymentItemId) ? $this->PaymentItemId : null;
    }
    /**
     * Set PaymentItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemId
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemId) && !is_string($paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemId, true)), __LINE__);
        }
        if (is_null($paymentItemId) || (is_array($paymentItemId) && empty($paymentItemId))) {
            unset($this->PaymentItemId);
        } else {
            $this->PaymentItemId = $paymentItemId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get ResultBillingAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultBillingAddress()
    {
        return isset($this->ResultBillingAddress) ? $this->ResultBillingAddress : null;
    }
    /**
     * Set ResultBillingAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultBillingAddress
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultBillingAddress($resultBillingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($resultBillingAddress) && !is_string($resultBillingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultBillingAddress, true), gettype($resultBillingAddress)), __LINE__);
        }
        if (is_null($resultBillingAddress) || (is_array($resultBillingAddress) && empty($resultBillingAddress))) {
            unset($this->ResultBillingAddress);
        } else {
            $this->ResultBillingAddress = $resultBillingAddress;
        }
        return $this;
    }
    /**
     * Get ResultCardCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardCompanyId()
    {
        return isset($this->ResultCardCompanyId) ? $this->ResultCardCompanyId : null;
    }
    /**
     * Set ResultCardCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardCompanyId
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultCardCompanyId($resultCardCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardCompanyId) && !is_string($resultCardCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardCompanyId, true), gettype($resultCardCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($resultCardCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $resultCardCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($resultCardCompanyId, true)), __LINE__);
        }
        if (is_null($resultCardCompanyId) || (is_array($resultCardCompanyId) && empty($resultCardCompanyId))) {
            unset($this->ResultCardCompanyId);
        } else {
            $this->ResultCardCompanyId = $resultCardCompanyId;
        }
        return $this;
    }
    /**
     * Get ResultCardExpirationMM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardExpirationMM()
    {
        return isset($this->ResultCardExpirationMM) ? $this->ResultCardExpirationMM : null;
    }
    /**
     * Set ResultCardExpirationMM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardExpirationMM
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultCardExpirationMM($resultCardExpirationMM = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardExpirationMM) && !is_string($resultCardExpirationMM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardExpirationMM, true), gettype($resultCardExpirationMM)), __LINE__);
        }
        if (is_null($resultCardExpirationMM) || (is_array($resultCardExpirationMM) && empty($resultCardExpirationMM))) {
            unset($this->ResultCardExpirationMM);
        } else {
            $this->ResultCardExpirationMM = $resultCardExpirationMM;
        }
        return $this;
    }
    /**
     * Get ResultCardExpirationYY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardExpirationYY()
    {
        return isset($this->ResultCardExpirationYY) ? $this->ResultCardExpirationYY : null;
    }
    /**
     * Set ResultCardExpirationYY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardExpirationYY
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultCardExpirationYY($resultCardExpirationYY = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardExpirationYY) && !is_string($resultCardExpirationYY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardExpirationYY, true), gettype($resultCardExpirationYY)), __LINE__);
        }
        if (is_null($resultCardExpirationYY) || (is_array($resultCardExpirationYY) && empty($resultCardExpirationYY))) {
            unset($this->ResultCardExpirationYY);
        } else {
            $this->ResultCardExpirationYY = $resultCardExpirationYY;
        }
        return $this;
    }
    /**
     * Get ResultCardHolderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardHolderName()
    {
        return isset($this->ResultCardHolderName) ? $this->ResultCardHolderName : null;
    }
    /**
     * Set ResultCardHolderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardHolderName
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultCardHolderName($resultCardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardHolderName) && !is_string($resultCardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardHolderName, true), gettype($resultCardHolderName)), __LINE__);
        }
        if (is_null($resultCardHolderName) || (is_array($resultCardHolderName) && empty($resultCardHolderName))) {
            unset($this->ResultCardHolderName);
        } else {
            $this->ResultCardHolderName = $resultCardHolderName;
        }
        return $this;
    }
    /**
     * Get ResultCardNumberMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardNumberMask()
    {
        return isset($this->ResultCardNumberMask) ? $this->ResultCardNumberMask : null;
    }
    /**
     * Set ResultCardNumberMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardNumberMask
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultCardNumberMask($resultCardNumberMask = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardNumberMask) && !is_string($resultCardNumberMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardNumberMask, true), gettype($resultCardNumberMask)), __LINE__);
        }
        if (is_null($resultCardNumberMask) || (is_array($resultCardNumberMask) && empty($resultCardNumberMask))) {
            unset($this->ResultCardNumberMask);
        } else {
            $this->ResultCardNumberMask = $resultCardNumberMask;
        }
        return $this;
    }
    /**
     * Get ResultCardPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardPrefix()
    {
        return isset($this->ResultCardPrefix) ? $this->ResultCardPrefix : null;
    }
    /**
     * Set ResultCardPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardPrefix
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultCardPrefix($resultCardPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardPrefix) && !is_string($resultCardPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardPrefix, true), gettype($resultCardPrefix)), __LINE__);
        }
        if (is_null($resultCardPrefix) || (is_array($resultCardPrefix) && empty($resultCardPrefix))) {
            unset($this->ResultCardPrefix);
        } else {
            $this->ResultCardPrefix = $resultCardPrefix;
        }
        return $this;
    }
    /**
     * Get ResultCardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardSuffix()
    {
        return isset($this->ResultCardSuffix) ? $this->ResultCardSuffix : null;
    }
    /**
     * Set ResultCardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardSuffix
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultCardSuffix($resultCardSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardSuffix) && !is_string($resultCardSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardSuffix, true), gettype($resultCardSuffix)), __LINE__);
        }
        if (is_null($resultCardSuffix) || (is_array($resultCardSuffix) && empty($resultCardSuffix))) {
            unset($this->ResultCardSuffix);
        } else {
            $this->ResultCardSuffix = $resultCardSuffix;
        }
        return $this;
    }
    /**
     * Get ResultCardToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardToken()
    {
        return isset($this->ResultCardToken) ? $this->ResultCardToken : null;
    }
    /**
     * Set ResultCardToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardToken
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultCardToken($resultCardToken = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardToken) && !is_string($resultCardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardToken, true), gettype($resultCardToken)), __LINE__);
        }
        if (is_null($resultCardToken) || (is_array($resultCardToken) && empty($resultCardToken))) {
            unset($this->ResultCardToken);
        } else {
            $this->ResultCardToken = $resultCardToken;
        }
        return $this;
    }
    /**
     * Get ResultCardType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultCardType()
    {
        return isset($this->ResultCardType) ? $this->ResultCardType : null;
    }
    /**
     * Set ResultCardType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultCardType
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultCardType($resultCardType = null)
    {
        // validation for constraint: string
        if (!is_null($resultCardType) && !is_string($resultCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCardType, true), gettype($resultCardType)), __LINE__);
        }
        if (is_null($resultCardType) || (is_array($resultCardType) && empty($resultCardType))) {
            unset($this->ResultCardType);
        } else {
            $this->ResultCardType = $resultCardType;
        }
        return $this;
    }
    /**
     * Get ResultClearingCompany value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultClearingCompany()
    {
        return isset($this->ResultClearingCompany) ? $this->ResultClearingCompany : null;
    }
    /**
     * Set ResultClearingCompany value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultClearingCompany
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultClearingCompany($resultClearingCompany = null)
    {
        // validation for constraint: string
        if (!is_null($resultClearingCompany) && !is_string($resultClearingCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultClearingCompany, true), gettype($resultClearingCompany)), __LINE__);
        }
        if (is_null($resultClearingCompany) || (is_array($resultClearingCompany) && empty($resultClearingCompany))) {
            unset($this->ResultClearingCompany);
        } else {
            $this->ResultClearingCompany = $resultClearingCompany;
        }
        return $this;
    }
    /**
     * Get ResultClearingCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultClearingCompanyId()
    {
        return isset($this->ResultClearingCompanyId) ? $this->ResultClearingCompanyId : null;
    }
    /**
     * Set ResultClearingCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultClearingCompanyId
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultClearingCompanyId($resultClearingCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($resultClearingCompanyId) && !is_string($resultClearingCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultClearingCompanyId, true), gettype($resultClearingCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($resultClearingCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $resultClearingCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($resultClearingCompanyId, true)), __LINE__);
        }
        if (is_null($resultClearingCompanyId) || (is_array($resultClearingCompanyId) && empty($resultClearingCompanyId))) {
            unset($this->ResultClearingCompanyId);
        } else {
            $this->ResultClearingCompanyId = $resultClearingCompanyId;
        }
        return $this;
    }
    /**
     * Get ResultConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultConfirmationNumber()
    {
        return isset($this->ResultConfirmationNumber) ? $this->ResultConfirmationNumber : null;
    }
    /**
     * Set ResultConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultConfirmationNumber
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultConfirmationNumber($resultConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($resultConfirmationNumber) && !is_string($resultConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultConfirmationNumber, true), gettype($resultConfirmationNumber)), __LINE__);
        }
        if (is_null($resultConfirmationNumber) || (is_array($resultConfirmationNumber) && empty($resultConfirmationNumber))) {
            unset($this->ResultConfirmationNumber);
        } else {
            $this->ResultConfirmationNumber = $resultConfirmationNumber;
        }
        return $this;
    }
    /**
     * Get ResultExtraData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultExtraData()
    {
        return isset($this->ResultExtraData) ? $this->ResultExtraData : null;
    }
    /**
     * Set ResultExtraData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultExtraData
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultExtraData($resultExtraData = null)
    {
        // validation for constraint: string
        if (!is_null($resultExtraData) && !is_string($resultExtraData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultExtraData, true), gettype($resultExtraData)), __LINE__);
        }
        if (is_null($resultExtraData) || (is_array($resultExtraData) && empty($resultExtraData))) {
            unset($this->ResultExtraData);
        } else {
            $this->ResultExtraData = $resultExtraData;
        }
        return $this;
    }
    /**
     * Get ResultGatewayTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultGatewayTransactionId()
    {
        return isset($this->ResultGatewayTransactionId) ? $this->ResultGatewayTransactionId : null;
    }
    /**
     * Set ResultGatewayTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultGatewayTransactionId
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultGatewayTransactionId($resultGatewayTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($resultGatewayTransactionId) && !is_string($resultGatewayTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultGatewayTransactionId, true), gettype($resultGatewayTransactionId)), __LINE__);
        }
        if (is_null($resultGatewayTransactionId) || (is_array($resultGatewayTransactionId) && empty($resultGatewayTransactionId))) {
            unset($this->ResultGatewayTransactionId);
        } else {
            $this->ResultGatewayTransactionId = $resultGatewayTransactionId;
        }
        return $this;
    }
    /**
     * Get ResultRefNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultRefNumber()
    {
        return isset($this->ResultRefNumber) ? $this->ResultRefNumber : null;
    }
    /**
     * Set ResultRefNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultRefNumber
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setResultRefNumber($resultRefNumber = null)
    {
        // validation for constraint: string
        if (!is_null($resultRefNumber) && !is_string($resultRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultRefNumber, true), gettype($resultRefNumber)), __LINE__);
        }
        if (is_null($resultRefNumber) || (is_array($resultRefNumber) && empty($resultRefNumber))) {
            unset($this->ResultRefNumber);
        } else {
            $this->ResultRefNumber = $resultRefNumber;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get SysAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSysAmount()
    {
        return isset($this->SysAmount) ? $this->SysAmount : null;
    }
    /**
     * Set SysAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $sysAmount
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setSysAmount(\patest\StructType\Money $sysAmount = null)
    {
        if (is_null($sysAmount) || (is_array($sysAmount) && empty($sysAmount))) {
            unset($this->SysAmount);
        } else {
            $this->SysAmount = $sysAmount;
        }
        return $this;
    }
    /**
     * Get SysCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSysCurrencyCode()
    {
        return isset($this->SysCurrencyCode) ? $this->SysCurrencyCode : null;
    }
    /**
     * Set SysCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sysCurrencyCode
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setSysCurrencyCode($sysCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($sysCurrencyCode) && !is_string($sysCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sysCurrencyCode, true), gettype($sysCurrencyCode)), __LINE__);
        }
        if (is_null($sysCurrencyCode) || (is_array($sysCurrencyCode) && empty($sysCurrencyCode))) {
            unset($this->SysCurrencyCode);
        } else {
            $this->SysCurrencyCode = $sysCurrencyCode;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Payment_PaymentSession
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
