<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentSearchData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Payment.PaymentSearchData
 * @subpackage Structs
 */
class Payment_PaymentSearchData extends Payment_PaymentItem
{
    /**
     * The BankTransferReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankTransferReferenceNumber;
    /**
     * The BranchCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BranchCode;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The ChequeAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChequeAccountNumber;
    /**
     * The ChequeBankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChequeBankCode;
    /**
     * The ChequeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChequeNumber;
    /**
     * The ClientCreditIcon
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClientCreditIcon;
    /**
     * The ClientCreditType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClientCreditType;
    /**
     * The CouponId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponId;
    /**
     * The CreditCardExpiryDateMM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardExpiryDateMM;
    /**
     * The CreditCardExpiryDateYY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardExpiryDateYY;
    /**
     * The CreditCardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCardSuffix;
    /**
     * The CreditCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreditCompanyId;
    /**
     * The CreditCompanyName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditCompanyName;
    /**
     * The CreditToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreditToken;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The DirectDebitAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirectDebitAccountNumber;
    /**
     * The DirectDebitBankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirectDebitBankCode;
    /**
     * The DirectDebitCalculatedAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirectDebitCalculatedAccountNumber;
    /**
     * The DirectDebitGiroAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirectDebitGiroAccountNumber;
    /**
     * The GiftCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftCardNumber;
    /**
     * The GiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherDefinitionId;
    /**
     * The GiftVoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVoucherNumber;
    /**
     * The InstalmentsString
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstalmentsString;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateNumber;
    /**
     * The MandateTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateTypeId;
    /**
     * The OnlineGatewayTransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineGatewayTransactionId;
    /**
     * The OnlineReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineReferenceNumber;
    /**
     * The OriginalTokenIdToReplace
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTokenIdToReplace;
    /**
     * The PaymentPlanScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanScheduleId;
    /**
     * The ReceiptId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReceiptId;
    /**
     * The ReceiptNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReceiptNumber;
    /**
     * The RefundIcon
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RefundIcon;
    /**
     * The RefundReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RefundReferenceNumber;
    /**
     * The SpecialPaymentId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecialPaymentId;
    /**
     * The SpecialPaymentName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecialPaymentName;
    /**
     * The WithdrawClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $WithdrawClientId;
    /**
     * Constructor method for Payment.PaymentSearchData
     * @uses Payment_PaymentSearchData::setBankTransferReferenceNumber()
     * @uses Payment_PaymentSearchData::setBranchCode()
     * @uses Payment_PaymentSearchData::setCategoryId()
     * @uses Payment_PaymentSearchData::setChequeAccountNumber()
     * @uses Payment_PaymentSearchData::setChequeBankCode()
     * @uses Payment_PaymentSearchData::setChequeNumber()
     * @uses Payment_PaymentSearchData::setClientCreditIcon()
     * @uses Payment_PaymentSearchData::setClientCreditType()
     * @uses Payment_PaymentSearchData::setCouponId()
     * @uses Payment_PaymentSearchData::setCreditCardExpiryDateMM()
     * @uses Payment_PaymentSearchData::setCreditCardExpiryDateYY()
     * @uses Payment_PaymentSearchData::setCreditCardSuffix()
     * @uses Payment_PaymentSearchData::setCreditCompanyId()
     * @uses Payment_PaymentSearchData::setCreditCompanyName()
     * @uses Payment_PaymentSearchData::setCreditToken()
     * @uses Payment_PaymentSearchData::setDetails()
     * @uses Payment_PaymentSearchData::setDirectDebitAccountNumber()
     * @uses Payment_PaymentSearchData::setDirectDebitBankCode()
     * @uses Payment_PaymentSearchData::setDirectDebitCalculatedAccountNumber()
     * @uses Payment_PaymentSearchData::setDirectDebitGiroAccountNumber()
     * @uses Payment_PaymentSearchData::setGiftCardNumber()
     * @uses Payment_PaymentSearchData::setGiftVoucherDefinitionId()
     * @uses Payment_PaymentSearchData::setGiftVoucherNumber()
     * @uses Payment_PaymentSearchData::setInstalmentsString()
     * @uses Payment_PaymentSearchData::setMandateNumber()
     * @uses Payment_PaymentSearchData::setMandateTypeId()
     * @uses Payment_PaymentSearchData::setOnlineGatewayTransactionId()
     * @uses Payment_PaymentSearchData::setOnlineReferenceNumber()
     * @uses Payment_PaymentSearchData::setOriginalTokenIdToReplace()
     * @uses Payment_PaymentSearchData::setPaymentPlanScheduleId()
     * @uses Payment_PaymentSearchData::setReceiptId()
     * @uses Payment_PaymentSearchData::setReceiptNumber()
     * @uses Payment_PaymentSearchData::setRefundIcon()
     * @uses Payment_PaymentSearchData::setRefundReferenceNumber()
     * @uses Payment_PaymentSearchData::setSpecialPaymentId()
     * @uses Payment_PaymentSearchData::setSpecialPaymentName()
     * @uses Payment_PaymentSearchData::setWithdrawClientId()
     * @param string $bankTransferReferenceNumber
     * @param string $branchCode
     * @param string $categoryId
     * @param string $chequeAccountNumber
     * @param string $chequeBankCode
     * @param string $chequeNumber
     * @param int $clientCreditIcon
     * @param int $clientCreditType
     * @param string $couponId
     * @param string $creditCardExpiryDateMM
     * @param string $creditCardExpiryDateYY
     * @param string $creditCardSuffix
     * @param string $creditCompanyId
     * @param string $creditCompanyName
     * @param string $creditToken
     * @param string $details
     * @param string $directDebitAccountNumber
     * @param string $directDebitBankCode
     * @param string $directDebitCalculatedAccountNumber
     * @param string $directDebitGiroAccountNumber
     * @param string $giftCardNumber
     * @param string $giftVoucherDefinitionId
     * @param string $giftVoucherNumber
     * @param string $instalmentsString
     * @param int $mandateNumber
     * @param string $mandateTypeId
     * @param string $onlineGatewayTransactionId
     * @param string $onlineReferenceNumber
     * @param string $originalTokenIdToReplace
     * @param string $paymentPlanScheduleId
     * @param string $receiptId
     * @param int $receiptNumber
     * @param int $refundIcon
     * @param int $refundReferenceNumber
     * @param string $specialPaymentId
     * @param string $specialPaymentName
     * @param string $withdrawClientId
     */
    public function __construct($bankTransferReferenceNumber = null, $branchCode = null, $categoryId = null, $chequeAccountNumber = null, $chequeBankCode = null, $chequeNumber = null, $clientCreditIcon = null, $clientCreditType = null, $couponId = null, $creditCardExpiryDateMM = null, $creditCardExpiryDateYY = null, $creditCardSuffix = null, $creditCompanyId = null, $creditCompanyName = null, $creditToken = null, $details = null, $directDebitAccountNumber = null, $directDebitBankCode = null, $directDebitCalculatedAccountNumber = null, $directDebitGiroAccountNumber = null, $giftCardNumber = null, $giftVoucherDefinitionId = null, $giftVoucherNumber = null, $instalmentsString = null, $mandateNumber = null, $mandateTypeId = null, $onlineGatewayTransactionId = null, $onlineReferenceNumber = null, $originalTokenIdToReplace = null, $paymentPlanScheduleId = null, $receiptId = null, $receiptNumber = null, $refundIcon = null, $refundReferenceNumber = null, $specialPaymentId = null, $specialPaymentName = null, $withdrawClientId = null)
    {
        $this
            ->setBankTransferReferenceNumber($bankTransferReferenceNumber)
            ->setBranchCode($branchCode)
            ->setCategoryId($categoryId)
            ->setChequeAccountNumber($chequeAccountNumber)
            ->setChequeBankCode($chequeBankCode)
            ->setChequeNumber($chequeNumber)
            ->setClientCreditIcon($clientCreditIcon)
            ->setClientCreditType($clientCreditType)
            ->setCouponId($couponId)
            ->setCreditCardExpiryDateMM($creditCardExpiryDateMM)
            ->setCreditCardExpiryDateYY($creditCardExpiryDateYY)
            ->setCreditCardSuffix($creditCardSuffix)
            ->setCreditCompanyId($creditCompanyId)
            ->setCreditCompanyName($creditCompanyName)
            ->setCreditToken($creditToken)
            ->setDetails($details)
            ->setDirectDebitAccountNumber($directDebitAccountNumber)
            ->setDirectDebitBankCode($directDebitBankCode)
            ->setDirectDebitCalculatedAccountNumber($directDebitCalculatedAccountNumber)
            ->setDirectDebitGiroAccountNumber($directDebitGiroAccountNumber)
            ->setGiftCardNumber($giftCardNumber)
            ->setGiftVoucherDefinitionId($giftVoucherDefinitionId)
            ->setGiftVoucherNumber($giftVoucherNumber)
            ->setInstalmentsString($instalmentsString)
            ->setMandateNumber($mandateNumber)
            ->setMandateTypeId($mandateTypeId)
            ->setOnlineGatewayTransactionId($onlineGatewayTransactionId)
            ->setOnlineReferenceNumber($onlineReferenceNumber)
            ->setOriginalTokenIdToReplace($originalTokenIdToReplace)
            ->setPaymentPlanScheduleId($paymentPlanScheduleId)
            ->setReceiptId($receiptId)
            ->setReceiptNumber($receiptNumber)
            ->setRefundIcon($refundIcon)
            ->setRefundReferenceNumber($refundReferenceNumber)
            ->setSpecialPaymentId($specialPaymentId)
            ->setSpecialPaymentName($specialPaymentName)
            ->setWithdrawClientId($withdrawClientId);
    }
    /**
     * Get BankTransferReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankTransferReferenceNumber()
    {
        return isset($this->BankTransferReferenceNumber) ? $this->BankTransferReferenceNumber : null;
    }
    /**
     * Set BankTransferReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankTransferReferenceNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setBankTransferReferenceNumber($bankTransferReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankTransferReferenceNumber) && !is_string($bankTransferReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankTransferReferenceNumber, true), gettype($bankTransferReferenceNumber)), __LINE__);
        }
        if (is_null($bankTransferReferenceNumber) || (is_array($bankTransferReferenceNumber) && empty($bankTransferReferenceNumber))) {
            unset($this->BankTransferReferenceNumber);
        } else {
            $this->BankTransferReferenceNumber = $bankTransferReferenceNumber;
        }
        return $this;
    }
    /**
     * Get BranchCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBranchCode()
    {
        return isset($this->BranchCode) ? $this->BranchCode : null;
    }
    /**
     * Set BranchCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $branchCode
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchCode, true), gettype($branchCode)), __LINE__);
        }
        if (is_null($branchCode) || (is_array($branchCode) && empty($branchCode))) {
            unset($this->BranchCode);
        } else {
            $this->BranchCode = $branchCode;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get ChequeAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChequeAccountNumber()
    {
        return isset($this->ChequeAccountNumber) ? $this->ChequeAccountNumber : null;
    }
    /**
     * Set ChequeAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chequeAccountNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setChequeAccountNumber($chequeAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($chequeAccountNumber) && !is_string($chequeAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chequeAccountNumber, true), gettype($chequeAccountNumber)), __LINE__);
        }
        if (is_null($chequeAccountNumber) || (is_array($chequeAccountNumber) && empty($chequeAccountNumber))) {
            unset($this->ChequeAccountNumber);
        } else {
            $this->ChequeAccountNumber = $chequeAccountNumber;
        }
        return $this;
    }
    /**
     * Get ChequeBankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChequeBankCode()
    {
        return isset($this->ChequeBankCode) ? $this->ChequeBankCode : null;
    }
    /**
     * Set ChequeBankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chequeBankCode
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setChequeBankCode($chequeBankCode = null)
    {
        // validation for constraint: string
        if (!is_null($chequeBankCode) && !is_string($chequeBankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chequeBankCode, true), gettype($chequeBankCode)), __LINE__);
        }
        if (is_null($chequeBankCode) || (is_array($chequeBankCode) && empty($chequeBankCode))) {
            unset($this->ChequeBankCode);
        } else {
            $this->ChequeBankCode = $chequeBankCode;
        }
        return $this;
    }
    /**
     * Get ChequeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChequeNumber()
    {
        return isset($this->ChequeNumber) ? $this->ChequeNumber : null;
    }
    /**
     * Set ChequeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chequeNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setChequeNumber($chequeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($chequeNumber) && !is_string($chequeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chequeNumber, true), gettype($chequeNumber)), __LINE__);
        }
        if (is_null($chequeNumber) || (is_array($chequeNumber) && empty($chequeNumber))) {
            unset($this->ChequeNumber);
        } else {
            $this->ChequeNumber = $chequeNumber;
        }
        return $this;
    }
    /**
     * Get ClientCreditIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClientCreditIcon()
    {
        return isset($this->ClientCreditIcon) ? $this->ClientCreditIcon : null;
    }
    /**
     * Set ClientCreditIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clientCreditIcon
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setClientCreditIcon($clientCreditIcon = null)
    {
        // validation for constraint: int
        if (!is_null($clientCreditIcon) && !(is_int($clientCreditIcon) || ctype_digit($clientCreditIcon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientCreditIcon, true), gettype($clientCreditIcon)), __LINE__);
        }
        if (is_null($clientCreditIcon) || (is_array($clientCreditIcon) && empty($clientCreditIcon))) {
            unset($this->ClientCreditIcon);
        } else {
            $this->ClientCreditIcon = $clientCreditIcon;
        }
        return $this;
    }
    /**
     * Get ClientCreditType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClientCreditType()
    {
        return isset($this->ClientCreditType) ? $this->ClientCreditType : null;
    }
    /**
     * Set ClientCreditType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clientCreditType
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setClientCreditType($clientCreditType = null)
    {
        // validation for constraint: int
        if (!is_null($clientCreditType) && !(is_int($clientCreditType) || ctype_digit($clientCreditType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientCreditType, true), gettype($clientCreditType)), __LINE__);
        }
        if (is_null($clientCreditType) || (is_array($clientCreditType) && empty($clientCreditType))) {
            unset($this->ClientCreditType);
        } else {
            $this->ClientCreditType = $clientCreditType;
        }
        return $this;
    }
    /**
     * Get CouponId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponId()
    {
        return isset($this->CouponId) ? $this->CouponId : null;
    }
    /**
     * Set CouponId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponId
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setCouponId($couponId = null)
    {
        // validation for constraint: string
        if (!is_null($couponId) && !is_string($couponId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponId, true), gettype($couponId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponId, true)), __LINE__);
        }
        if (is_null($couponId) || (is_array($couponId) && empty($couponId))) {
            unset($this->CouponId);
        } else {
            $this->CouponId = $couponId;
        }
        return $this;
    }
    /**
     * Get CreditCardExpiryDateMM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardExpiryDateMM()
    {
        return isset($this->CreditCardExpiryDateMM) ? $this->CreditCardExpiryDateMM : null;
    }
    /**
     * Set CreditCardExpiryDateMM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardExpiryDateMM
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setCreditCardExpiryDateMM($creditCardExpiryDateMM = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardExpiryDateMM) && !is_string($creditCardExpiryDateMM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardExpiryDateMM, true), gettype($creditCardExpiryDateMM)), __LINE__);
        }
        if (is_null($creditCardExpiryDateMM) || (is_array($creditCardExpiryDateMM) && empty($creditCardExpiryDateMM))) {
            unset($this->CreditCardExpiryDateMM);
        } else {
            $this->CreditCardExpiryDateMM = $creditCardExpiryDateMM;
        }
        return $this;
    }
    /**
     * Get CreditCardExpiryDateYY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardExpiryDateYY()
    {
        return isset($this->CreditCardExpiryDateYY) ? $this->CreditCardExpiryDateYY : null;
    }
    /**
     * Set CreditCardExpiryDateYY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardExpiryDateYY
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setCreditCardExpiryDateYY($creditCardExpiryDateYY = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardExpiryDateYY) && !is_string($creditCardExpiryDateYY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardExpiryDateYY, true), gettype($creditCardExpiryDateYY)), __LINE__);
        }
        if (is_null($creditCardExpiryDateYY) || (is_array($creditCardExpiryDateYY) && empty($creditCardExpiryDateYY))) {
            unset($this->CreditCardExpiryDateYY);
        } else {
            $this->CreditCardExpiryDateYY = $creditCardExpiryDateYY;
        }
        return $this;
    }
    /**
     * Get CreditCardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardSuffix()
    {
        return isset($this->CreditCardSuffix) ? $this->CreditCardSuffix : null;
    }
    /**
     * Set CreditCardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardSuffix
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setCreditCardSuffix($creditCardSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardSuffix) && !is_string($creditCardSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardSuffix, true), gettype($creditCardSuffix)), __LINE__);
        }
        if (is_null($creditCardSuffix) || (is_array($creditCardSuffix) && empty($creditCardSuffix))) {
            unset($this->CreditCardSuffix);
        } else {
            $this->CreditCardSuffix = $creditCardSuffix;
        }
        return $this;
    }
    /**
     * Get CreditCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCompanyId()
    {
        return isset($this->CreditCompanyId) ? $this->CreditCompanyId : null;
    }
    /**
     * Set CreditCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCompanyId
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setCreditCompanyId($creditCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($creditCompanyId) && !is_string($creditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCompanyId, true), gettype($creditCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creditCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creditCompanyId, true)), __LINE__);
        }
        if (is_null($creditCompanyId) || (is_array($creditCompanyId) && empty($creditCompanyId))) {
            unset($this->CreditCompanyId);
        } else {
            $this->CreditCompanyId = $creditCompanyId;
        }
        return $this;
    }
    /**
     * Get CreditCompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCompanyName()
    {
        return isset($this->CreditCompanyName) ? $this->CreditCompanyName : null;
    }
    /**
     * Set CreditCompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCompanyName
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setCreditCompanyName($creditCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($creditCompanyName) && !is_string($creditCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCompanyName, true), gettype($creditCompanyName)), __LINE__);
        }
        if (is_null($creditCompanyName) || (is_array($creditCompanyName) && empty($creditCompanyName))) {
            unset($this->CreditCompanyName);
        } else {
            $this->CreditCompanyName = $creditCompanyName;
        }
        return $this;
    }
    /**
     * Get CreditToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditToken()
    {
        return isset($this->CreditToken) ? $this->CreditToken : null;
    }
    /**
     * Set CreditToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditToken
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setCreditToken($creditToken = null)
    {
        // validation for constraint: string
        if (!is_null($creditToken) && !is_string($creditToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditToken, true), gettype($creditToken)), __LINE__);
        }
        if (is_null($creditToken) || (is_array($creditToken) && empty($creditToken))) {
            unset($this->CreditToken);
        } else {
            $this->CreditToken = $creditToken;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get DirectDebitAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectDebitAccountNumber()
    {
        return isset($this->DirectDebitAccountNumber) ? $this->DirectDebitAccountNumber : null;
    }
    /**
     * Set DirectDebitAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directDebitAccountNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setDirectDebitAccountNumber($directDebitAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($directDebitAccountNumber) && !is_string($directDebitAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDebitAccountNumber, true), gettype($directDebitAccountNumber)), __LINE__);
        }
        if (is_null($directDebitAccountNumber) || (is_array($directDebitAccountNumber) && empty($directDebitAccountNumber))) {
            unset($this->DirectDebitAccountNumber);
        } else {
            $this->DirectDebitAccountNumber = $directDebitAccountNumber;
        }
        return $this;
    }
    /**
     * Get DirectDebitBankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectDebitBankCode()
    {
        return isset($this->DirectDebitBankCode) ? $this->DirectDebitBankCode : null;
    }
    /**
     * Set DirectDebitBankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directDebitBankCode
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setDirectDebitBankCode($directDebitBankCode = null)
    {
        // validation for constraint: string
        if (!is_null($directDebitBankCode) && !is_string($directDebitBankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDebitBankCode, true), gettype($directDebitBankCode)), __LINE__);
        }
        if (is_null($directDebitBankCode) || (is_array($directDebitBankCode) && empty($directDebitBankCode))) {
            unset($this->DirectDebitBankCode);
        } else {
            $this->DirectDebitBankCode = $directDebitBankCode;
        }
        return $this;
    }
    /**
     * Get DirectDebitCalculatedAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectDebitCalculatedAccountNumber()
    {
        return isset($this->DirectDebitCalculatedAccountNumber) ? $this->DirectDebitCalculatedAccountNumber : null;
    }
    /**
     * Set DirectDebitCalculatedAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directDebitCalculatedAccountNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setDirectDebitCalculatedAccountNumber($directDebitCalculatedAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($directDebitCalculatedAccountNumber) && !is_string($directDebitCalculatedAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDebitCalculatedAccountNumber, true), gettype($directDebitCalculatedAccountNumber)), __LINE__);
        }
        if (is_null($directDebitCalculatedAccountNumber) || (is_array($directDebitCalculatedAccountNumber) && empty($directDebitCalculatedAccountNumber))) {
            unset($this->DirectDebitCalculatedAccountNumber);
        } else {
            $this->DirectDebitCalculatedAccountNumber = $directDebitCalculatedAccountNumber;
        }
        return $this;
    }
    /**
     * Get DirectDebitGiroAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectDebitGiroAccountNumber()
    {
        return isset($this->DirectDebitGiroAccountNumber) ? $this->DirectDebitGiroAccountNumber : null;
    }
    /**
     * Set DirectDebitGiroAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directDebitGiroAccountNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setDirectDebitGiroAccountNumber($directDebitGiroAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($directDebitGiroAccountNumber) && !is_string($directDebitGiroAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDebitGiroAccountNumber, true), gettype($directDebitGiroAccountNumber)), __LINE__);
        }
        if (is_null($directDebitGiroAccountNumber) || (is_array($directDebitGiroAccountNumber) && empty($directDebitGiroAccountNumber))) {
            unset($this->DirectDebitGiroAccountNumber);
        } else {
            $this->DirectDebitGiroAccountNumber = $directDebitGiroAccountNumber;
        }
        return $this;
    }
    /**
     * Get GiftCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftCardNumber()
    {
        return isset($this->GiftCardNumber) ? $this->GiftCardNumber : null;
    }
    /**
     * Set GiftCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftCardNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setGiftCardNumber($giftCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftCardNumber) && !is_string($giftCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCardNumber, true), gettype($giftCardNumber)), __LINE__);
        }
        if (is_null($giftCardNumber) || (is_array($giftCardNumber) && empty($giftCardNumber))) {
            unset($this->GiftCardNumber);
        } else {
            $this->GiftCardNumber = $giftCardNumber;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherDefinitionId()
    {
        return isset($this->GiftVoucherDefinitionId) ? $this->GiftVoucherDefinitionId : null;
    }
    /**
     * Set GiftVoucherDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherDefinitionId
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setGiftVoucherDefinitionId($giftVoucherDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherDefinitionId) && !is_string($giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherDefinitionId, true), gettype($giftVoucherDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherDefinitionId, true)), __LINE__);
        }
        if (is_null($giftVoucherDefinitionId) || (is_array($giftVoucherDefinitionId) && empty($giftVoucherDefinitionId))) {
            unset($this->GiftVoucherDefinitionId);
        } else {
            $this->GiftVoucherDefinitionId = $giftVoucherDefinitionId;
        }
        return $this;
    }
    /**
     * Get GiftVoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherNumber()
    {
        return isset($this->GiftVoucherNumber) ? $this->GiftVoucherNumber : null;
    }
    /**
     * Set GiftVoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setGiftVoucherNumber($giftVoucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherNumber) && !is_string($giftVoucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherNumber, true), gettype($giftVoucherNumber)), __LINE__);
        }
        if (is_null($giftVoucherNumber) || (is_array($giftVoucherNumber) && empty($giftVoucherNumber))) {
            unset($this->GiftVoucherNumber);
        } else {
            $this->GiftVoucherNumber = $giftVoucherNumber;
        }
        return $this;
    }
    /**
     * Get InstalmentsString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstalmentsString()
    {
        return isset($this->InstalmentsString) ? $this->InstalmentsString : null;
    }
    /**
     * Set InstalmentsString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instalmentsString
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setInstalmentsString($instalmentsString = null)
    {
        // validation for constraint: string
        if (!is_null($instalmentsString) && !is_string($instalmentsString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instalmentsString, true), gettype($instalmentsString)), __LINE__);
        }
        if (is_null($instalmentsString) || (is_array($instalmentsString) && empty($instalmentsString))) {
            unset($this->InstalmentsString);
        } else {
            $this->InstalmentsString = $instalmentsString;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateNumber()
    {
        return isset($this->MandateNumber) ? $this->MandateNumber : null;
    }
    /**
     * Set MandateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: int
        if (!is_null($mandateNumber) && !(is_int($mandateNumber) || ctype_digit($mandateNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateNumber, true), gettype($mandateNumber)), __LINE__);
        }
        if (is_null($mandateNumber) || (is_array($mandateNumber) && empty($mandateNumber))) {
            unset($this->MandateNumber);
        } else {
            $this->MandateNumber = $mandateNumber;
        }
        return $this;
    }
    /**
     * Get MandateTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateTypeId()
    {
        return isset($this->MandateTypeId) ? $this->MandateTypeId : null;
    }
    /**
     * Set MandateTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateTypeId
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setMandateTypeId($mandateTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateTypeId) && !is_string($mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateTypeId, true), gettype($mandateTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateTypeId, true)), __LINE__);
        }
        if (is_null($mandateTypeId) || (is_array($mandateTypeId) && empty($mandateTypeId))) {
            unset($this->MandateTypeId);
        } else {
            $this->MandateTypeId = $mandateTypeId;
        }
        return $this;
    }
    /**
     * Get OnlineGatewayTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineGatewayTransactionId()
    {
        return isset($this->OnlineGatewayTransactionId) ? $this->OnlineGatewayTransactionId : null;
    }
    /**
     * Set OnlineGatewayTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineGatewayTransactionId
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setOnlineGatewayTransactionId($onlineGatewayTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($onlineGatewayTransactionId) && !is_string($onlineGatewayTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineGatewayTransactionId, true), gettype($onlineGatewayTransactionId)), __LINE__);
        }
        if (is_null($onlineGatewayTransactionId) || (is_array($onlineGatewayTransactionId) && empty($onlineGatewayTransactionId))) {
            unset($this->OnlineGatewayTransactionId);
        } else {
            $this->OnlineGatewayTransactionId = $onlineGatewayTransactionId;
        }
        return $this;
    }
    /**
     * Get OnlineReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineReferenceNumber()
    {
        return isset($this->OnlineReferenceNumber) ? $this->OnlineReferenceNumber : null;
    }
    /**
     * Set OnlineReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineReferenceNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setOnlineReferenceNumber($onlineReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($onlineReferenceNumber) && !is_string($onlineReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineReferenceNumber, true), gettype($onlineReferenceNumber)), __LINE__);
        }
        if (is_null($onlineReferenceNumber) || (is_array($onlineReferenceNumber) && empty($onlineReferenceNumber))) {
            unset($this->OnlineReferenceNumber);
        } else {
            $this->OnlineReferenceNumber = $onlineReferenceNumber;
        }
        return $this;
    }
    /**
     * Get OriginalTokenIdToReplace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTokenIdToReplace()
    {
        return isset($this->OriginalTokenIdToReplace) ? $this->OriginalTokenIdToReplace : null;
    }
    /**
     * Set OriginalTokenIdToReplace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTokenIdToReplace
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setOriginalTokenIdToReplace($originalTokenIdToReplace = null)
    {
        // validation for constraint: string
        if (!is_null($originalTokenIdToReplace) && !is_string($originalTokenIdToReplace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTokenIdToReplace, true), gettype($originalTokenIdToReplace)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTokenIdToReplace) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTokenIdToReplace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTokenIdToReplace, true)), __LINE__);
        }
        if (is_null($originalTokenIdToReplace) || (is_array($originalTokenIdToReplace) && empty($originalTokenIdToReplace))) {
            unset($this->OriginalTokenIdToReplace);
        } else {
            $this->OriginalTokenIdToReplace = $originalTokenIdToReplace;
        }
        return $this;
    }
    /**
     * Get PaymentPlanScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanScheduleId()
    {
        return isset($this->PaymentPlanScheduleId) ? $this->PaymentPlanScheduleId : null;
    }
    /**
     * Set PaymentPlanScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanScheduleId
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setPaymentPlanScheduleId($paymentPlanScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanScheduleId) && !is_string($paymentPlanScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanScheduleId, true), gettype($paymentPlanScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanScheduleId, true)), __LINE__);
        }
        if (is_null($paymentPlanScheduleId) || (is_array($paymentPlanScheduleId) && empty($paymentPlanScheduleId))) {
            unset($this->PaymentPlanScheduleId);
        } else {
            $this->PaymentPlanScheduleId = $paymentPlanScheduleId;
        }
        return $this;
    }
    /**
     * Get ReceiptId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiptId()
    {
        return isset($this->ReceiptId) ? $this->ReceiptId : null;
    }
    /**
     * Set ReceiptId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiptId
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setReceiptId($receiptId = null)
    {
        // validation for constraint: string
        if (!is_null($receiptId) && !is_string($receiptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptId, true), gettype($receiptId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($receiptId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $receiptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($receiptId, true)), __LINE__);
        }
        if (is_null($receiptId) || (is_array($receiptId) && empty($receiptId))) {
            unset($this->ReceiptId);
        } else {
            $this->ReceiptId = $receiptId;
        }
        return $this;
    }
    /**
     * Get ReceiptNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReceiptNumber()
    {
        return isset($this->ReceiptNumber) ? $this->ReceiptNumber : null;
    }
    /**
     * Set ReceiptNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $receiptNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setReceiptNumber($receiptNumber = null)
    {
        // validation for constraint: int
        if (!is_null($receiptNumber) && !(is_int($receiptNumber) || ctype_digit($receiptNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receiptNumber, true), gettype($receiptNumber)), __LINE__);
        }
        if (is_null($receiptNumber) || (is_array($receiptNumber) && empty($receiptNumber))) {
            unset($this->ReceiptNumber);
        } else {
            $this->ReceiptNumber = $receiptNumber;
        }
        return $this;
    }
    /**
     * Get RefundIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRefundIcon()
    {
        return isset($this->RefundIcon) ? $this->RefundIcon : null;
    }
    /**
     * Set RefundIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $refundIcon
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setRefundIcon($refundIcon = null)
    {
        // validation for constraint: int
        if (!is_null($refundIcon) && !(is_int($refundIcon) || ctype_digit($refundIcon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refundIcon, true), gettype($refundIcon)), __LINE__);
        }
        if (is_null($refundIcon) || (is_array($refundIcon) && empty($refundIcon))) {
            unset($this->RefundIcon);
        } else {
            $this->RefundIcon = $refundIcon;
        }
        return $this;
    }
    /**
     * Get RefundReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRefundReferenceNumber()
    {
        return isset($this->RefundReferenceNumber) ? $this->RefundReferenceNumber : null;
    }
    /**
     * Set RefundReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $refundReferenceNumber
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setRefundReferenceNumber($refundReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($refundReferenceNumber) && !(is_int($refundReferenceNumber) || ctype_digit($refundReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refundReferenceNumber, true), gettype($refundReferenceNumber)), __LINE__);
        }
        if (is_null($refundReferenceNumber) || (is_array($refundReferenceNumber) && empty($refundReferenceNumber))) {
            unset($this->RefundReferenceNumber);
        } else {
            $this->RefundReferenceNumber = $refundReferenceNumber;
        }
        return $this;
    }
    /**
     * Get SpecialPaymentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecialPaymentId()
    {
        return isset($this->SpecialPaymentId) ? $this->SpecialPaymentId : null;
    }
    /**
     * Set SpecialPaymentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specialPaymentId
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setSpecialPaymentId($specialPaymentId = null)
    {
        // validation for constraint: string
        if (!is_null($specialPaymentId) && !is_string($specialPaymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialPaymentId, true), gettype($specialPaymentId)), __LINE__);
        }
        if (is_null($specialPaymentId) || (is_array($specialPaymentId) && empty($specialPaymentId))) {
            unset($this->SpecialPaymentId);
        } else {
            $this->SpecialPaymentId = $specialPaymentId;
        }
        return $this;
    }
    /**
     * Get SpecialPaymentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecialPaymentName()
    {
        return isset($this->SpecialPaymentName) ? $this->SpecialPaymentName : null;
    }
    /**
     * Set SpecialPaymentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specialPaymentName
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setSpecialPaymentName($specialPaymentName = null)
    {
        // validation for constraint: string
        if (!is_null($specialPaymentName) && !is_string($specialPaymentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialPaymentName, true), gettype($specialPaymentName)), __LINE__);
        }
        if (is_null($specialPaymentName) || (is_array($specialPaymentName) && empty($specialPaymentName))) {
            unset($this->SpecialPaymentName);
        } else {
            $this->SpecialPaymentName = $specialPaymentName;
        }
        return $this;
    }
    /**
     * Get WithdrawClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWithdrawClientId()
    {
        return isset($this->WithdrawClientId) ? $this->WithdrawClientId : null;
    }
    /**
     * Set WithdrawClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $withdrawClientId
     * @return \patest\StructType\Payment_PaymentSearchData
     */
    public function setWithdrawClientId($withdrawClientId = null)
    {
        // validation for constraint: string
        if (!is_null($withdrawClientId) && !is_string($withdrawClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($withdrawClientId, true), gettype($withdrawClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($withdrawClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $withdrawClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($withdrawClientId, true)), __LINE__);
        }
        if (is_null($withdrawClientId) || (is_array($withdrawClientId) && empty($withdrawClientId))) {
            unset($this->WithdrawClientId);
        } else {
            $this->WithdrawClientId = $withdrawClientId;
        }
        return $this;
    }
}
