<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentMethodSubType StructType
 * @subpackage Structs
 */
class Payment_PaymentMethodSubType extends AnyEntity
{
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The SubTypeFormNameUnify
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubTypeFormNameUnify;
    /**
     * The SubTypeInputFormLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubTypeInputFormLocalId;
    /**
     * The SubTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubTypeName;
    /**
     * The SubTypeTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubTypeTitle;
    /**
     * Constructor method for Payment.PaymentMethodSubType
     * @uses Payment_PaymentMethodSubType::setPaymentMethodType()
     * @uses Payment_PaymentMethodSubType::setSubTypeFormNameUnify()
     * @uses Payment_PaymentMethodSubType::setSubTypeInputFormLocalId()
     * @uses Payment_PaymentMethodSubType::setSubTypeName()
     * @uses Payment_PaymentMethodSubType::setSubTypeTitle()
     * @param string $paymentMethodType
     * @param string $subTypeFormNameUnify
     * @param string $subTypeInputFormLocalId
     * @param string $subTypeName
     * @param string $subTypeTitle
     */
    public function __construct($paymentMethodType = null, $subTypeFormNameUnify = null, $subTypeInputFormLocalId = null, $subTypeName = null, $subTypeTitle = null)
    {
        $this
            ->setPaymentMethodType($paymentMethodType)
            ->setSubTypeFormNameUnify($subTypeFormNameUnify)
            ->setSubTypeInputFormLocalId($subTypeInputFormLocalId)
            ->setSubTypeName($subTypeName)
            ->setSubTypeTitle($subTypeTitle);
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\Payment_PaymentMethodSubType
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get SubTypeFormNameUnify value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubTypeFormNameUnify()
    {
        return isset($this->SubTypeFormNameUnify) ? $this->SubTypeFormNameUnify : null;
    }
    /**
     * Set SubTypeFormNameUnify value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subTypeFormNameUnify
     * @return \patest\StructType\Payment_PaymentMethodSubType
     */
    public function setSubTypeFormNameUnify($subTypeFormNameUnify = null)
    {
        // validation for constraint: string
        if (!is_null($subTypeFormNameUnify) && !is_string($subTypeFormNameUnify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTypeFormNameUnify, true), gettype($subTypeFormNameUnify)), __LINE__);
        }
        if (is_null($subTypeFormNameUnify) || (is_array($subTypeFormNameUnify) && empty($subTypeFormNameUnify))) {
            unset($this->SubTypeFormNameUnify);
        } else {
            $this->SubTypeFormNameUnify = $subTypeFormNameUnify;
        }
        return $this;
    }
    /**
     * Get SubTypeInputFormLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubTypeInputFormLocalId()
    {
        return isset($this->SubTypeInputFormLocalId) ? $this->SubTypeInputFormLocalId : null;
    }
    /**
     * Set SubTypeInputFormLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subTypeInputFormLocalId
     * @return \patest\StructType\Payment_PaymentMethodSubType
     */
    public function setSubTypeInputFormLocalId($subTypeInputFormLocalId = null)
    {
        // validation for constraint: string
        if (!is_null($subTypeInputFormLocalId) && !is_string($subTypeInputFormLocalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTypeInputFormLocalId, true), gettype($subTypeInputFormLocalId)), __LINE__);
        }
        if (is_null($subTypeInputFormLocalId) || (is_array($subTypeInputFormLocalId) && empty($subTypeInputFormLocalId))) {
            unset($this->SubTypeInputFormLocalId);
        } else {
            $this->SubTypeInputFormLocalId = $subTypeInputFormLocalId;
        }
        return $this;
    }
    /**
     * Get SubTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubTypeName()
    {
        return isset($this->SubTypeName) ? $this->SubTypeName : null;
    }
    /**
     * Set SubTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subTypeName
     * @return \patest\StructType\Payment_PaymentMethodSubType
     */
    public function setSubTypeName($subTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($subTypeName) && !is_string($subTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTypeName, true), gettype($subTypeName)), __LINE__);
        }
        if (is_null($subTypeName) || (is_array($subTypeName) && empty($subTypeName))) {
            unset($this->SubTypeName);
        } else {
            $this->SubTypeName = $subTypeName;
        }
        return $this;
    }
    /**
     * Get SubTypeTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubTypeTitle()
    {
        return isset($this->SubTypeTitle) ? $this->SubTypeTitle : null;
    }
    /**
     * Set SubTypeTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subTypeTitle
     * @return \patest\StructType\Payment_PaymentMethodSubType
     */
    public function setSubTypeTitle($subTypeTitle = null)
    {
        // validation for constraint: string
        if (!is_null($subTypeTitle) && !is_string($subTypeTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTypeTitle, true), gettype($subTypeTitle)), __LINE__);
        }
        if (is_null($subTypeTitle) || (is_array($subTypeTitle) && empty($subTypeTitle))) {
            unset($this->SubTypeTitle);
        } else {
            $this->SubTypeTitle = $subTypeTitle;
        }
        return $this;
    }
}
