<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentMethodMedia StructType
 * @subpackage Structs
 */
class Payment_PaymentMethodMedia extends PersistableEntity
{
    /**
     * The AlternativeImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AlternativeImageId;
    /**
     * The ConfirmationText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ConfirmationText;
    /**
     * The EffectiveImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveImageUrl;
    /**
     * The InstructionText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $InstructionText;
    /**
     * The IntroductoryText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $IntroductoryText;
    /**
     * The PrimaryImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrimaryImageId;
    /**
     * The SummaryText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SummaryText;
    /**
     * Constructor method for Payment.PaymentMethodMedia
     * @uses Payment_PaymentMethodMedia::setAlternativeImageId()
     * @uses Payment_PaymentMethodMedia::setConfirmationText()
     * @uses Payment_PaymentMethodMedia::setEffectiveImageUrl()
     * @uses Payment_PaymentMethodMedia::setInstructionText()
     * @uses Payment_PaymentMethodMedia::setIntroductoryText()
     * @uses Payment_PaymentMethodMedia::setPrimaryImageId()
     * @uses Payment_PaymentMethodMedia::setSummaryText()
     * @param int $alternativeImageId
     * @param \patest\StructType\GlobalString $confirmationText
     * @param string $effectiveImageUrl
     * @param \patest\StructType\GlobalString $instructionText
     * @param \patest\StructType\GlobalString $introductoryText
     * @param int $primaryImageId
     * @param \patest\StructType\GlobalString $summaryText
     */
    public function __construct($alternativeImageId = null, \patest\StructType\GlobalString $confirmationText = null, $effectiveImageUrl = null, \patest\StructType\GlobalString $instructionText = null, \patest\StructType\GlobalString $introductoryText = null, $primaryImageId = null, \patest\StructType\GlobalString $summaryText = null)
    {
        $this
            ->setAlternativeImageId($alternativeImageId)
            ->setConfirmationText($confirmationText)
            ->setEffectiveImageUrl($effectiveImageUrl)
            ->setInstructionText($instructionText)
            ->setIntroductoryText($introductoryText)
            ->setPrimaryImageId($primaryImageId)
            ->setSummaryText($summaryText);
    }
    /**
     * Get AlternativeImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAlternativeImageId()
    {
        return isset($this->AlternativeImageId) ? $this->AlternativeImageId : null;
    }
    /**
     * Set AlternativeImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $alternativeImageId
     * @return \patest\StructType\Payment_PaymentMethodMedia
     */
    public function setAlternativeImageId($alternativeImageId = null)
    {
        // validation for constraint: int
        if (!is_null($alternativeImageId) && !(is_int($alternativeImageId) || ctype_digit($alternativeImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alternativeImageId, true), gettype($alternativeImageId)), __LINE__);
        }
        if (is_null($alternativeImageId) || (is_array($alternativeImageId) && empty($alternativeImageId))) {
            unset($this->AlternativeImageId);
        } else {
            $this->AlternativeImageId = $alternativeImageId;
        }
        return $this;
    }
    /**
     * Get ConfirmationText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getConfirmationText()
    {
        return isset($this->ConfirmationText) ? $this->ConfirmationText : null;
    }
    /**
     * Set ConfirmationText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $confirmationText
     * @return \patest\StructType\Payment_PaymentMethodMedia
     */
    public function setConfirmationText(\patest\StructType\GlobalString $confirmationText = null)
    {
        if (is_null($confirmationText) || (is_array($confirmationText) && empty($confirmationText))) {
            unset($this->ConfirmationText);
        } else {
            $this->ConfirmationText = $confirmationText;
        }
        return $this;
    }
    /**
     * Get EffectiveImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveImageUrl()
    {
        return isset($this->EffectiveImageUrl) ? $this->EffectiveImageUrl : null;
    }
    /**
     * Set EffectiveImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveImageUrl
     * @return \patest\StructType\Payment_PaymentMethodMedia
     */
    public function setEffectiveImageUrl($effectiveImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveImageUrl) && !is_string($effectiveImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveImageUrl, true), gettype($effectiveImageUrl)), __LINE__);
        }
        if (is_null($effectiveImageUrl) || (is_array($effectiveImageUrl) && empty($effectiveImageUrl))) {
            unset($this->EffectiveImageUrl);
        } else {
            $this->EffectiveImageUrl = $effectiveImageUrl;
        }
        return $this;
    }
    /**
     * Get InstructionText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getInstructionText()
    {
        return isset($this->InstructionText) ? $this->InstructionText : null;
    }
    /**
     * Set InstructionText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $instructionText
     * @return \patest\StructType\Payment_PaymentMethodMedia
     */
    public function setInstructionText(\patest\StructType\GlobalString $instructionText = null)
    {
        if (is_null($instructionText) || (is_array($instructionText) && empty($instructionText))) {
            unset($this->InstructionText);
        } else {
            $this->InstructionText = $instructionText;
        }
        return $this;
    }
    /**
     * Get IntroductoryText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getIntroductoryText()
    {
        return isset($this->IntroductoryText) ? $this->IntroductoryText : null;
    }
    /**
     * Set IntroductoryText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $introductoryText
     * @return \patest\StructType\Payment_PaymentMethodMedia
     */
    public function setIntroductoryText(\patest\StructType\GlobalString $introductoryText = null)
    {
        if (is_null($introductoryText) || (is_array($introductoryText) && empty($introductoryText))) {
            unset($this->IntroductoryText);
        } else {
            $this->IntroductoryText = $introductoryText;
        }
        return $this;
    }
    /**
     * Get PrimaryImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrimaryImageId()
    {
        return isset($this->PrimaryImageId) ? $this->PrimaryImageId : null;
    }
    /**
     * Set PrimaryImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $primaryImageId
     * @return \patest\StructType\Payment_PaymentMethodMedia
     */
    public function setPrimaryImageId($primaryImageId = null)
    {
        // validation for constraint: int
        if (!is_null($primaryImageId) && !(is_int($primaryImageId) || ctype_digit($primaryImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($primaryImageId, true), gettype($primaryImageId)), __LINE__);
        }
        if (is_null($primaryImageId) || (is_array($primaryImageId) && empty($primaryImageId))) {
            unset($this->PrimaryImageId);
        } else {
            $this->PrimaryImageId = $primaryImageId;
        }
        return $this;
    }
    /**
     * Get SummaryText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSummaryText()
    {
        return isset($this->SummaryText) ? $this->SummaryText : null;
    }
    /**
     * Set SummaryText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $summaryText
     * @return \patest\StructType\Payment_PaymentMethodMedia
     */
    public function setSummaryText(\patest\StructType\GlobalString $summaryText = null)
    {
        if (is_null($summaryText) || (is_array($summaryText) && empty($summaryText))) {
            unset($this->SummaryText);
        } else {
            $this->SummaryText = $summaryText;
        }
        return $this;
    }
}
