<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.PaymentDetailsFilter StructType
 * @subpackage Structs
 */
class Payment_PaymentDetailsFilter extends FilterEntity
{
    /**
     * The CommitDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDateFrom;
    /**
     * The CommitDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDateTo;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PaymentMethodId
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The SoldByUser
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SoldByUser;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Payment.PaymentDetailsFilter
     * @uses Payment_PaymentDetailsFilter::setCommitDateFrom()
     * @uses Payment_PaymentDetailsFilter::setCommitDateTo()
     * @uses Payment_PaymentDetailsFilter::setPaymentMethodId()
     * @uses Payment_PaymentDetailsFilter::setPaymentMethodType()
     * @uses Payment_PaymentDetailsFilter::setSoldByUser()
     * @uses Payment_PaymentDetailsFilter::setTransactionNumber()
     * @param string $commitDateFrom
     * @param string $commitDateTo
     * @param \patest\StructType\PaymentMethodId $paymentMethodId
     * @param string $paymentMethodType
     * @param string $soldByUser
     * @param int $transactionNumber
     */
    public function __construct($commitDateFrom = null, $commitDateTo = null, \patest\StructType\PaymentMethodId $paymentMethodId = null, $paymentMethodType = null, $soldByUser = null, $transactionNumber = null)
    {
        $this
            ->setCommitDateFrom($commitDateFrom)
            ->setCommitDateTo($commitDateTo)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodType($paymentMethodType)
            ->setSoldByUser($soldByUser)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get CommitDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDateFrom()
    {
        return isset($this->CommitDateFrom) ? $this->CommitDateFrom : null;
    }
    /**
     * Set CommitDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDateFrom
     * @return \patest\StructType\Payment_PaymentDetailsFilter
     */
    public function setCommitDateFrom($commitDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($commitDateFrom) && !is_string($commitDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDateFrom, true), gettype($commitDateFrom)), __LINE__);
        }
        if (is_null($commitDateFrom) || (is_array($commitDateFrom) && empty($commitDateFrom))) {
            unset($this->CommitDateFrom);
        } else {
            $this->CommitDateFrom = $commitDateFrom;
        }
        return $this;
    }
    /**
     * Get CommitDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDateTo()
    {
        return isset($this->CommitDateTo) ? $this->CommitDateTo : null;
    }
    /**
     * Set CommitDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDateTo
     * @return \patest\StructType\Payment_PaymentDetailsFilter
     */
    public function setCommitDateTo($commitDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($commitDateTo) && !is_string($commitDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDateTo, true), gettype($commitDateTo)), __LINE__);
        }
        if (is_null($commitDateTo) || (is_array($commitDateTo) && empty($commitDateTo))) {
            unset($this->CommitDateTo);
        } else {
            $this->CommitDateTo = $commitDateTo;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PaymentMethodId|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PaymentMethodId $paymentMethodId
     * @return \patest\StructType\Payment_PaymentDetailsFilter
     */
    public function setPaymentMethodId(\patest\StructType\PaymentMethodId $paymentMethodId = null)
    {
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\Payment_PaymentDetailsFilter
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get SoldByUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoldByUser()
    {
        return isset($this->SoldByUser) ? $this->SoldByUser : null;
    }
    /**
     * Set SoldByUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $soldByUser
     * @return \patest\StructType\Payment_PaymentDetailsFilter
     */
    public function setSoldByUser($soldByUser = null)
    {
        // validation for constraint: string
        if (!is_null($soldByUser) && !is_string($soldByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soldByUser, true), gettype($soldByUser)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($soldByUser) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $soldByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($soldByUser, true)), __LINE__);
        }
        if (is_null($soldByUser) || (is_array($soldByUser) && empty($soldByUser))) {
            unset($this->SoldByUser);
        } else {
            $this->SoldByUser = $soldByUser;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Payment_PaymentDetailsFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
