<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.OnlinePaymentPaymentItemInformation StructType
 * @subpackage Structs
 */
class Payment_OnlinePaymentPaymentItemInformation extends Payment_BasePaymentItemInformation
{
    /**
     * The CardNumberMask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumberMask;
    /**
     * The GatewayTransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GatewayTransactionId;
    /**
     * The Installments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Installments;
    /**
     * The LocalRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalRefNumber;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceNumber;
    /**
     * Constructor method for Payment.OnlinePaymentPaymentItemInformation
     * @uses Payment_OnlinePaymentPaymentItemInformation::setCardNumberMask()
     * @uses Payment_OnlinePaymentPaymentItemInformation::setGatewayTransactionId()
     * @uses Payment_OnlinePaymentPaymentItemInformation::setInstallments()
     * @uses Payment_OnlinePaymentPaymentItemInformation::setLocalRefNumber()
     * @uses Payment_OnlinePaymentPaymentItemInformation::setReferenceNumber()
     * @param string $cardNumberMask
     * @param string $gatewayTransactionId
     * @param int $installments
     * @param int $localRefNumber
     * @param string $referenceNumber
     */
    public function __construct($cardNumberMask = null, $gatewayTransactionId = null, $installments = null, $localRefNumber = null, $referenceNumber = null)
    {
        $this
            ->setCardNumberMask($cardNumberMask)
            ->setGatewayTransactionId($gatewayTransactionId)
            ->setInstallments($installments)
            ->setLocalRefNumber($localRefNumber)
            ->setReferenceNumber($referenceNumber);
    }
    /**
     * Get CardNumberMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumberMask()
    {
        return isset($this->CardNumberMask) ? $this->CardNumberMask : null;
    }
    /**
     * Set CardNumberMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumberMask
     * @return \patest\StructType\Payment_OnlinePaymentPaymentItemInformation
     */
    public function setCardNumberMask($cardNumberMask = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumberMask) && !is_string($cardNumberMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumberMask, true), gettype($cardNumberMask)), __LINE__);
        }
        if (is_null($cardNumberMask) || (is_array($cardNumberMask) && empty($cardNumberMask))) {
            unset($this->CardNumberMask);
        } else {
            $this->CardNumberMask = $cardNumberMask;
        }
        return $this;
    }
    /**
     * Get GatewayTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGatewayTransactionId()
    {
        return isset($this->GatewayTransactionId) ? $this->GatewayTransactionId : null;
    }
    /**
     * Set GatewayTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gatewayTransactionId
     * @return \patest\StructType\Payment_OnlinePaymentPaymentItemInformation
     */
    public function setGatewayTransactionId($gatewayTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($gatewayTransactionId) && !is_string($gatewayTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gatewayTransactionId, true), gettype($gatewayTransactionId)), __LINE__);
        }
        if (is_null($gatewayTransactionId) || (is_array($gatewayTransactionId) && empty($gatewayTransactionId))) {
            unset($this->GatewayTransactionId);
        } else {
            $this->GatewayTransactionId = $gatewayTransactionId;
        }
        return $this;
    }
    /**
     * Get Installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInstallments()
    {
        return isset($this->Installments) ? $this->Installments : null;
    }
    /**
     * Set Installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $installments
     * @return \patest\StructType\Payment_OnlinePaymentPaymentItemInformation
     */
    public function setInstallments($installments = null)
    {
        // validation for constraint: int
        if (!is_null($installments) && !(is_int($installments) || ctype_digit($installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($installments, true), gettype($installments)), __LINE__);
        }
        if (is_null($installments) || (is_array($installments) && empty($installments))) {
            unset($this->Installments);
        } else {
            $this->Installments = $installments;
        }
        return $this;
    }
    /**
     * Get LocalRefNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalRefNumber()
    {
        return isset($this->LocalRefNumber) ? $this->LocalRefNumber : null;
    }
    /**
     * Set LocalRefNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localRefNumber
     * @return \patest\StructType\Payment_OnlinePaymentPaymentItemInformation
     */
    public function setLocalRefNumber($localRefNumber = null)
    {
        // validation for constraint: int
        if (!is_null($localRefNumber) && !(is_int($localRefNumber) || ctype_digit($localRefNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localRefNumber, true), gettype($localRefNumber)), __LINE__);
        }
        if (is_null($localRefNumber) || (is_array($localRefNumber) && empty($localRefNumber))) {
            unset($this->LocalRefNumber);
        } else {
            $this->LocalRefNumber = $localRefNumber;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceNumber
     * @return \patest\StructType\Payment_OnlinePaymentPaymentItemInformation
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
}
