<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.LoyaltyPointsAudit StructType
 * @subpackage Structs
 */
class Payment_LoyaltyPointsAudit extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Error;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Event;
    /**
     * The IntegrationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntegrationId;
    /**
     * The OperationDuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationDuration;
    /**
     * The Points
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Points;
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Request;
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Response;
    /**
     * The StartExecutionDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartExecutionDateTime;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Payment.LoyaltyPointsAudit
     * @uses Payment_LoyaltyPointsAudit::setClientId()
     * @uses Payment_LoyaltyPointsAudit::setError()
     * @uses Payment_LoyaltyPointsAudit::setEvent()
     * @uses Payment_LoyaltyPointsAudit::setIntegrationId()
     * @uses Payment_LoyaltyPointsAudit::setOperationDuration()
     * @uses Payment_LoyaltyPointsAudit::setPoints()
     * @uses Payment_LoyaltyPointsAudit::setRequest()
     * @uses Payment_LoyaltyPointsAudit::setResponse()
     * @uses Payment_LoyaltyPointsAudit::setStartExecutionDateTime()
     * @uses Payment_LoyaltyPointsAudit::setUserId()
     * @param string $clientId
     * @param string $error
     * @param string $event
     * @param string $integrationId
     * @param string $operationDuration
     * @param float $points
     * @param string $request
     * @param string $response
     * @param string $startExecutionDateTime
     * @param string $userId
     */
    public function __construct($clientId = null, $error = null, $event = null, $integrationId = null, $operationDuration = null, $points = null, $request = null, $response = null, $startExecutionDateTime = null, $userId = null)
    {
        $this
            ->setClientId($clientId)
            ->setError($error)
            ->setEvent($event)
            ->setIntegrationId($integrationId)
            ->setOperationDuration($operationDuration)
            ->setPoints($points)
            ->setRequest($request)
            ->setResponse($response)
            ->setStartExecutionDateTime($startExecutionDateTime)
            ->setUserId($userId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_LoyaltyPointsAudit
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $error
     * @return \patest\StructType\Payment_LoyaltyPointsAudit
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get Event value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvent()
    {
        return isset($this->Event) ? $this->Event : null;
    }
    /**
     * Set Event value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LoyaltyPointsOperationEvent::valueIsValid()
     * @uses \patest\EnumType\LoyaltyPointsOperationEvent::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $event
     * @return \patest\StructType\Payment_LoyaltyPointsAudit
     */
    public function setEvent($event = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LoyaltyPointsOperationEvent::valueIsValid($event)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LoyaltyPointsOperationEvent', is_array($event) ? implode(', ', $event) : var_export($event, true), implode(', ', \patest\EnumType\LoyaltyPointsOperationEvent::getValidValues())), __LINE__);
        }
        if (is_null($event) || (is_array($event) && empty($event))) {
            unset($this->Event);
        } else {
            $this->Event = $event;
        }
        return $this;
    }
    /**
     * Get IntegrationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntegrationId()
    {
        return isset($this->IntegrationId) ? $this->IntegrationId : null;
    }
    /**
     * Set IntegrationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $integrationId
     * @return \patest\StructType\Payment_LoyaltyPointsAudit
     */
    public function setIntegrationId($integrationId = null)
    {
        // validation for constraint: string
        if (!is_null($integrationId) && !is_string($integrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationId, true), gettype($integrationId)), __LINE__);
        }
        if (is_null($integrationId) || (is_array($integrationId) && empty($integrationId))) {
            unset($this->IntegrationId);
        } else {
            $this->IntegrationId = $integrationId;
        }
        return $this;
    }
    /**
     * Get OperationDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationDuration()
    {
        return isset($this->OperationDuration) ? $this->OperationDuration : null;
    }
    /**
     * Set OperationDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationDuration
     * @return \patest\StructType\Payment_LoyaltyPointsAudit
     */
    public function setOperationDuration($operationDuration = null)
    {
        // validation for constraint: string
        if (!is_null($operationDuration) && !is_string($operationDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationDuration, true), gettype($operationDuration)), __LINE__);
        }
        if (is_null($operationDuration) || (is_array($operationDuration) && empty($operationDuration))) {
            unset($this->OperationDuration);
        } else {
            $this->OperationDuration = $operationDuration;
        }
        return $this;
    }
    /**
     * Get Points value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPoints()
    {
        return isset($this->Points) ? $this->Points : null;
    }
    /**
     * Set Points value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $points
     * @return \patest\StructType\Payment_LoyaltyPointsAudit
     */
    public function setPoints($points = null)
    {
        // validation for constraint: float
        if (!is_null($points) && !(is_float($points) || is_numeric($points))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($points, true), gettype($points)), __LINE__);
        }
        if (is_null($points) || (is_array($points) && empty($points))) {
            unset($this->Points);
        } else {
            $this->Points = $points;
        }
        return $this;
    }
    /**
     * Get Request value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequest()
    {
        return isset($this->Request) ? $this->Request : null;
    }
    /**
     * Set Request value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $request
     * @return \patest\StructType\Payment_LoyaltyPointsAudit
     */
    public function setRequest($request = null)
    {
        // validation for constraint: string
        if (!is_null($request) && !is_string($request)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request, true), gettype($request)), __LINE__);
        }
        if (is_null($request) || (is_array($request) && empty($request))) {
            unset($this->Request);
        } else {
            $this->Request = $request;
        }
        return $this;
    }
    /**
     * Get Response value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponse()
    {
        return isset($this->Response) ? $this->Response : null;
    }
    /**
     * Set Response value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $response
     * @return \patest\StructType\Payment_LoyaltyPointsAudit
     */
    public function setResponse($response = null)
    {
        // validation for constraint: string
        if (!is_null($response) && !is_string($response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response, true), gettype($response)), __LINE__);
        }
        if (is_null($response) || (is_array($response) && empty($response))) {
            unset($this->Response);
        } else {
            $this->Response = $response;
        }
        return $this;
    }
    /**
     * Get StartExecutionDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartExecutionDateTime()
    {
        return isset($this->StartExecutionDateTime) ? $this->StartExecutionDateTime : null;
    }
    /**
     * Set StartExecutionDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startExecutionDateTime
     * @return \patest\StructType\Payment_LoyaltyPointsAudit
     */
    public function setStartExecutionDateTime($startExecutionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startExecutionDateTime) && !is_string($startExecutionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startExecutionDateTime, true), gettype($startExecutionDateTime)), __LINE__);
        }
        if (is_null($startExecutionDateTime) || (is_array($startExecutionDateTime) && empty($startExecutionDateTime))) {
            unset($this->StartExecutionDateTime);
        } else {
            $this->StartExecutionDateTime = $startExecutionDateTime;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Payment_LoyaltyPointsAudit
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
