<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.InboundPaymentFileItem StructType
 * @subpackage Structs
 */
class Payment_InboundPaymentFileItem extends PersistableEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Direction;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorCode;
    /**
     * The ErrorText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorText;
    /**
     * The FileId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FileId;
    /**
     * The FormatedStructuredCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormatedStructuredCode;
    /**
     * The IndexInFile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IndexInFile;
    /**
     * The ItemData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemData;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The PayerAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayerAccount;
    /**
     * The PayerInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayerInfo;
    /**
     * The PaymentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The StructuredCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StructuredCode;
    /**
     * The StructuredCodeIntegrity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StructuredCodeIntegrity;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionId;
    /**
     * The TransferCode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransferCode;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The TypeFamily
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeFamily;
    /**
     * Constructor method for Payment.InboundPaymentFileItem
     * @uses Payment_InboundPaymentFileItem::setAmount()
     * @uses Payment_InboundPaymentFileItem::setDirection()
     * @uses Payment_InboundPaymentFileItem::setErrorCode()
     * @uses Payment_InboundPaymentFileItem::setErrorText()
     * @uses Payment_InboundPaymentFileItem::setFileId()
     * @uses Payment_InboundPaymentFileItem::setFormatedStructuredCode()
     * @uses Payment_InboundPaymentFileItem::setIndexInFile()
     * @uses Payment_InboundPaymentFileItem::setItemData()
     * @uses Payment_InboundPaymentFileItem::setMessage()
     * @uses Payment_InboundPaymentFileItem::setPayerAccount()
     * @uses Payment_InboundPaymentFileItem::setPayerInfo()
     * @uses Payment_InboundPaymentFileItem::setPaymentDate()
     * @uses Payment_InboundPaymentFileItem::setStatus()
     * @uses Payment_InboundPaymentFileItem::setStructuredCode()
     * @uses Payment_InboundPaymentFileItem::setStructuredCodeIntegrity()
     * @uses Payment_InboundPaymentFileItem::setTransactionId()
     * @uses Payment_InboundPaymentFileItem::setTransferCode()
     * @uses Payment_InboundPaymentFileItem::setType()
     * @uses Payment_InboundPaymentFileItem::setTypeFamily()
     * @param \patest\StructType\Money $amount
     * @param string $direction
     * @param string $errorCode
     * @param string $errorText
     * @param string $fileId
     * @param string $formatedStructuredCode
     * @param int $indexInFile
     * @param string $itemData
     * @param string $message
     * @param string $payerAccount
     * @param string $payerInfo
     * @param string $paymentDate
     * @param string $status
     * @param string $structuredCode
     * @param string $structuredCodeIntegrity
     * @param int $transactionId
     * @param string $transferCode
     * @param string $type
     * @param string $typeFamily
     */
    public function __construct(\patest\StructType\Money $amount = null, $direction = null, $errorCode = null, $errorText = null, $fileId = null, $formatedStructuredCode = null, $indexInFile = null, $itemData = null, $message = null, $payerAccount = null, $payerInfo = null, $paymentDate = null, $status = null, $structuredCode = null, $structuredCodeIntegrity = null, $transactionId = null, $transferCode = null, $type = null, $typeFamily = null)
    {
        $this
            ->setAmount($amount)
            ->setDirection($direction)
            ->setErrorCode($errorCode)
            ->setErrorText($errorText)
            ->setFileId($fileId)
            ->setFormatedStructuredCode($formatedStructuredCode)
            ->setIndexInFile($indexInFile)
            ->setItemData($itemData)
            ->setMessage($message)
            ->setPayerAccount($payerAccount)
            ->setPayerInfo($payerInfo)
            ->setPaymentDate($paymentDate)
            ->setStatus($status)
            ->setStructuredCode($structuredCode)
            ->setStructuredCodeIntegrity($structuredCodeIntegrity)
            ->setTransactionId($transactionId)
            ->setTransferCode($transferCode)
            ->setType($type)
            ->setTypeFamily($typeFamily);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Direction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirection()
    {
        return isset($this->Direction) ? $this->Direction : null;
    }
    /**
     * Set Direction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InboundPaymentTransactionDirection::valueIsValid()
     * @uses \patest\EnumType\InboundPaymentTransactionDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InboundPaymentTransactionDirection::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InboundPaymentTransactionDirection', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \patest\EnumType\InboundPaymentTransactionDirection::getValidValues())), __LINE__);
        }
        if (is_null($direction) || (is_array($direction) && empty($direction))) {
            unset($this->Direction);
        } else {
            $this->Direction = $direction;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCode()
    {
        return isset($this->ErrorCode) ? $this->ErrorCode : null;
    }
    /**
     * Set ErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCode
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        if (is_null($errorCode) || (is_array($errorCode) && empty($errorCode))) {
            unset($this->ErrorCode);
        } else {
            $this->ErrorCode = $errorCode;
        }
        return $this;
    }
    /**
     * Get ErrorText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorText()
    {
        return isset($this->ErrorText) ? $this->ErrorText : null;
    }
    /**
     * Set ErrorText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorText
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setErrorText($errorText = null)
    {
        // validation for constraint: string
        if (!is_null($errorText) && !is_string($errorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorText, true), gettype($errorText)), __LINE__);
        }
        if (is_null($errorText) || (is_array($errorText) && empty($errorText))) {
            unset($this->ErrorText);
        } else {
            $this->ErrorText = $errorText;
        }
        return $this;
    }
    /**
     * Get FileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileId()
    {
        return isset($this->FileId) ? $this->FileId : null;
    }
    /**
     * Set FileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileId
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setFileId($fileId = null)
    {
        // validation for constraint: string
        if (!is_null($fileId) && !is_string($fileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileId, true), gettype($fileId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fileId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fileId, true)), __LINE__);
        }
        if (is_null($fileId) || (is_array($fileId) && empty($fileId))) {
            unset($this->FileId);
        } else {
            $this->FileId = $fileId;
        }
        return $this;
    }
    /**
     * Get FormatedStructuredCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormatedStructuredCode()
    {
        return isset($this->FormatedStructuredCode) ? $this->FormatedStructuredCode : null;
    }
    /**
     * Set FormatedStructuredCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formatedStructuredCode
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setFormatedStructuredCode($formatedStructuredCode = null)
    {
        // validation for constraint: string
        if (!is_null($formatedStructuredCode) && !is_string($formatedStructuredCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formatedStructuredCode, true), gettype($formatedStructuredCode)), __LINE__);
        }
        if (is_null($formatedStructuredCode) || (is_array($formatedStructuredCode) && empty($formatedStructuredCode))) {
            unset($this->FormatedStructuredCode);
        } else {
            $this->FormatedStructuredCode = $formatedStructuredCode;
        }
        return $this;
    }
    /**
     * Get IndexInFile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIndexInFile()
    {
        return isset($this->IndexInFile) ? $this->IndexInFile : null;
    }
    /**
     * Set IndexInFile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $indexInFile
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setIndexInFile($indexInFile = null)
    {
        // validation for constraint: int
        if (!is_null($indexInFile) && !(is_int($indexInFile) || ctype_digit($indexInFile))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indexInFile, true), gettype($indexInFile)), __LINE__);
        }
        if (is_null($indexInFile) || (is_array($indexInFile) && empty($indexInFile))) {
            unset($this->IndexInFile);
        } else {
            $this->IndexInFile = $indexInFile;
        }
        return $this;
    }
    /**
     * Get ItemData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemData()
    {
        return isset($this->ItemData) ? $this->ItemData : null;
    }
    /**
     * Set ItemData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemData
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setItemData($itemData = null)
    {
        // validation for constraint: string
        if (!is_null($itemData) && !is_string($itemData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemData, true), gettype($itemData)), __LINE__);
        }
        if (is_null($itemData) || (is_array($itemData) && empty($itemData))) {
            unset($this->ItemData);
        } else {
            $this->ItemData = $itemData;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get PayerAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerAccount()
    {
        return isset($this->PayerAccount) ? $this->PayerAccount : null;
    }
    /**
     * Set PayerAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerAccount
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setPayerAccount($payerAccount = null)
    {
        // validation for constraint: string
        if (!is_null($payerAccount) && !is_string($payerAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerAccount, true), gettype($payerAccount)), __LINE__);
        }
        if (is_null($payerAccount) || (is_array($payerAccount) && empty($payerAccount))) {
            unset($this->PayerAccount);
        } else {
            $this->PayerAccount = $payerAccount;
        }
        return $this;
    }
    /**
     * Get PayerInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayerInfo()
    {
        return isset($this->PayerInfo) ? $this->PayerInfo : null;
    }
    /**
     * Set PayerInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payerInfo
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setPayerInfo($payerInfo = null)
    {
        // validation for constraint: string
        if (!is_null($payerInfo) && !is_string($payerInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerInfo, true), gettype($payerInfo)), __LINE__);
        }
        if (is_null($payerInfo) || (is_array($payerInfo) && empty($payerInfo))) {
            unset($this->PayerInfo);
        } else {
            $this->PayerInfo = $payerInfo;
        }
        return $this;
    }
    /**
     * Get PaymentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDate()
    {
        return isset($this->PaymentDate) ? $this->PaymentDate : null;
    }
    /**
     * Set PaymentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDate
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        if (is_null($paymentDate) || (is_array($paymentDate) && empty($paymentDate))) {
            unset($this->PaymentDate);
        } else {
            $this->PaymentDate = $paymentDate;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InboundPaymentFileItemStatus::valueIsValid()
     * @uses \patest\EnumType\InboundPaymentFileItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InboundPaymentFileItemStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InboundPaymentFileItemStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\InboundPaymentFileItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StructuredCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStructuredCode()
    {
        return isset($this->StructuredCode) ? $this->StructuredCode : null;
    }
    /**
     * Set StructuredCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $structuredCode
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setStructuredCode($structuredCode = null)
    {
        // validation for constraint: string
        if (!is_null($structuredCode) && !is_string($structuredCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($structuredCode, true), gettype($structuredCode)), __LINE__);
        }
        if (is_null($structuredCode) || (is_array($structuredCode) && empty($structuredCode))) {
            unset($this->StructuredCode);
        } else {
            $this->StructuredCode = $structuredCode;
        }
        return $this;
    }
    /**
     * Get StructuredCodeIntegrity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStructuredCodeIntegrity()
    {
        return isset($this->StructuredCodeIntegrity) ? $this->StructuredCodeIntegrity : null;
    }
    /**
     * Set StructuredCodeIntegrity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\StructuredCodeIntegrityTypes::valueIsValid()
     * @uses \patest\EnumType\StructuredCodeIntegrityTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $structuredCodeIntegrity
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setStructuredCodeIntegrity($structuredCodeIntegrity = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StructuredCodeIntegrityTypes::valueIsValid($structuredCodeIntegrity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StructuredCodeIntegrityTypes', is_array($structuredCodeIntegrity) ? implode(', ', $structuredCodeIntegrity) : var_export($structuredCodeIntegrity, true), implode(', ', \patest\EnumType\StructuredCodeIntegrityTypes::getValidValues())), __LINE__);
        }
        if (is_null($structuredCodeIntegrity) || (is_array($structuredCodeIntegrity) && empty($structuredCodeIntegrity))) {
            unset($this->StructuredCodeIntegrity);
        } else {
            $this->StructuredCodeIntegrity = $structuredCodeIntegrity;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionId
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !(is_int($transactionId) || ctype_digit($transactionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get TransferCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransferCode()
    {
        return isset($this->TransferCode) ? $this->TransferCode : null;
    }
    /**
     * Set TransferCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transferCode
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setTransferCode($transferCode = null)
    {
        // validation for constraint: string
        if (!is_null($transferCode) && !is_string($transferCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferCode, true), gettype($transferCode)), __LINE__);
        }
        if (is_null($transferCode) || (is_array($transferCode) && empty($transferCode))) {
            unset($this->TransferCode);
        } else {
            $this->TransferCode = $transferCode;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get TypeFamily value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeFamily()
    {
        return isset($this->TypeFamily) ? $this->TypeFamily : null;
    }
    /**
     * Set TypeFamily value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeFamily
     * @return \patest\StructType\Payment_InboundPaymentFileItem
     */
    public function setTypeFamily($typeFamily = null)
    {
        // validation for constraint: string
        if (!is_null($typeFamily) && !is_string($typeFamily)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeFamily, true), gettype($typeFamily)), __LINE__);
        }
        if (is_null($typeFamily) || (is_array($typeFamily) && empty($typeFamily))) {
            unset($this->TypeFamily);
        } else {
            $this->TypeFamily = $typeFamily;
        }
        return $this;
    }
}
