<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.GiftVoucherPaymentItemInformation StructType
 * @subpackage Structs
 */
class Payment_GiftVoucherPaymentItemInformation extends Payment_BasePaymentItemInformation
{
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Balance;
    /**
     * The GiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherDefinitionId;
    /**
     * The GiftVoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVoucherNumber;
    /**
     * The GiftVoucherType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVoucherType;
    /**
     * The ValidUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidUntil;
    /**
     * Constructor method for Payment.GiftVoucherPaymentItemInformation
     * @uses Payment_GiftVoucherPaymentItemInformation::setBalance()
     * @uses Payment_GiftVoucherPaymentItemInformation::setGiftVoucherDefinitionId()
     * @uses Payment_GiftVoucherPaymentItemInformation::setGiftVoucherNumber()
     * @uses Payment_GiftVoucherPaymentItemInformation::setGiftVoucherType()
     * @uses Payment_GiftVoucherPaymentItemInformation::setValidUntil()
     * @param float $balance
     * @param string $giftVoucherDefinitionId
     * @param string $giftVoucherNumber
     * @param string $giftVoucherType
     * @param string $validUntil
     */
    public function __construct($balance = null, $giftVoucherDefinitionId = null, $giftVoucherNumber = null, $giftVoucherType = null, $validUntil = null)
    {
        $this
            ->setBalance($balance)
            ->setGiftVoucherDefinitionId($giftVoucherDefinitionId)
            ->setGiftVoucherNumber($giftVoucherNumber)
            ->setGiftVoucherType($giftVoucherType)
            ->setValidUntil($validUntil);
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $balance
     * @return \patest\StructType\Payment_GiftVoucherPaymentItemInformation
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherDefinitionId()
    {
        return isset($this->GiftVoucherDefinitionId) ? $this->GiftVoucherDefinitionId : null;
    }
    /**
     * Set GiftVoucherDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherDefinitionId
     * @return \patest\StructType\Payment_GiftVoucherPaymentItemInformation
     */
    public function setGiftVoucherDefinitionId($giftVoucherDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherDefinitionId) && !is_string($giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherDefinitionId, true), gettype($giftVoucherDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherDefinitionId, true)), __LINE__);
        }
        if (is_null($giftVoucherDefinitionId) || (is_array($giftVoucherDefinitionId) && empty($giftVoucherDefinitionId))) {
            unset($this->GiftVoucherDefinitionId);
        } else {
            $this->GiftVoucherDefinitionId = $giftVoucherDefinitionId;
        }
        return $this;
    }
    /**
     * Get GiftVoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherNumber()
    {
        return isset($this->GiftVoucherNumber) ? $this->GiftVoucherNumber : null;
    }
    /**
     * Set GiftVoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherNumber
     * @return \patest\StructType\Payment_GiftVoucherPaymentItemInformation
     */
    public function setGiftVoucherNumber($giftVoucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherNumber) && !is_string($giftVoucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherNumber, true), gettype($giftVoucherNumber)), __LINE__);
        }
        if (is_null($giftVoucherNumber) || (is_array($giftVoucherNumber) && empty($giftVoucherNumber))) {
            unset($this->GiftVoucherNumber);
        } else {
            $this->GiftVoucherNumber = $giftVoucherNumber;
        }
        return $this;
    }
    /**
     * Get GiftVoucherType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherType()
    {
        return isset($this->GiftVoucherType) ? $this->GiftVoucherType : null;
    }
    /**
     * Set GiftVoucherType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GiftVoucherType::valueIsValid()
     * @uses \patest\EnumType\GiftVoucherType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $giftVoucherType
     * @return \patest\StructType\Payment_GiftVoucherPaymentItemInformation
     */
    public function setGiftVoucherType($giftVoucherType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftVoucherType::valueIsValid($giftVoucherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftVoucherType', is_array($giftVoucherType) ? implode(', ', $giftVoucherType) : var_export($giftVoucherType, true), implode(', ', \patest\EnumType\GiftVoucherType::getValidValues())), __LINE__);
        }
        if (is_null($giftVoucherType) || (is_array($giftVoucherType) && empty($giftVoucherType))) {
            unset($this->GiftVoucherType);
        } else {
            $this->GiftVoucherType = $giftVoucherType;
        }
        return $this;
    }
    /**
     * Get ValidUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidUntil()
    {
        return isset($this->ValidUntil) ? $this->ValidUntil : null;
    }
    /**
     * Set ValidUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validUntil
     * @return \patest\StructType\Payment_GiftVoucherPaymentItemInformation
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: string
        if (!is_null($validUntil) && !is_string($validUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validUntil, true), gettype($validUntil)), __LINE__);
        }
        if (is_null($validUntil) || (is_array($validUntil) && empty($validUntil))) {
            unset($this->ValidUntil);
        } else {
            $this->ValidUntil = $validUntil;
        }
        return $this;
    }
}
