<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.DirectDebitExportFilter StructType
 * @subpackage Structs
 */
class Payment_DirectDebitExportFilter extends FilterEntity
{
    /**
     * The CreatedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreatedByUserId;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The IsSent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSent;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * Constructor method for Payment.DirectDebitExportFilter
     * @uses Payment_DirectDebitExportFilter::setCreatedByUserId()
     * @uses Payment_DirectDebitExportFilter::setFromDate()
     * @uses Payment_DirectDebitExportFilter::setIsSent()
     * @uses Payment_DirectDebitExportFilter::setToDate()
     * @param string $createdByUserId
     * @param string $fromDate
     * @param bool $isSent
     * @param string $toDate
     */
    public function __construct($createdByUserId = null, $fromDate = null, $isSent = null, $toDate = null)
    {
        $this
            ->setCreatedByUserId($createdByUserId)
            ->setFromDate($fromDate)
            ->setIsSent($isSent)
            ->setToDate($toDate);
    }
    /**
     * Get CreatedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedByUserId()
    {
        return isset($this->CreatedByUserId) ? $this->CreatedByUserId : null;
    }
    /**
     * Set CreatedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdByUserId
     * @return \patest\StructType\Payment_DirectDebitExportFilter
     */
    public function setCreatedByUserId($createdByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserId) && !is_string($createdByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdByUserId, true), gettype($createdByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($createdByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $createdByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($createdByUserId, true)), __LINE__);
        }
        if (is_null($createdByUserId) || (is_array($createdByUserId) && empty($createdByUserId))) {
            unset($this->CreatedByUserId);
        } else {
            $this->CreatedByUserId = $createdByUserId;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Payment_DirectDebitExportFilter
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get IsSent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSent()
    {
        return isset($this->IsSent) ? $this->IsSent : null;
    }
    /**
     * Set IsSent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSent
     * @return \patest\StructType\Payment_DirectDebitExportFilter
     */
    public function setIsSent($isSent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSent) && !is_bool($isSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSent, true), gettype($isSent)), __LINE__);
        }
        if (is_null($isSent) || (is_array($isSent) && empty($isSent))) {
            unset($this->IsSent);
        } else {
            $this->IsSent = $isSent;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Payment_DirectDebitExportFilter
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
}
