<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.DirectDebitExportCriteria StructType
 * @subpackage Structs
 */
class Payment_DirectDebitExportCriteria extends AnyEntity
{
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The FromTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromTransaction;
    /**
     * The MandateTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MandateTypeIds
     */
    public $MandateTypeIds;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The ToTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToTransaction;
    /**
     * Constructor method for Payment.DirectDebitExportCriteria
     * @uses Payment_DirectDebitExportCriteria::setFromDate()
     * @uses Payment_DirectDebitExportCriteria::setFromTransaction()
     * @uses Payment_DirectDebitExportCriteria::setMandateTypeIds()
     * @uses Payment_DirectDebitExportCriteria::setToDate()
     * @uses Payment_DirectDebitExportCriteria::setToTransaction()
     * @param string $fromDate
     * @param int $fromTransaction
     * @param \patest\StructType\MandateTypeIds $mandateTypeIds
     * @param string $toDate
     * @param int $toTransaction
     */
    public function __construct($fromDate = null, $fromTransaction = null, \patest\StructType\MandateTypeIds $mandateTypeIds = null, $toDate = null, $toTransaction = null)
    {
        $this
            ->setFromDate($fromDate)
            ->setFromTransaction($fromTransaction)
            ->setMandateTypeIds($mandateTypeIds)
            ->setToDate($toDate)
            ->setToTransaction($toTransaction);
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Payment_DirectDebitExportCriteria
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get FromTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromTransaction()
    {
        return isset($this->FromTransaction) ? $this->FromTransaction : null;
    }
    /**
     * Set FromTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromTransaction
     * @return \patest\StructType\Payment_DirectDebitExportCriteria
     */
    public function setFromTransaction($fromTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($fromTransaction) && !(is_int($fromTransaction) || ctype_digit($fromTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromTransaction, true), gettype($fromTransaction)), __LINE__);
        }
        if (is_null($fromTransaction) || (is_array($fromTransaction) && empty($fromTransaction))) {
            unset($this->FromTransaction);
        } else {
            $this->FromTransaction = $fromTransaction;
        }
        return $this;
    }
    /**
     * Get MandateTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MandateTypeIds|null
     */
    public function getMandateTypeIds()
    {
        return isset($this->MandateTypeIds) ? $this->MandateTypeIds : null;
    }
    /**
     * Set MandateTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\MandateTypeIds $mandateTypeIds
     * @return \patest\StructType\Payment_DirectDebitExportCriteria
     */
    public function setMandateTypeIds(\patest\StructType\MandateTypeIds $mandateTypeIds = null)
    {
        if (is_null($mandateTypeIds) || (is_array($mandateTypeIds) && empty($mandateTypeIds))) {
            unset($this->MandateTypeIds);
        } else {
            $this->MandateTypeIds = $mandateTypeIds;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Payment_DirectDebitExportCriteria
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get ToTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToTransaction()
    {
        return isset($this->ToTransaction) ? $this->ToTransaction : null;
    }
    /**
     * Set ToTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toTransaction
     * @return \patest\StructType\Payment_DirectDebitExportCriteria
     */
    public function setToTransaction($toTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($toTransaction) && !(is_int($toTransaction) || ctype_digit($toTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toTransaction, true), gettype($toTransaction)), __LINE__);
        }
        if (is_null($toTransaction) || (is_array($toTransaction) && empty($toTransaction))) {
            unset($this->ToTransaction);
        } else {
            $this->ToTransaction = $toTransaction;
        }
        return $this;
    }
}
