<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.DirectDebitExportBatch StructType
 * @subpackage Structs
 */
class Payment_DirectDebitExportBatch extends PersistableEntity
{
    /**
     * The CreatedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreatedByUserId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The Criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_DirectDebitExportCriteria
     */
    public $Criteria;
    /**
     * The FailedQty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedQty;
    /**
     * The FailedRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_DirectDebitExportFailedRecord
     */
    public $FailedRecords;
    /**
     * The Files
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_DirectDebitExportFile
     */
    public $Files;
    /**
     * The FilesQty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FilesQty;
    /**
     * The IsSent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSent;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PaymentsQty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PaymentsQty;
    /**
     * The RecordsBatchId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordsBatchId;
    /**
     * Constructor method for Payment.DirectDebitExportBatch
     * @uses Payment_DirectDebitExportBatch::setCreatedByUserId()
     * @uses Payment_DirectDebitExportBatch::setCreationDate()
     * @uses Payment_DirectDebitExportBatch::setCriteria()
     * @uses Payment_DirectDebitExportBatch::setFailedQty()
     * @uses Payment_DirectDebitExportBatch::setFailedRecords()
     * @uses Payment_DirectDebitExportBatch::setFiles()
     * @uses Payment_DirectDebitExportBatch::setFilesQty()
     * @uses Payment_DirectDebitExportBatch::setIsSent()
     * @uses Payment_DirectDebitExportBatch::setOrganizationUnitId()
     * @uses Payment_DirectDebitExportBatch::setPaymentsQty()
     * @uses Payment_DirectDebitExportBatch::setRecordsBatchId()
     * @param string $createdByUserId
     * @param string $creationDate
     * @param \patest\StructType\Payment_DirectDebitExportCriteria $criteria
     * @param int $failedQty
     * @param \patest\StructType\RecordSetOfPayment_DirectDebitExportFailedRecord $failedRecords
     * @param \patest\StructType\RecordSetOfPayment_DirectDebitExportFile $files
     * @param int $filesQty
     * @param bool $isSent
     * @param string $organizationUnitId
     * @param int $paymentsQty
     * @param string $recordsBatchId
     */
    public function __construct($createdByUserId = null, $creationDate = null, \patest\StructType\Payment_DirectDebitExportCriteria $criteria = null, $failedQty = null, \patest\StructType\RecordSetOfPayment_DirectDebitExportFailedRecord $failedRecords = null, \patest\StructType\RecordSetOfPayment_DirectDebitExportFile $files = null, $filesQty = null, $isSent = null, $organizationUnitId = null, $paymentsQty = null, $recordsBatchId = null)
    {
        $this
            ->setCreatedByUserId($createdByUserId)
            ->setCreationDate($creationDate)
            ->setCriteria($criteria)
            ->setFailedQty($failedQty)
            ->setFailedRecords($failedRecords)
            ->setFiles($files)
            ->setFilesQty($filesQty)
            ->setIsSent($isSent)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPaymentsQty($paymentsQty)
            ->setRecordsBatchId($recordsBatchId);
    }
    /**
     * Get CreatedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedByUserId()
    {
        return isset($this->CreatedByUserId) ? $this->CreatedByUserId : null;
    }
    /**
     * Set CreatedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdByUserId
     * @return \patest\StructType\Payment_DirectDebitExportBatch
     */
    public function setCreatedByUserId($createdByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserId) && !is_string($createdByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdByUserId, true), gettype($createdByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($createdByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $createdByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($createdByUserId, true)), __LINE__);
        }
        if (is_null($createdByUserId) || (is_array($createdByUserId) && empty($createdByUserId))) {
            unset($this->CreatedByUserId);
        } else {
            $this->CreatedByUserId = $createdByUserId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Payment_DirectDebitExportBatch
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get Criteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_DirectDebitExportCriteria|null
     */
    public function getCriteria()
    {
        return isset($this->Criteria) ? $this->Criteria : null;
    }
    /**
     * Set Criteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_DirectDebitExportCriteria $criteria
     * @return \patest\StructType\Payment_DirectDebitExportBatch
     */
    public function setCriteria(\patest\StructType\Payment_DirectDebitExportCriteria $criteria = null)
    {
        if (is_null($criteria) || (is_array($criteria) && empty($criteria))) {
            unset($this->Criteria);
        } else {
            $this->Criteria = $criteria;
        }
        return $this;
    }
    /**
     * Get FailedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedQty()
    {
        return isset($this->FailedQty) ? $this->FailedQty : null;
    }
    /**
     * Set FailedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedQty
     * @return \patest\StructType\Payment_DirectDebitExportBatch
     */
    public function setFailedQty($failedQty = null)
    {
        // validation for constraint: int
        if (!is_null($failedQty) && !(is_int($failedQty) || ctype_digit($failedQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedQty, true), gettype($failedQty)), __LINE__);
        }
        if (is_null($failedQty) || (is_array($failedQty) && empty($failedQty))) {
            unset($this->FailedQty);
        } else {
            $this->FailedQty = $failedQty;
        }
        return $this;
    }
    /**
     * Get FailedRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_DirectDebitExportFailedRecord|null
     */
    public function getFailedRecords()
    {
        return isset($this->FailedRecords) ? $this->FailedRecords : null;
    }
    /**
     * Set FailedRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_DirectDebitExportFailedRecord $failedRecords
     * @return \patest\StructType\Payment_DirectDebitExportBatch
     */
    public function setFailedRecords(\patest\StructType\RecordSetOfPayment_DirectDebitExportFailedRecord $failedRecords = null)
    {
        if (is_null($failedRecords) || (is_array($failedRecords) && empty($failedRecords))) {
            unset($this->FailedRecords);
        } else {
            $this->FailedRecords = $failedRecords;
        }
        return $this;
    }
    /**
     * Get Files value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_DirectDebitExportFile|null
     */
    public function getFiles()
    {
        return isset($this->Files) ? $this->Files : null;
    }
    /**
     * Set Files value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_DirectDebitExportFile $files
     * @return \patest\StructType\Payment_DirectDebitExportBatch
     */
    public function setFiles(\patest\StructType\RecordSetOfPayment_DirectDebitExportFile $files = null)
    {
        if (is_null($files) || (is_array($files) && empty($files))) {
            unset($this->Files);
        } else {
            $this->Files = $files;
        }
        return $this;
    }
    /**
     * Get FilesQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFilesQty()
    {
        return isset($this->FilesQty) ? $this->FilesQty : null;
    }
    /**
     * Set FilesQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $filesQty
     * @return \patest\StructType\Payment_DirectDebitExportBatch
     */
    public function setFilesQty($filesQty = null)
    {
        // validation for constraint: int
        if (!is_null($filesQty) && !(is_int($filesQty) || ctype_digit($filesQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($filesQty, true), gettype($filesQty)), __LINE__);
        }
        if (is_null($filesQty) || (is_array($filesQty) && empty($filesQty))) {
            unset($this->FilesQty);
        } else {
            $this->FilesQty = $filesQty;
        }
        return $this;
    }
    /**
     * Get IsSent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSent()
    {
        return isset($this->IsSent) ? $this->IsSent : null;
    }
    /**
     * Set IsSent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSent
     * @return \patest\StructType\Payment_DirectDebitExportBatch
     */
    public function setIsSent($isSent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSent) && !is_bool($isSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSent, true), gettype($isSent)), __LINE__);
        }
        if (is_null($isSent) || (is_array($isSent) && empty($isSent))) {
            unset($this->IsSent);
        } else {
            $this->IsSent = $isSent;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Payment_DirectDebitExportBatch
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PaymentsQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPaymentsQty()
    {
        return isset($this->PaymentsQty) ? $this->PaymentsQty : null;
    }
    /**
     * Set PaymentsQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $paymentsQty
     * @return \patest\StructType\Payment_DirectDebitExportBatch
     */
    public function setPaymentsQty($paymentsQty = null)
    {
        // validation for constraint: int
        if (!is_null($paymentsQty) && !(is_int($paymentsQty) || ctype_digit($paymentsQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentsQty, true), gettype($paymentsQty)), __LINE__);
        }
        if (is_null($paymentsQty) || (is_array($paymentsQty) && empty($paymentsQty))) {
            unset($this->PaymentsQty);
        } else {
            $this->PaymentsQty = $paymentsQty;
        }
        return $this;
    }
    /**
     * Get RecordsBatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordsBatchId()
    {
        return isset($this->RecordsBatchId) ? $this->RecordsBatchId : null;
    }
    /**
     * Set RecordsBatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordsBatchId
     * @return \patest\StructType\Payment_DirectDebitExportBatch
     */
    public function setRecordsBatchId($recordsBatchId = null)
    {
        // validation for constraint: string
        if (!is_null($recordsBatchId) && !is_string($recordsBatchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordsBatchId, true), gettype($recordsBatchId)), __LINE__);
        }
        if (is_null($recordsBatchId) || (is_array($recordsBatchId) && empty($recordsBatchId))) {
            unset($this->RecordsBatchId);
        } else {
            $this->RecordsBatchId = $recordsBatchId;
        }
        return $this;
    }
}
