<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.DepositExtendedFilter StructType
 * @subpackage Structs
 */
class Payment_DepositExtendedFilter extends FilterEntity
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CommitDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDateFrom;
    /**
     * The CommitDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDateTo;
    /**
     * The CompanyAmountGreaterThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyAmountGreaterThan;
    /**
     * The CompanyAmountLessThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyAmountLessThan;
    /**
     * The RemainingAmountGreaterThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RemainingAmountGreaterThan;
    /**
     * The RemainingAmountLessThan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RemainingAmountLessThan;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Payment.DepositExtendedFilter
     * @uses Payment_DepositExtendedFilter::setCategoryId()
     * @uses Payment_DepositExtendedFilter::setCommitDateFrom()
     * @uses Payment_DepositExtendedFilter::setCommitDateTo()
     * @uses Payment_DepositExtendedFilter::setCompanyAmountGreaterThan()
     * @uses Payment_DepositExtendedFilter::setCompanyAmountLessThan()
     * @uses Payment_DepositExtendedFilter::setRemainingAmountGreaterThan()
     * @uses Payment_DepositExtendedFilter::setRemainingAmountLessThan()
     * @uses Payment_DepositExtendedFilter::setTransactionNumber()
     * @param string $categoryId
     * @param string $commitDateFrom
     * @param string $commitDateTo
     * @param \patest\StructType\Money $companyAmountGreaterThan
     * @param \patest\StructType\Money $companyAmountLessThan
     * @param \patest\StructType\Money $remainingAmountGreaterThan
     * @param \patest\StructType\Money $remainingAmountLessThan
     * @param int $transactionNumber
     */
    public function __construct($categoryId = null, $commitDateFrom = null, $commitDateTo = null, \patest\StructType\Money $companyAmountGreaterThan = null, \patest\StructType\Money $companyAmountLessThan = null, \patest\StructType\Money $remainingAmountGreaterThan = null, \patest\StructType\Money $remainingAmountLessThan = null, $transactionNumber = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setCommitDateFrom($commitDateFrom)
            ->setCommitDateTo($commitDateTo)
            ->setCompanyAmountGreaterThan($companyAmountGreaterThan)
            ->setCompanyAmountLessThan($companyAmountLessThan)
            ->setRemainingAmountGreaterThan($remainingAmountGreaterThan)
            ->setRemainingAmountLessThan($remainingAmountLessThan)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Payment_DepositExtendedFilter
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CommitDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDateFrom()
    {
        return isset($this->CommitDateFrom) ? $this->CommitDateFrom : null;
    }
    /**
     * Set CommitDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDateFrom
     * @return \patest\StructType\Payment_DepositExtendedFilter
     */
    public function setCommitDateFrom($commitDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($commitDateFrom) && !is_string($commitDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDateFrom, true), gettype($commitDateFrom)), __LINE__);
        }
        if (is_null($commitDateFrom) || (is_array($commitDateFrom) && empty($commitDateFrom))) {
            unset($this->CommitDateFrom);
        } else {
            $this->CommitDateFrom = $commitDateFrom;
        }
        return $this;
    }
    /**
     * Get CommitDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDateTo()
    {
        return isset($this->CommitDateTo) ? $this->CommitDateTo : null;
    }
    /**
     * Set CommitDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDateTo
     * @return \patest\StructType\Payment_DepositExtendedFilter
     */
    public function setCommitDateTo($commitDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($commitDateTo) && !is_string($commitDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDateTo, true), gettype($commitDateTo)), __LINE__);
        }
        if (is_null($commitDateTo) || (is_array($commitDateTo) && empty($commitDateTo))) {
            unset($this->CommitDateTo);
        } else {
            $this->CommitDateTo = $commitDateTo;
        }
        return $this;
    }
    /**
     * Get CompanyAmountGreaterThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyAmountGreaterThan()
    {
        return isset($this->CompanyAmountGreaterThan) ? $this->CompanyAmountGreaterThan : null;
    }
    /**
     * Set CompanyAmountGreaterThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyAmountGreaterThan
     * @return \patest\StructType\Payment_DepositExtendedFilter
     */
    public function setCompanyAmountGreaterThan(\patest\StructType\Money $companyAmountGreaterThan = null)
    {
        if (is_null($companyAmountGreaterThan) || (is_array($companyAmountGreaterThan) && empty($companyAmountGreaterThan))) {
            unset($this->CompanyAmountGreaterThan);
        } else {
            $this->CompanyAmountGreaterThan = $companyAmountGreaterThan;
        }
        return $this;
    }
    /**
     * Get CompanyAmountLessThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyAmountLessThan()
    {
        return isset($this->CompanyAmountLessThan) ? $this->CompanyAmountLessThan : null;
    }
    /**
     * Set CompanyAmountLessThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyAmountLessThan
     * @return \patest\StructType\Payment_DepositExtendedFilter
     */
    public function setCompanyAmountLessThan(\patest\StructType\Money $companyAmountLessThan = null)
    {
        if (is_null($companyAmountLessThan) || (is_array($companyAmountLessThan) && empty($companyAmountLessThan))) {
            unset($this->CompanyAmountLessThan);
        } else {
            $this->CompanyAmountLessThan = $companyAmountLessThan;
        }
        return $this;
    }
    /**
     * Get RemainingAmountGreaterThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRemainingAmountGreaterThan()
    {
        return isset($this->RemainingAmountGreaterThan) ? $this->RemainingAmountGreaterThan : null;
    }
    /**
     * Set RemainingAmountGreaterThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $remainingAmountGreaterThan
     * @return \patest\StructType\Payment_DepositExtendedFilter
     */
    public function setRemainingAmountGreaterThan(\patest\StructType\Money $remainingAmountGreaterThan = null)
    {
        if (is_null($remainingAmountGreaterThan) || (is_array($remainingAmountGreaterThan) && empty($remainingAmountGreaterThan))) {
            unset($this->RemainingAmountGreaterThan);
        } else {
            $this->RemainingAmountGreaterThan = $remainingAmountGreaterThan;
        }
        return $this;
    }
    /**
     * Get RemainingAmountLessThan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRemainingAmountLessThan()
    {
        return isset($this->RemainingAmountLessThan) ? $this->RemainingAmountLessThan : null;
    }
    /**
     * Set RemainingAmountLessThan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $remainingAmountLessThan
     * @return \patest\StructType\Payment_DepositExtendedFilter
     */
    public function setRemainingAmountLessThan(\patest\StructType\Money $remainingAmountLessThan = null)
    {
        if (is_null($remainingAmountLessThan) || (is_array($remainingAmountLessThan) && empty($remainingAmountLessThan))) {
            unset($this->RemainingAmountLessThan);
        } else {
            $this->RemainingAmountLessThan = $remainingAmountLessThan;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Payment_DepositExtendedFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
