<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.Deposit StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Payment.Deposit
 * @subpackage Structs
 */
class Payment_Deposit extends Payment_BaseClientCredit
{
    /**
     * The Canceled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Canceled;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CategoryName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CategoryName;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The FJSubTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FJSubTargetId;
    /**
     * The FJTargetKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FJTargetKind;
    /**
     * The TargetId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetId;
    /**
     * The TargetType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetType;
    /**
     * Constructor method for Payment.Deposit
     * @uses Payment_Deposit::setCanceled()
     * @uses Payment_Deposit::setCategoryId()
     * @uses Payment_Deposit::setCategoryName()
     * @uses Payment_Deposit::setClientName()
     * @uses Payment_Deposit::setFJSubTargetId()
     * @uses Payment_Deposit::setFJTargetKind()
     * @uses Payment_Deposit::setTargetId()
     * @uses Payment_Deposit::setTargetType()
     * @param bool $canceled
     * @param string $categoryId
     * @param \patest\StructType\GlobalString $categoryName
     * @param string $clientName
     * @param string $fJSubTargetId
     * @param string $fJTargetKind
     * @param string $targetId
     * @param string $targetType
     */
    public function __construct($canceled = null, $categoryId = null, \patest\StructType\GlobalString $categoryName = null, $clientName = null, $fJSubTargetId = null, $fJTargetKind = null, $targetId = null, $targetType = null)
    {
        $this
            ->setCanceled($canceled)
            ->setCategoryId($categoryId)
            ->setCategoryName($categoryName)
            ->setClientName($clientName)
            ->setFJSubTargetId($fJSubTargetId)
            ->setFJTargetKind($fJTargetKind)
            ->setTargetId($targetId)
            ->setTargetType($targetType);
    }
    /**
     * Get Canceled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanceled()
    {
        return isset($this->Canceled) ? $this->Canceled : null;
    }
    /**
     * Set Canceled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canceled
     * @return \patest\StructType\Payment_Deposit
     */
    public function setCanceled($canceled = null)
    {
        // validation for constraint: boolean
        if (!is_null($canceled) && !is_bool($canceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canceled, true), gettype($canceled)), __LINE__);
        }
        if (is_null($canceled) || (is_array($canceled) && empty($canceled))) {
            unset($this->Canceled);
        } else {
            $this->Canceled = $canceled;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Payment_Deposit
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CategoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCategoryName()
    {
        return isset($this->CategoryName) ? $this->CategoryName : null;
    }
    /**
     * Set CategoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $categoryName
     * @return \patest\StructType\Payment_Deposit
     */
    public function setCategoryName(\patest\StructType\GlobalString $categoryName = null)
    {
        if (is_null($categoryName) || (is_array($categoryName) && empty($categoryName))) {
            unset($this->CategoryName);
        } else {
            $this->CategoryName = $categoryName;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Payment_Deposit
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get FJSubTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFJSubTargetId()
    {
        return isset($this->FJSubTargetId) ? $this->FJSubTargetId : null;
    }
    /**
     * Set FJSubTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fJSubTargetId
     * @return \patest\StructType\Payment_Deposit
     */
    public function setFJSubTargetId($fJSubTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($fJSubTargetId) && !is_string($fJSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fJSubTargetId, true), gettype($fJSubTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fJSubTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fJSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fJSubTargetId, true)), __LINE__);
        }
        if (is_null($fJSubTargetId) || (is_array($fJSubTargetId) && empty($fJSubTargetId))) {
            unset($this->FJSubTargetId);
        } else {
            $this->FJSubTargetId = $fJSubTargetId;
        }
        return $this;
    }
    /**
     * Get FJTargetKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFJTargetKind()
    {
        return isset($this->FJTargetKind) ? $this->FJTargetKind : null;
    }
    /**
     * Set FJTargetKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fJTargetKind
     * @return \patest\StructType\Payment_Deposit
     */
    public function setFJTargetKind($fJTargetKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($fJTargetKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($fJTargetKind) ? implode(', ', $fJTargetKind) : var_export($fJTargetKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        if (is_null($fJTargetKind) || (is_array($fJTargetKind) && empty($fJTargetKind))) {
            unset($this->FJTargetKind);
        } else {
            $this->FJTargetKind = $fJTargetKind;
        }
        return $this;
    }
    /**
     * Get TargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetId()
    {
        return isset($this->TargetId) ? $this->TargetId : null;
    }
    /**
     * Set TargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetId
     * @return \patest\StructType\Payment_Deposit
     */
    public function setTargetId($targetId = null)
    {
        // validation for constraint: string
        if (!is_null($targetId) && !is_string($targetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetId, true), gettype($targetId)), __LINE__);
        }
        if (is_null($targetId) || (is_array($targetId) && empty($targetId))) {
            unset($this->TargetId);
        } else {
            $this->TargetId = $targetId;
        }
        return $this;
    }
    /**
     * Get TargetType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetType()
    {
        return isset($this->TargetType) ? $this->TargetType : null;
    }
    /**
     * Set TargetType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DepositTargetType::valueIsValid()
     * @uses \patest\EnumType\DepositTargetType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $targetType
     * @return \patest\StructType\Payment_Deposit
     */
    public function setTargetType($targetType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DepositTargetType::valueIsValid($targetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DepositTargetType', is_array($targetType) ? implode(', ', $targetType) : var_export($targetType, true), implode(', ', \patest\EnumType\DepositTargetType::getValidValues())), __LINE__);
        }
        if (is_null($targetType) || (is_array($targetType) && empty($targetType))) {
            unset($this->TargetType);
        } else {
            $this->TargetType = $targetType;
        }
        return $this;
    }
}
