<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.BaseClientCredit StructType
 * @subpackage Structs
 */
class Payment_BaseClientCredit extends PersistableEntity
{
    /**
     * The ByTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ByTransaction;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CompanyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyAmount;
    /**
     * The CompanyCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyCurrencyCode;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemId;
    /**
     * The SiteAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SiteAmount;
    /**
     * The SiteCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteCurrencyCode;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The UtilizedCompanyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $UtilizedCompanyAmount;
    /**
     * The UtilizedSiteAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $UtilizedSiteAmount;
    /**
     * Constructor method for Payment.BaseClientCredit
     * @uses Payment_BaseClientCredit::setByTransaction()
     * @uses Payment_BaseClientCredit::setClientId()
     * @uses Payment_BaseClientCredit::setCompanyAmount()
     * @uses Payment_BaseClientCredit::setCompanyCurrencyCode()
     * @uses Payment_BaseClientCredit::setCreationDateTime()
     * @uses Payment_BaseClientCredit::setPaymentItemId()
     * @uses Payment_BaseClientCredit::setSiteAmount()
     * @uses Payment_BaseClientCredit::setSiteCurrencyCode()
     * @uses Payment_BaseClientCredit::setTransactionGuid()
     * @uses Payment_BaseClientCredit::setType()
     * @uses Payment_BaseClientCredit::setUtilizedCompanyAmount()
     * @uses Payment_BaseClientCredit::setUtilizedSiteAmount()
     * @param bool $byTransaction
     * @param string $clientId
     * @param \patest\StructType\Money $companyAmount
     * @param string $companyCurrencyCode
     * @param string $creationDateTime
     * @param string $paymentItemId
     * @param \patest\StructType\Money $siteAmount
     * @param string $siteCurrencyCode
     * @param string $transactionGuid
     * @param string $type
     * @param \patest\StructType\Money $utilizedCompanyAmount
     * @param \patest\StructType\Money $utilizedSiteAmount
     */
    public function __construct($byTransaction = null, $clientId = null, \patest\StructType\Money $companyAmount = null, $companyCurrencyCode = null, $creationDateTime = null, $paymentItemId = null, \patest\StructType\Money $siteAmount = null, $siteCurrencyCode = null, $transactionGuid = null, $type = null, \patest\StructType\Money $utilizedCompanyAmount = null, \patest\StructType\Money $utilizedSiteAmount = null)
    {
        $this
            ->setByTransaction($byTransaction)
            ->setClientId($clientId)
            ->setCompanyAmount($companyAmount)
            ->setCompanyCurrencyCode($companyCurrencyCode)
            ->setCreationDateTime($creationDateTime)
            ->setPaymentItemId($paymentItemId)
            ->setSiteAmount($siteAmount)
            ->setSiteCurrencyCode($siteCurrencyCode)
            ->setTransactionGuid($transactionGuid)
            ->setType($type)
            ->setUtilizedCompanyAmount($utilizedCompanyAmount)
            ->setUtilizedSiteAmount($utilizedSiteAmount);
    }
    /**
     * Get ByTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getByTransaction()
    {
        return isset($this->ByTransaction) ? $this->ByTransaction : null;
    }
    /**
     * Set ByTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $byTransaction
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setByTransaction($byTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($byTransaction) && !is_bool($byTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($byTransaction, true), gettype($byTransaction)), __LINE__);
        }
        if (is_null($byTransaction) || (is_array($byTransaction) && empty($byTransaction))) {
            unset($this->ByTransaction);
        } else {
            $this->ByTransaction = $byTransaction;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CompanyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyAmount()
    {
        return isset($this->CompanyAmount) ? $this->CompanyAmount : null;
    }
    /**
     * Set CompanyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyAmount
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setCompanyAmount(\patest\StructType\Money $companyAmount = null)
    {
        if (is_null($companyAmount) || (is_array($companyAmount) && empty($companyAmount))) {
            unset($this->CompanyAmount);
        } else {
            $this->CompanyAmount = $companyAmount;
        }
        return $this;
    }
    /**
     * Get CompanyCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyCurrencyCode()
    {
        return isset($this->CompanyCurrencyCode) ? $this->CompanyCurrencyCode : null;
    }
    /**
     * Set CompanyCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyCurrencyCode
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setCompanyCurrencyCode($companyCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCurrencyCode) && !is_string($companyCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCurrencyCode, true), gettype($companyCurrencyCode)), __LINE__);
        }
        if (is_null($companyCurrencyCode) || (is_array($companyCurrencyCode) && empty($companyCurrencyCode))) {
            unset($this->CompanyCurrencyCode);
        } else {
            $this->CompanyCurrencyCode = $companyCurrencyCode;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get PaymentItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemId()
    {
        return isset($this->PaymentItemId) ? $this->PaymentItemId : null;
    }
    /**
     * Set PaymentItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemId
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemId) && !is_string($paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemId, true)), __LINE__);
        }
        if (is_null($paymentItemId) || (is_array($paymentItemId) && empty($paymentItemId))) {
            unset($this->PaymentItemId);
        } else {
            $this->PaymentItemId = $paymentItemId;
        }
        return $this;
    }
    /**
     * Get SiteAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSiteAmount()
    {
        return isset($this->SiteAmount) ? $this->SiteAmount : null;
    }
    /**
     * Set SiteAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $siteAmount
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setSiteAmount(\patest\StructType\Money $siteAmount = null)
    {
        if (is_null($siteAmount) || (is_array($siteAmount) && empty($siteAmount))) {
            unset($this->SiteAmount);
        } else {
            $this->SiteAmount = $siteAmount;
        }
        return $this;
    }
    /**
     * Get SiteCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteCurrencyCode()
    {
        return isset($this->SiteCurrencyCode) ? $this->SiteCurrencyCode : null;
    }
    /**
     * Set SiteCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteCurrencyCode
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setSiteCurrencyCode($siteCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCurrencyCode) && !is_string($siteCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCurrencyCode, true), gettype($siteCurrencyCode)), __LINE__);
        }
        if (is_null($siteCurrencyCode) || (is_array($siteCurrencyCode) && empty($siteCurrencyCode))) {
            unset($this->SiteCurrencyCode);
        } else {
            $this->SiteCurrencyCode = $siteCurrencyCode;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientCreditTypeEnum::valueIsValid()
     * @uses \patest\EnumType\ClientCreditTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientCreditTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientCreditTypeEnum', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\ClientCreditTypeEnum::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UtilizedCompanyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getUtilizedCompanyAmount()
    {
        return isset($this->UtilizedCompanyAmount) ? $this->UtilizedCompanyAmount : null;
    }
    /**
     * Set UtilizedCompanyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $utilizedCompanyAmount
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setUtilizedCompanyAmount(\patest\StructType\Money $utilizedCompanyAmount = null)
    {
        if (is_null($utilizedCompanyAmount) || (is_array($utilizedCompanyAmount) && empty($utilizedCompanyAmount))) {
            unset($this->UtilizedCompanyAmount);
        } else {
            $this->UtilizedCompanyAmount = $utilizedCompanyAmount;
        }
        return $this;
    }
    /**
     * Get UtilizedSiteAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getUtilizedSiteAmount()
    {
        return isset($this->UtilizedSiteAmount) ? $this->UtilizedSiteAmount : null;
    }
    /**
     * Set UtilizedSiteAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $utilizedSiteAmount
     * @return \patest\StructType\Payment_BaseClientCredit
     */
    public function setUtilizedSiteAmount(\patest\StructType\Money $utilizedSiteAmount = null)
    {
        if (is_null($utilizedSiteAmount) || (is_array($utilizedSiteAmount) && empty($utilizedSiteAmount))) {
            unset($this->UtilizedSiteAmount);
        } else {
            $this->UtilizedSiteAmount = $utilizedSiteAmount;
        }
        return $this;
    }
}
