<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.AddWithdrawDepositPaymentToBasketRequest
 * StructType
 * @subpackage Structs
 */
class Payment_AddWithdrawDepositPaymentToBasketRequest extends Payment_AddPaymentToBasketRequestBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DepositCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositCategoryId;
    /**
     * The DepositId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositId;
    /**
     * The DepositIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DepositIds
     */
    public $DepositIds;
    /**
     * Constructor method for Payment.AddWithdrawDepositPaymentToBasketRequest
     * @uses Payment_AddWithdrawDepositPaymentToBasketRequest::setClientId()
     * @uses Payment_AddWithdrawDepositPaymentToBasketRequest::setDepositCategoryId()
     * @uses Payment_AddWithdrawDepositPaymentToBasketRequest::setDepositId()
     * @uses Payment_AddWithdrawDepositPaymentToBasketRequest::setDepositIds()
     * @param string $clientId
     * @param string $depositCategoryId
     * @param string $depositId
     * @param \patest\StructType\DepositIds $depositIds
     */
    public function __construct($clientId = null, $depositCategoryId = null, $depositId = null, \patest\StructType\DepositIds $depositIds = null)
    {
        $this
            ->setClientId($clientId)
            ->setDepositCategoryId($depositCategoryId)
            ->setDepositId($depositId)
            ->setDepositIds($depositIds);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Payment_AddWithdrawDepositPaymentToBasketRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DepositCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositCategoryId()
    {
        return isset($this->DepositCategoryId) ? $this->DepositCategoryId : null;
    }
    /**
     * Set DepositCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositCategoryId
     * @return \patest\StructType\Payment_AddWithdrawDepositPaymentToBasketRequest
     */
    public function setDepositCategoryId($depositCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($depositCategoryId) && !is_string($depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositCategoryId, true), gettype($depositCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositCategoryId, true)), __LINE__);
        }
        if (is_null($depositCategoryId) || (is_array($depositCategoryId) && empty($depositCategoryId))) {
            unset($this->DepositCategoryId);
        } else {
            $this->DepositCategoryId = $depositCategoryId;
        }
        return $this;
    }
    /**
     * Get DepositId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositId()
    {
        return isset($this->DepositId) ? $this->DepositId : null;
    }
    /**
     * Set DepositId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositId
     * @return \patest\StructType\Payment_AddWithdrawDepositPaymentToBasketRequest
     */
    public function setDepositId($depositId = null)
    {
        // validation for constraint: string
        if (!is_null($depositId) && !is_string($depositId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositId, true), gettype($depositId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositId, true)), __LINE__);
        }
        if (is_null($depositId) || (is_array($depositId) && empty($depositId))) {
            unset($this->DepositId);
        } else {
            $this->DepositId = $depositId;
        }
        return $this;
    }
    /**
     * Get DepositIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DepositIds|null
     */
    public function getDepositIds()
    {
        return isset($this->DepositIds) ? $this->DepositIds : null;
    }
    /**
     * Set DepositIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DepositIds $depositIds
     * @return \patest\StructType\Payment_AddWithdrawDepositPaymentToBasketRequest
     */
    public function setDepositIds(\patest\StructType\DepositIds $depositIds = null)
    {
        if (is_null($depositIds) || (is_array($depositIds) && empty($depositIds))) {
            unset($this->DepositIds);
        } else {
            $this->DepositIds = $depositIds;
        }
        return $this;
    }
}
