<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.AddPrefixPaymentDetailsToBasketRequest StructType
 * @subpackage Structs
 */
class Payment_AddPrefixPaymentDetailsToBasketRequest extends Payment_AddPaymentToBasketRequestBase
{
    /**
     * The Const_payment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Const_payment;
    /**
     * The First_payment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $First_payment;
    /**
     * The IsForFuturePayByCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForFuturePayByCustomer;
    /**
     * The PayUsingPaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PayUsingPaymentTokenId;
    /**
     * The Personal_Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Personal_Id;
    /**
     * The ShvaCreditTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShvaCreditTypeCode;
    /**
     * The UseStoredCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseStoredCard;
    /**
     * Constructor method for Payment.AddPrefixPaymentDetailsToBasketRequest
     * @uses Payment_AddPrefixPaymentDetailsToBasketRequest::setConst_payment()
     * @uses Payment_AddPrefixPaymentDetailsToBasketRequest::setFirst_payment()
     * @uses Payment_AddPrefixPaymentDetailsToBasketRequest::setIsForFuturePayByCustomer()
     * @uses Payment_AddPrefixPaymentDetailsToBasketRequest::setPayUsingPaymentTokenId()
     * @uses Payment_AddPrefixPaymentDetailsToBasketRequest::setPersonal_Id()
     * @uses Payment_AddPrefixPaymentDetailsToBasketRequest::setShvaCreditTypeCode()
     * @uses Payment_AddPrefixPaymentDetailsToBasketRequest::setUseStoredCard()
     * @param \patest\StructType\Money $const_payment
     * @param \patest\StructType\Money $first_payment
     * @param bool $isForFuturePayByCustomer
     * @param string $payUsingPaymentTokenId
     * @param string $personal_Id
     * @param string $shvaCreditTypeCode
     * @param bool $useStoredCard
     */
    public function __construct(\patest\StructType\Money $const_payment = null, \patest\StructType\Money $first_payment = null, $isForFuturePayByCustomer = null, $payUsingPaymentTokenId = null, $personal_Id = null, $shvaCreditTypeCode = null, $useStoredCard = null)
    {
        $this
            ->setConst_payment($const_payment)
            ->setFirst_payment($first_payment)
            ->setIsForFuturePayByCustomer($isForFuturePayByCustomer)
            ->setPayUsingPaymentTokenId($payUsingPaymentTokenId)
            ->setPersonal_Id($personal_Id)
            ->setShvaCreditTypeCode($shvaCreditTypeCode)
            ->setUseStoredCard($useStoredCard);
    }
    /**
     * Get Const_payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getConst_payment()
    {
        return isset($this->Const_payment) ? $this->Const_payment : null;
    }
    /**
     * Set Const_payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $const_payment
     * @return \patest\StructType\Payment_AddPrefixPaymentDetailsToBasketRequest
     */
    public function setConst_payment(\patest\StructType\Money $const_payment = null)
    {
        if (is_null($const_payment) || (is_array($const_payment) && empty($const_payment))) {
            unset($this->Const_payment);
        } else {
            $this->Const_payment = $const_payment;
        }
        return $this;
    }
    /**
     * Get First_payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getFirst_payment()
    {
        return isset($this->First_payment) ? $this->First_payment : null;
    }
    /**
     * Set First_payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $first_payment
     * @return \patest\StructType\Payment_AddPrefixPaymentDetailsToBasketRequest
     */
    public function setFirst_payment(\patest\StructType\Money $first_payment = null)
    {
        if (is_null($first_payment) || (is_array($first_payment) && empty($first_payment))) {
            unset($this->First_payment);
        } else {
            $this->First_payment = $first_payment;
        }
        return $this;
    }
    /**
     * Get IsForFuturePayByCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForFuturePayByCustomer()
    {
        return isset($this->IsForFuturePayByCustomer) ? $this->IsForFuturePayByCustomer : null;
    }
    /**
     * Set IsForFuturePayByCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForFuturePayByCustomer
     * @return \patest\StructType\Payment_AddPrefixPaymentDetailsToBasketRequest
     */
    public function setIsForFuturePayByCustomer($isForFuturePayByCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForFuturePayByCustomer) && !is_bool($isForFuturePayByCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForFuturePayByCustomer, true), gettype($isForFuturePayByCustomer)), __LINE__);
        }
        if (is_null($isForFuturePayByCustomer) || (is_array($isForFuturePayByCustomer) && empty($isForFuturePayByCustomer))) {
            unset($this->IsForFuturePayByCustomer);
        } else {
            $this->IsForFuturePayByCustomer = $isForFuturePayByCustomer;
        }
        return $this;
    }
    /**
     * Get PayUsingPaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayUsingPaymentTokenId()
    {
        return isset($this->PayUsingPaymentTokenId) ? $this->PayUsingPaymentTokenId : null;
    }
    /**
     * Set PayUsingPaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payUsingPaymentTokenId
     * @return \patest\StructType\Payment_AddPrefixPaymentDetailsToBasketRequest
     */
    public function setPayUsingPaymentTokenId($payUsingPaymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($payUsingPaymentTokenId) && !is_string($payUsingPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payUsingPaymentTokenId, true), gettype($payUsingPaymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($payUsingPaymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $payUsingPaymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($payUsingPaymentTokenId, true)), __LINE__);
        }
        if (is_null($payUsingPaymentTokenId) || (is_array($payUsingPaymentTokenId) && empty($payUsingPaymentTokenId))) {
            unset($this->PayUsingPaymentTokenId);
        } else {
            $this->PayUsingPaymentTokenId = $payUsingPaymentTokenId;
        }
        return $this;
    }
    /**
     * Get Personal_Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonal_Id()
    {
        return isset($this->Personal_Id) ? $this->Personal_Id : null;
    }
    /**
     * Set Personal_Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personal_Id
     * @return \patest\StructType\Payment_AddPrefixPaymentDetailsToBasketRequest
     */
    public function setPersonal_Id($personal_Id = null)
    {
        // validation for constraint: string
        if (!is_null($personal_Id) && !is_string($personal_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personal_Id, true), gettype($personal_Id)), __LINE__);
        }
        if (is_null($personal_Id) || (is_array($personal_Id) && empty($personal_Id))) {
            unset($this->Personal_Id);
        } else {
            $this->Personal_Id = $personal_Id;
        }
        return $this;
    }
    /**
     * Get ShvaCreditTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShvaCreditTypeCode()
    {
        return isset($this->ShvaCreditTypeCode) ? $this->ShvaCreditTypeCode : null;
    }
    /**
     * Set ShvaCreditTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shvaCreditTypeCode
     * @return \patest\StructType\Payment_AddPrefixPaymentDetailsToBasketRequest
     */
    public function setShvaCreditTypeCode($shvaCreditTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($shvaCreditTypeCode) && !is_string($shvaCreditTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shvaCreditTypeCode, true), gettype($shvaCreditTypeCode)), __LINE__);
        }
        if (is_null($shvaCreditTypeCode) || (is_array($shvaCreditTypeCode) && empty($shvaCreditTypeCode))) {
            unset($this->ShvaCreditTypeCode);
        } else {
            $this->ShvaCreditTypeCode = $shvaCreditTypeCode;
        }
        return $this;
    }
    /**
     * Get UseStoredCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseStoredCard()
    {
        return isset($this->UseStoredCard) ? $this->UseStoredCard : null;
    }
    /**
     * Set UseStoredCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useStoredCard
     * @return \patest\StructType\Payment_AddPrefixPaymentDetailsToBasketRequest
     */
    public function setUseStoredCard($useStoredCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($useStoredCard) && !is_bool($useStoredCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useStoredCard, true), gettype($useStoredCard)), __LINE__);
        }
        if (is_null($useStoredCard) || (is_array($useStoredCard) && empty($useStoredCard))) {
            unset($this->UseStoredCard);
        } else {
            $this->UseStoredCard = $useStoredCard;
        }
        return $this;
    }
}
