<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.AddCouponPaymentToBasketRequest StructType
 * @subpackage Structs
 */
class Payment_AddCouponPaymentToBasketRequest extends Payment_AddPaymentToBasketRequestBase
{
    /**
     * The CouponDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponDefinitionId;
    /**
     * The CouponDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CouponDetails;
    /**
     * The CouponNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CouponNumber;
    /**
     * Constructor method for Payment.AddCouponPaymentToBasketRequest
     * @uses Payment_AddCouponPaymentToBasketRequest::setCouponDefinitionId()
     * @uses Payment_AddCouponPaymentToBasketRequest::setCouponDetails()
     * @uses Payment_AddCouponPaymentToBasketRequest::setCouponNumber()
     * @param string $couponDefinitionId
     * @param string $couponDetails
     * @param string $couponNumber
     */
    public function __construct($couponDefinitionId = null, $couponDetails = null, $couponNumber = null)
    {
        $this
            ->setCouponDefinitionId($couponDefinitionId)
            ->setCouponDetails($couponDetails)
            ->setCouponNumber($couponNumber);
    }
    /**
     * Get CouponDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponDefinitionId()
    {
        return isset($this->CouponDefinitionId) ? $this->CouponDefinitionId : null;
    }
    /**
     * Set CouponDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponDefinitionId
     * @return \patest\StructType\Payment_AddCouponPaymentToBasketRequest
     */
    public function setCouponDefinitionId($couponDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($couponDefinitionId) && !is_string($couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponDefinitionId, true), gettype($couponDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponDefinitionId, true)), __LINE__);
        }
        if (is_null($couponDefinitionId) || (is_array($couponDefinitionId) && empty($couponDefinitionId))) {
            unset($this->CouponDefinitionId);
        } else {
            $this->CouponDefinitionId = $couponDefinitionId;
        }
        return $this;
    }
    /**
     * Get CouponDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponDetails()
    {
        return isset($this->CouponDetails) ? $this->CouponDetails : null;
    }
    /**
     * Set CouponDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponDetails
     * @return \patest\StructType\Payment_AddCouponPaymentToBasketRequest
     */
    public function setCouponDetails($couponDetails = null)
    {
        // validation for constraint: string
        if (!is_null($couponDetails) && !is_string($couponDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponDetails, true), gettype($couponDetails)), __LINE__);
        }
        if (is_null($couponDetails) || (is_array($couponDetails) && empty($couponDetails))) {
            unset($this->CouponDetails);
        } else {
            $this->CouponDetails = $couponDetails;
        }
        return $this;
    }
    /**
     * Get CouponNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponNumber()
    {
        return isset($this->CouponNumber) ? $this->CouponNumber : null;
    }
    /**
     * Set CouponNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponNumber
     * @return \patest\StructType\Payment_AddCouponPaymentToBasketRequest
     */
    public function setCouponNumber($couponNumber = null)
    {
        // validation for constraint: string
        if (!is_null($couponNumber) && !is_string($couponNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponNumber, true), gettype($couponNumber)), __LINE__);
        }
        if (is_null($couponNumber) || (is_array($couponNumber) && empty($couponNumber))) {
            unset($this->CouponNumber);
        } else {
            $this->CouponNumber = $couponNumber;
        }
        return $this;
    }
}
