<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.AddChequePaymentToBasketRequest StructType
 * @subpackage Structs
 */
class Payment_AddChequePaymentToBasketRequest extends Payment_AddPaymentToBasketRequestBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankCode;
    /**
     * The BranchCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BranchCode;
    /**
     * The ChequeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChequeNumber;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidFrom;
    /**
     * Constructor method for Payment.AddChequePaymentToBasketRequest
     * @uses Payment_AddChequePaymentToBasketRequest::setAccountNumber()
     * @uses Payment_AddChequePaymentToBasketRequest::setBankCode()
     * @uses Payment_AddChequePaymentToBasketRequest::setBranchCode()
     * @uses Payment_AddChequePaymentToBasketRequest::setChequeNumber()
     * @uses Payment_AddChequePaymentToBasketRequest::setValidFrom()
     * @param string $accountNumber
     * @param string $bankCode
     * @param string $branchCode
     * @param string $chequeNumber
     * @param string $validFrom
     */
    public function __construct($accountNumber = null, $bankCode = null, $branchCode = null, $chequeNumber = null, $validFrom = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setBankCode($bankCode)
            ->setBranchCode($branchCode)
            ->setChequeNumber($chequeNumber)
            ->setValidFrom($validFrom);
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \patest\StructType\Payment_AddChequePaymentToBasketRequest
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get BankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankCode()
    {
        return isset($this->BankCode) ? $this->BankCode : null;
    }
    /**
     * Set BankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankCode
     * @return \patest\StructType\Payment_AddChequePaymentToBasketRequest
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        if (is_null($bankCode) || (is_array($bankCode) && empty($bankCode))) {
            unset($this->BankCode);
        } else {
            $this->BankCode = $bankCode;
        }
        return $this;
    }
    /**
     * Get BranchCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBranchCode()
    {
        return isset($this->BranchCode) ? $this->BranchCode : null;
    }
    /**
     * Set BranchCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $branchCode
     * @return \patest\StructType\Payment_AddChequePaymentToBasketRequest
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchCode, true), gettype($branchCode)), __LINE__);
        }
        if (is_null($branchCode) || (is_array($branchCode) && empty($branchCode))) {
            unset($this->BranchCode);
        } else {
            $this->BranchCode = $branchCode;
        }
        return $this;
    }
    /**
     * Get ChequeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChequeNumber()
    {
        return isset($this->ChequeNumber) ? $this->ChequeNumber : null;
    }
    /**
     * Set ChequeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chequeNumber
     * @return \patest\StructType\Payment_AddChequePaymentToBasketRequest
     */
    public function setChequeNumber($chequeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($chequeNumber) && !is_string($chequeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chequeNumber, true), gettype($chequeNumber)), __LINE__);
        }
        if (is_null($chequeNumber) || (is_array($chequeNumber) && empty($chequeNumber))) {
            unset($this->ChequeNumber);
        } else {
            $this->ChequeNumber = $chequeNumber;
        }
        return $this;
    }
    /**
     * Get ValidFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidFrom()
    {
        return isset($this->ValidFrom) ? $this->ValidFrom : null;
    }
    /**
     * Set ValidFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validFrom
     * @return \patest\StructType\Payment_AddChequePaymentToBasketRequest
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        if (is_null($validFrom) || (is_array($validFrom) && empty($validFrom))) {
            unset($this->ValidFrom);
        } else {
            $this->ValidFrom = $validFrom;
        }
        return $this;
    }
}
