<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentPlanExistingDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentPlanExistingDescription
 * @subpackage Structs
 */
class PaymentPlanExistingDescription extends AbstractPaymentDescription
{
    /**
     * The ExistingPaymentInstallmentsScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExistingPaymentInstallmentsScheduleId;
    /**
     * Constructor method for PaymentPlanExistingDescription
     * @uses PaymentPlanExistingDescription::setExistingPaymentInstallmentsScheduleId()
     * @param string $existingPaymentInstallmentsScheduleId
     */
    public function __construct($existingPaymentInstallmentsScheduleId = null)
    {
        $this
            ->setExistingPaymentInstallmentsScheduleId($existingPaymentInstallmentsScheduleId);
    }
    /**
     * Get ExistingPaymentInstallmentsScheduleId value
     * @return string|null
     */
    public function getExistingPaymentInstallmentsScheduleId()
    {
        return $this->ExistingPaymentInstallmentsScheduleId;
    }
    /**
     * Set ExistingPaymentInstallmentsScheduleId value
     * @param string $existingPaymentInstallmentsScheduleId
     * @return \patest\StructType\PaymentPlanExistingDescription
     */
    public function setExistingPaymentInstallmentsScheduleId($existingPaymentInstallmentsScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($existingPaymentInstallmentsScheduleId) && !is_string($existingPaymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existingPaymentInstallmentsScheduleId, true), gettype($existingPaymentInstallmentsScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($existingPaymentInstallmentsScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $existingPaymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($existingPaymentInstallmentsScheduleId, true)), __LINE__);
        }
        $this->ExistingPaymentInstallmentsScheduleId = $existingPaymentInstallmentsScheduleId;
        return $this;
    }
}
