<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDataMin StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentDataMin
 * @subpackage Structs
 */
class PaymentDataMin extends SearchResultDataChunk
{
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $ClientAmount;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The PaymentGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentGuid;
    /**
     * The PaymentLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentLocalId;
    /**
     * The PaymentMethodDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodDescription;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The Receipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Receipt;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The ConfirmDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmDate;
    /**
     * The ConfirmedBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmedBy;
    /**
     * The DirectDebitAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DirectDebitAccountNumber;
    /**
     * The Installments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Installments;
    /**
     * The OPSReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OPSReferenceNumber;
    /**
     * The SpecialPaymentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecialPaymentId;
    /**
     * The SpecialPaymentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecialPaymentName;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The BankTransferReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankTransferReferenceNumber;
    /**
     * Constructor method for PaymentDataMin
     * @uses PaymentDataMin::setClientAmount()
     * @uses PaymentDataMin::setDetails()
     * @uses PaymentDataMin::setPaymentGuid()
     * @uses PaymentDataMin::setPaymentLocalId()
     * @uses PaymentDataMin::setPaymentMethodDescription()
     * @uses PaymentDataMin::setPaymentMethodType()
     * @uses PaymentDataMin::setReceipt()
     * @uses PaymentDataMin::setTransactionGuid()
     * @uses PaymentDataMin::setConfirmDate()
     * @uses PaymentDataMin::setConfirmedBy()
     * @uses PaymentDataMin::setDirectDebitAccountNumber()
     * @uses PaymentDataMin::setInstallments()
     * @uses PaymentDataMin::setOPSReferenceNumber()
     * @uses PaymentDataMin::setSpecialPaymentId()
     * @uses PaymentDataMin::setSpecialPaymentName()
     * @uses PaymentDataMin::setStatus()
     * @uses PaymentDataMin::setBankTransferReferenceNumber()
     * @param \patest\StructType\Money $clientAmount
     * @param string $details
     * @param string $paymentGuid
     * @param int $paymentLocalId
     * @param string $paymentMethodDescription
     * @param string $paymentMethodType
     * @param int $receipt
     * @param string $transactionGuid
     * @param string $confirmDate
     * @param string $confirmedBy
     * @param string $directDebitAccountNumber
     * @param int $installments
     * @param string $oPSReferenceNumber
     * @param string $specialPaymentId
     * @param string $specialPaymentName
     * @param string $status
     * @param string $bankTransferReferenceNumber
     */
    public function __construct(\patest\StructType\Money $clientAmount = null, $details = null, $paymentGuid = null, $paymentLocalId = null, $paymentMethodDescription = null, $paymentMethodType = null, $receipt = null, $transactionGuid = null, $confirmDate = null, $confirmedBy = null, $directDebitAccountNumber = null, $installments = null, $oPSReferenceNumber = null, $specialPaymentId = null, $specialPaymentName = null, $status = null, $bankTransferReferenceNumber = null)
    {
        $this
            ->setClientAmount($clientAmount)
            ->setDetails($details)
            ->setPaymentGuid($paymentGuid)
            ->setPaymentLocalId($paymentLocalId)
            ->setPaymentMethodDescription($paymentMethodDescription)
            ->setPaymentMethodType($paymentMethodType)
            ->setReceipt($receipt)
            ->setTransactionGuid($transactionGuid)
            ->setConfirmDate($confirmDate)
            ->setConfirmedBy($confirmedBy)
            ->setDirectDebitAccountNumber($directDebitAccountNumber)
            ->setInstallments($installments)
            ->setOPSReferenceNumber($oPSReferenceNumber)
            ->setSpecialPaymentId($specialPaymentId)
            ->setSpecialPaymentName($specialPaymentName)
            ->setStatus($status)
            ->setBankTransferReferenceNumber($bankTransferReferenceNumber);
    }
    /**
     * Get ClientAmount value
     * @return \patest\StructType\Money|null
     */
    public function getClientAmount()
    {
        return $this->ClientAmount;
    }
    /**
     * Set ClientAmount value
     * @param \patest\StructType\Money $clientAmount
     * @return \patest\StructType\PaymentDataMin
     */
    public function setClientAmount(\patest\StructType\Money $clientAmount = null)
    {
        $this->ClientAmount = $clientAmount;
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \patest\StructType\PaymentDataMin
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get PaymentGuid value
     * @return string|null
     */
    public function getPaymentGuid()
    {
        return $this->PaymentGuid;
    }
    /**
     * Set PaymentGuid value
     * @param string $paymentGuid
     * @return \patest\StructType\PaymentDataMin
     */
    public function setPaymentGuid($paymentGuid = null)
    {
        // validation for constraint: string
        if (!is_null($paymentGuid) && !is_string($paymentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentGuid, true), gettype($paymentGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentGuid, true)), __LINE__);
        }
        $this->PaymentGuid = $paymentGuid;
        return $this;
    }
    /**
     * Get PaymentLocalId value
     * @return int|null
     */
    public function getPaymentLocalId()
    {
        return $this->PaymentLocalId;
    }
    /**
     * Set PaymentLocalId value
     * @param int $paymentLocalId
     * @return \patest\StructType\PaymentDataMin
     */
    public function setPaymentLocalId($paymentLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentLocalId) && !(is_int($paymentLocalId) || ctype_digit($paymentLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentLocalId, true), gettype($paymentLocalId)), __LINE__);
        }
        $this->PaymentLocalId = $paymentLocalId;
        return $this;
    }
    /**
     * Get PaymentMethodDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodDescription()
    {
        return isset($this->PaymentMethodDescription) ? $this->PaymentMethodDescription : null;
    }
    /**
     * Set PaymentMethodDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodDescription
     * @return \patest\StructType\PaymentDataMin
     */
    public function setPaymentMethodDescription($paymentMethodDescription = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodDescription) && !is_string($paymentMethodDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodDescription, true), gettype($paymentMethodDescription)), __LINE__);
        }
        if (is_null($paymentMethodDescription) || (is_array($paymentMethodDescription) && empty($paymentMethodDescription))) {
            unset($this->PaymentMethodDescription);
        } else {
            $this->PaymentMethodDescription = $paymentMethodDescription;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return $this->PaymentMethodType;
    }
    /**
     * Set PaymentMethodType value
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\PaymentDataMin
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        $this->PaymentMethodType = $paymentMethodType;
        return $this;
    }
    /**
     * Get Receipt value
     * @return int|null
     */
    public function getReceipt()
    {
        return $this->Receipt;
    }
    /**
     * Set Receipt value
     * @param int $receipt
     * @return \patest\StructType\PaymentDataMin
     */
    public function setReceipt($receipt = null)
    {
        // validation for constraint: int
        if (!is_null($receipt) && !(is_int($receipt) || ctype_digit($receipt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($receipt, true), gettype($receipt)), __LINE__);
        }
        $this->Receipt = $receipt;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\PaymentDataMin
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get ConfirmDate value
     * @return string|null
     */
    public function getConfirmDate()
    {
        return $this->ConfirmDate;
    }
    /**
     * Set ConfirmDate value
     * @param string $confirmDate
     * @return \patest\StructType\PaymentDataMin
     */
    public function setConfirmDate($confirmDate = null)
    {
        // validation for constraint: string
        if (!is_null($confirmDate) && !is_string($confirmDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmDate, true), gettype($confirmDate)), __LINE__);
        }
        $this->ConfirmDate = $confirmDate;
        return $this;
    }
    /**
     * Get ConfirmedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmedBy()
    {
        return isset($this->ConfirmedBy) ? $this->ConfirmedBy : null;
    }
    /**
     * Set ConfirmedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmedBy
     * @return \patest\StructType\PaymentDataMin
     */
    public function setConfirmedBy($confirmedBy = null)
    {
        // validation for constraint: string
        if (!is_null($confirmedBy) && !is_string($confirmedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmedBy, true), gettype($confirmedBy)), __LINE__);
        }
        if (is_null($confirmedBy) || (is_array($confirmedBy) && empty($confirmedBy))) {
            unset($this->ConfirmedBy);
        } else {
            $this->ConfirmedBy = $confirmedBy;
        }
        return $this;
    }
    /**
     * Get DirectDebitAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectDebitAccountNumber()
    {
        return isset($this->DirectDebitAccountNumber) ? $this->DirectDebitAccountNumber : null;
    }
    /**
     * Set DirectDebitAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directDebitAccountNumber
     * @return \patest\StructType\PaymentDataMin
     */
    public function setDirectDebitAccountNumber($directDebitAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($directDebitAccountNumber) && !is_string($directDebitAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDebitAccountNumber, true), gettype($directDebitAccountNumber)), __LINE__);
        }
        if (is_null($directDebitAccountNumber) || (is_array($directDebitAccountNumber) && empty($directDebitAccountNumber))) {
            unset($this->DirectDebitAccountNumber);
        } else {
            $this->DirectDebitAccountNumber = $directDebitAccountNumber;
        }
        return $this;
    }
    /**
     * Get Installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInstallments()
    {
        return isset($this->Installments) ? $this->Installments : null;
    }
    /**
     * Set Installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $installments
     * @return \patest\StructType\PaymentDataMin
     */
    public function setInstallments($installments = null)
    {
        // validation for constraint: int
        if (!is_null($installments) && !(is_int($installments) || ctype_digit($installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($installments, true), gettype($installments)), __LINE__);
        }
        if (is_null($installments) || (is_array($installments) && empty($installments))) {
            unset($this->Installments);
        } else {
            $this->Installments = $installments;
        }
        return $this;
    }
    /**
     * Get OPSReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPSReferenceNumber()
    {
        return isset($this->OPSReferenceNumber) ? $this->OPSReferenceNumber : null;
    }
    /**
     * Set OPSReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPSReferenceNumber
     * @return \patest\StructType\PaymentDataMin
     */
    public function setOPSReferenceNumber($oPSReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($oPSReferenceNumber) && !is_string($oPSReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oPSReferenceNumber, true), gettype($oPSReferenceNumber)), __LINE__);
        }
        if (is_null($oPSReferenceNumber) || (is_array($oPSReferenceNumber) && empty($oPSReferenceNumber))) {
            unset($this->OPSReferenceNumber);
        } else {
            $this->OPSReferenceNumber = $oPSReferenceNumber;
        }
        return $this;
    }
    /**
     * Get SpecialPaymentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecialPaymentId()
    {
        return isset($this->SpecialPaymentId) ? $this->SpecialPaymentId : null;
    }
    /**
     * Set SpecialPaymentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specialPaymentId
     * @return \patest\StructType\PaymentDataMin
     */
    public function setSpecialPaymentId($specialPaymentId = null)
    {
        // validation for constraint: string
        if (!is_null($specialPaymentId) && !is_string($specialPaymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialPaymentId, true), gettype($specialPaymentId)), __LINE__);
        }
        if (is_null($specialPaymentId) || (is_array($specialPaymentId) && empty($specialPaymentId))) {
            unset($this->SpecialPaymentId);
        } else {
            $this->SpecialPaymentId = $specialPaymentId;
        }
        return $this;
    }
    /**
     * Get SpecialPaymentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecialPaymentName()
    {
        return isset($this->SpecialPaymentName) ? $this->SpecialPaymentName : null;
    }
    /**
     * Set SpecialPaymentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specialPaymentName
     * @return \patest\StructType\PaymentDataMin
     */
    public function setSpecialPaymentName($specialPaymentName = null)
    {
        // validation for constraint: string
        if (!is_null($specialPaymentName) && !is_string($specialPaymentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialPaymentName, true), gettype($specialPaymentName)), __LINE__);
        }
        if (is_null($specialPaymentName) || (is_array($specialPaymentName) && empty($specialPaymentName))) {
            unset($this->SpecialPaymentName);
        } else {
            $this->SpecialPaymentName = $specialPaymentName;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\PaymentDataMin
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get BankTransferReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankTransferReferenceNumber()
    {
        return isset($this->BankTransferReferenceNumber) ? $this->BankTransferReferenceNumber : null;
    }
    /**
     * Set BankTransferReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankTransferReferenceNumber
     * @return \patest\StructType\PaymentDataMin
     */
    public function setBankTransferReferenceNumber($bankTransferReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankTransferReferenceNumber) && !is_string($bankTransferReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankTransferReferenceNumber, true), gettype($bankTransferReferenceNumber)), __LINE__);
        }
        if (is_null($bankTransferReferenceNumber) || (is_array($bankTransferReferenceNumber) && empty($bankTransferReferenceNumber))) {
            unset($this->BankTransferReferenceNumber);
        } else {
            $this->BankTransferReferenceNumber = $bankTransferReferenceNumber;
        }
        return $this;
    }
}
