<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCriteria StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentCriteria
 * @subpackage Structs
 */
class PaymentCriteria extends AbstractCriteria
{
    /**
     * The CreditCardExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $CreditCardExpiryDate;
    /**
     * The CreditCardLastFourDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $CreditCardLastFourDigits;
    /**
     * The PaymentMethodsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $PaymentMethodsList;
    /**
     * The PaymentPlanNextDueDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfdateTime
     */
    public $PaymentPlanNextDueDateFrom;
    /**
     * The PaymentPlanNextDueDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfdateTime
     */
    public $PaymentPlanNextDueDateTo;
    /**
     * The Receipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfint
     */
    public $Receipt;
    /**
     * The UnpaidAmountFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfdouble
     */
    public $UnpaidAmountFrom;
    /**
     * The UnpaidAmountTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfdouble
     */
    public $UnpaidAmountTo;
    /**
     * The BankTransferReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $BankTransferReferenceNumber;
    /**
     * The CreditCardToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfguid
     */
    public $CreditCardToken;
    /**
     * The DirectDebitAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $DirectDebitAccountNumber;
    /**
     * The OPSReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $OPSReferenceNumber;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfPaymentItemStatus8Q8HnG_P7
     */
    public $PaymentStatus;
    /**
     * The PaymentStatusList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $PaymentStatusList;
    /**
     * The ReferenceNumberGeneral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $ReferenceNumberGeneral;
    /**
     * The AccountNumberGeneral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $AccountNumberGeneral;
    /**
     * The BankCodeGeneral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $BankCodeGeneral;
    /**
     * The ChequeAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $ChequeAccountNumber;
    /**
     * The ChequeBankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $ChequeBankCode;
    /**
     * The ChequeBranchCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $ChequeBranchCode;
    /**
     * The ChequeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $ChequeNumber;
    /**
     * The CouponDefinitionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfguid
     */
    public $CouponDefinitionId;
    /**
     * The CouponOrVoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $CouponOrVoucherNumber;
    /**
     * The DirectDebitBankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $DirectDebitBankCode;
    /**
     * The GiftCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $GiftCardNumber;
    /**
     * The GiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfguid
     */
    public $GiftVoucherDefinitionId;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfint
     */
    public $MandateNumber;
    /**
     * The MandateTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfguid
     */
    public $MandateTypeId;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfPaymentMethodType8Q8HnG_P7
     */
    public $PaymentMethodType;
    /**
     * The RefundCategoryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfguid
     */
    public $RefundCategoryId;
    /**
     * The CreditCardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $CreditCardSuffix;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfguid
     */
    public $PaymentMethodId;
    /**
     * The CouponDefinitionIdList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $CouponDefinitionIdList;
    /**
     * The GiftVoucherDefinitionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $GiftVoucherDefinitionList;
    /**
     * The GiftVoucherTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfguid
     */
    public $GiftVoucherTypeId;
    /**
     * The RefundCategoryIdList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SinglePropertyCriteriaOfstring
     */
    public $RefundCategoryIdList;
    /**
     * Constructor method for PaymentCriteria
     * @uses PaymentCriteria::setCreditCardExpiryDate()
     * @uses PaymentCriteria::setCreditCardLastFourDigits()
     * @uses PaymentCriteria::setPaymentMethodsList()
     * @uses PaymentCriteria::setPaymentPlanNextDueDateFrom()
     * @uses PaymentCriteria::setPaymentPlanNextDueDateTo()
     * @uses PaymentCriteria::setReceipt()
     * @uses PaymentCriteria::setUnpaidAmountFrom()
     * @uses PaymentCriteria::setUnpaidAmountTo()
     * @uses PaymentCriteria::setBankTransferReferenceNumber()
     * @uses PaymentCriteria::setCreditCardToken()
     * @uses PaymentCriteria::setDirectDebitAccountNumber()
     * @uses PaymentCriteria::setOPSReferenceNumber()
     * @uses PaymentCriteria::setPaymentStatus()
     * @uses PaymentCriteria::setPaymentStatusList()
     * @uses PaymentCriteria::setReferenceNumberGeneral()
     * @uses PaymentCriteria::setAccountNumberGeneral()
     * @uses PaymentCriteria::setBankCodeGeneral()
     * @uses PaymentCriteria::setChequeAccountNumber()
     * @uses PaymentCriteria::setChequeBankCode()
     * @uses PaymentCriteria::setChequeBranchCode()
     * @uses PaymentCriteria::setChequeNumber()
     * @uses PaymentCriteria::setCouponDefinitionId()
     * @uses PaymentCriteria::setCouponOrVoucherNumber()
     * @uses PaymentCriteria::setDirectDebitBankCode()
     * @uses PaymentCriteria::setGiftCardNumber()
     * @uses PaymentCriteria::setGiftVoucherDefinitionId()
     * @uses PaymentCriteria::setMandateNumber()
     * @uses PaymentCriteria::setMandateTypeId()
     * @uses PaymentCriteria::setPaymentMethodType()
     * @uses PaymentCriteria::setRefundCategoryId()
     * @uses PaymentCriteria::setCreditCardSuffix()
     * @uses PaymentCriteria::setPaymentMethodId()
     * @uses PaymentCriteria::setCouponDefinitionIdList()
     * @uses PaymentCriteria::setGiftVoucherDefinitionList()
     * @uses PaymentCriteria::setGiftVoucherTypeId()
     * @uses PaymentCriteria::setRefundCategoryIdList()
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $creditCardExpiryDate
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $creditCardLastFourDigits
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $paymentMethodsList
     * @param \patest\StructType\SinglePropertyCriteriaOfdateTime $paymentPlanNextDueDateFrom
     * @param \patest\StructType\SinglePropertyCriteriaOfdateTime $paymentPlanNextDueDateTo
     * @param \patest\StructType\SinglePropertyCriteriaOfint $receipt
     * @param \patest\StructType\SinglePropertyCriteriaOfdouble $unpaidAmountFrom
     * @param \patest\StructType\SinglePropertyCriteriaOfdouble $unpaidAmountTo
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $bankTransferReferenceNumber
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $creditCardToken
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $directDebitAccountNumber
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $oPSReferenceNumber
     * @param \patest\StructType\SinglePropertyCriteriaOfPaymentItemStatus8Q8HnG_P7 $paymentStatus
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $paymentStatusList
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $referenceNumberGeneral
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $accountNumberGeneral
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $bankCodeGeneral
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $chequeAccountNumber
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $chequeBankCode
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $chequeBranchCode
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $chequeNumber
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $couponDefinitionId
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $couponOrVoucherNumber
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $directDebitBankCode
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $giftCardNumber
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $giftVoucherDefinitionId
     * @param \patest\StructType\SinglePropertyCriteriaOfint $mandateNumber
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $mandateTypeId
     * @param \patest\StructType\SinglePropertyCriteriaOfPaymentMethodType8Q8HnG_P7 $paymentMethodType
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $refundCategoryId
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $creditCardSuffix
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $paymentMethodId
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $couponDefinitionIdList
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $giftVoucherDefinitionList
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $giftVoucherTypeId
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $refundCategoryIdList
     */
    public function __construct(\patest\StructType\SinglePropertyCriteriaOfstring $creditCardExpiryDate = null, \patest\StructType\SinglePropertyCriteriaOfstring $creditCardLastFourDigits = null, \patest\StructType\SinglePropertyCriteriaOfstring $paymentMethodsList = null, \patest\StructType\SinglePropertyCriteriaOfdateTime $paymentPlanNextDueDateFrom = null, \patest\StructType\SinglePropertyCriteriaOfdateTime $paymentPlanNextDueDateTo = null, \patest\StructType\SinglePropertyCriteriaOfint $receipt = null, \patest\StructType\SinglePropertyCriteriaOfdouble $unpaidAmountFrom = null, \patest\StructType\SinglePropertyCriteriaOfdouble $unpaidAmountTo = null, \patest\StructType\SinglePropertyCriteriaOfstring $bankTransferReferenceNumber = null, \patest\StructType\SinglePropertyCriteriaOfguid $creditCardToken = null, \patest\StructType\SinglePropertyCriteriaOfstring $directDebitAccountNumber = null, \patest\StructType\SinglePropertyCriteriaOfstring $oPSReferenceNumber = null, \patest\StructType\SinglePropertyCriteriaOfPaymentItemStatus8Q8HnG_P7 $paymentStatus = null, \patest\StructType\SinglePropertyCriteriaOfstring $paymentStatusList = null, \patest\StructType\SinglePropertyCriteriaOfstring $referenceNumberGeneral = null, \patest\StructType\SinglePropertyCriteriaOfstring $accountNumberGeneral = null, \patest\StructType\SinglePropertyCriteriaOfstring $bankCodeGeneral = null, \patest\StructType\SinglePropertyCriteriaOfstring $chequeAccountNumber = null, \patest\StructType\SinglePropertyCriteriaOfstring $chequeBankCode = null, \patest\StructType\SinglePropertyCriteriaOfstring $chequeBranchCode = null, \patest\StructType\SinglePropertyCriteriaOfstring $chequeNumber = null, \patest\StructType\SinglePropertyCriteriaOfguid $couponDefinitionId = null, \patest\StructType\SinglePropertyCriteriaOfstring $couponOrVoucherNumber = null, \patest\StructType\SinglePropertyCriteriaOfstring $directDebitBankCode = null, \patest\StructType\SinglePropertyCriteriaOfstring $giftCardNumber = null, \patest\StructType\SinglePropertyCriteriaOfguid $giftVoucherDefinitionId = null, \patest\StructType\SinglePropertyCriteriaOfint $mandateNumber = null, \patest\StructType\SinglePropertyCriteriaOfguid $mandateTypeId = null, \patest\StructType\SinglePropertyCriteriaOfPaymentMethodType8Q8HnG_P7 $paymentMethodType = null, \patest\StructType\SinglePropertyCriteriaOfguid $refundCategoryId = null, \patest\StructType\SinglePropertyCriteriaOfstring $creditCardSuffix = null, \patest\StructType\SinglePropertyCriteriaOfguid $paymentMethodId = null, \patest\StructType\SinglePropertyCriteriaOfstring $couponDefinitionIdList = null, \patest\StructType\SinglePropertyCriteriaOfstring $giftVoucherDefinitionList = null, \patest\StructType\SinglePropertyCriteriaOfguid $giftVoucherTypeId = null, \patest\StructType\SinglePropertyCriteriaOfstring $refundCategoryIdList = null)
    {
        $this
            ->setCreditCardExpiryDate($creditCardExpiryDate)
            ->setCreditCardLastFourDigits($creditCardLastFourDigits)
            ->setPaymentMethodsList($paymentMethodsList)
            ->setPaymentPlanNextDueDateFrom($paymentPlanNextDueDateFrom)
            ->setPaymentPlanNextDueDateTo($paymentPlanNextDueDateTo)
            ->setReceipt($receipt)
            ->setUnpaidAmountFrom($unpaidAmountFrom)
            ->setUnpaidAmountTo($unpaidAmountTo)
            ->setBankTransferReferenceNumber($bankTransferReferenceNumber)
            ->setCreditCardToken($creditCardToken)
            ->setDirectDebitAccountNumber($directDebitAccountNumber)
            ->setOPSReferenceNumber($oPSReferenceNumber)
            ->setPaymentStatus($paymentStatus)
            ->setPaymentStatusList($paymentStatusList)
            ->setReferenceNumberGeneral($referenceNumberGeneral)
            ->setAccountNumberGeneral($accountNumberGeneral)
            ->setBankCodeGeneral($bankCodeGeneral)
            ->setChequeAccountNumber($chequeAccountNumber)
            ->setChequeBankCode($chequeBankCode)
            ->setChequeBranchCode($chequeBranchCode)
            ->setChequeNumber($chequeNumber)
            ->setCouponDefinitionId($couponDefinitionId)
            ->setCouponOrVoucherNumber($couponOrVoucherNumber)
            ->setDirectDebitBankCode($directDebitBankCode)
            ->setGiftCardNumber($giftCardNumber)
            ->setGiftVoucherDefinitionId($giftVoucherDefinitionId)
            ->setMandateNumber($mandateNumber)
            ->setMandateTypeId($mandateTypeId)
            ->setPaymentMethodType($paymentMethodType)
            ->setRefundCategoryId($refundCategoryId)
            ->setCreditCardSuffix($creditCardSuffix)
            ->setPaymentMethodId($paymentMethodId)
            ->setCouponDefinitionIdList($couponDefinitionIdList)
            ->setGiftVoucherDefinitionList($giftVoucherDefinitionList)
            ->setGiftVoucherTypeId($giftVoucherTypeId)
            ->setRefundCategoryIdList($refundCategoryIdList);
    }
    /**
     * Get CreditCardExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getCreditCardExpiryDate()
    {
        return isset($this->CreditCardExpiryDate) ? $this->CreditCardExpiryDate : null;
    }
    /**
     * Set CreditCardExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $creditCardExpiryDate
     * @return \patest\StructType\PaymentCriteria
     */
    public function setCreditCardExpiryDate(\patest\StructType\SinglePropertyCriteriaOfstring $creditCardExpiryDate = null)
    {
        if (is_null($creditCardExpiryDate) || (is_array($creditCardExpiryDate) && empty($creditCardExpiryDate))) {
            unset($this->CreditCardExpiryDate);
        } else {
            $this->CreditCardExpiryDate = $creditCardExpiryDate;
        }
        return $this;
    }
    /**
     * Get CreditCardLastFourDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getCreditCardLastFourDigits()
    {
        return isset($this->CreditCardLastFourDigits) ? $this->CreditCardLastFourDigits : null;
    }
    /**
     * Set CreditCardLastFourDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $creditCardLastFourDigits
     * @return \patest\StructType\PaymentCriteria
     */
    public function setCreditCardLastFourDigits(\patest\StructType\SinglePropertyCriteriaOfstring $creditCardLastFourDigits = null)
    {
        if (is_null($creditCardLastFourDigits) || (is_array($creditCardLastFourDigits) && empty($creditCardLastFourDigits))) {
            unset($this->CreditCardLastFourDigits);
        } else {
            $this->CreditCardLastFourDigits = $creditCardLastFourDigits;
        }
        return $this;
    }
    /**
     * Get PaymentMethodsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getPaymentMethodsList()
    {
        return isset($this->PaymentMethodsList) ? $this->PaymentMethodsList : null;
    }
    /**
     * Set PaymentMethodsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $paymentMethodsList
     * @return \patest\StructType\PaymentCriteria
     */
    public function setPaymentMethodsList(\patest\StructType\SinglePropertyCriteriaOfstring $paymentMethodsList = null)
    {
        if (is_null($paymentMethodsList) || (is_array($paymentMethodsList) && empty($paymentMethodsList))) {
            unset($this->PaymentMethodsList);
        } else {
            $this->PaymentMethodsList = $paymentMethodsList;
        }
        return $this;
    }
    /**
     * Get PaymentPlanNextDueDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfdateTime|null
     */
    public function getPaymentPlanNextDueDateFrom()
    {
        return isset($this->PaymentPlanNextDueDateFrom) ? $this->PaymentPlanNextDueDateFrom : null;
    }
    /**
     * Set PaymentPlanNextDueDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfdateTime $paymentPlanNextDueDateFrom
     * @return \patest\StructType\PaymentCriteria
     */
    public function setPaymentPlanNextDueDateFrom(\patest\StructType\SinglePropertyCriteriaOfdateTime $paymentPlanNextDueDateFrom = null)
    {
        if (is_null($paymentPlanNextDueDateFrom) || (is_array($paymentPlanNextDueDateFrom) && empty($paymentPlanNextDueDateFrom))) {
            unset($this->PaymentPlanNextDueDateFrom);
        } else {
            $this->PaymentPlanNextDueDateFrom = $paymentPlanNextDueDateFrom;
        }
        return $this;
    }
    /**
     * Get PaymentPlanNextDueDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfdateTime|null
     */
    public function getPaymentPlanNextDueDateTo()
    {
        return isset($this->PaymentPlanNextDueDateTo) ? $this->PaymentPlanNextDueDateTo : null;
    }
    /**
     * Set PaymentPlanNextDueDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfdateTime $paymentPlanNextDueDateTo
     * @return \patest\StructType\PaymentCriteria
     */
    public function setPaymentPlanNextDueDateTo(\patest\StructType\SinglePropertyCriteriaOfdateTime $paymentPlanNextDueDateTo = null)
    {
        if (is_null($paymentPlanNextDueDateTo) || (is_array($paymentPlanNextDueDateTo) && empty($paymentPlanNextDueDateTo))) {
            unset($this->PaymentPlanNextDueDateTo);
        } else {
            $this->PaymentPlanNextDueDateTo = $paymentPlanNextDueDateTo;
        }
        return $this;
    }
    /**
     * Get Receipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfint|null
     */
    public function getReceipt()
    {
        return isset($this->Receipt) ? $this->Receipt : null;
    }
    /**
     * Set Receipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfint $receipt
     * @return \patest\StructType\PaymentCriteria
     */
    public function setReceipt(\patest\StructType\SinglePropertyCriteriaOfint $receipt = null)
    {
        if (is_null($receipt) || (is_array($receipt) && empty($receipt))) {
            unset($this->Receipt);
        } else {
            $this->Receipt = $receipt;
        }
        return $this;
    }
    /**
     * Get UnpaidAmountFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfdouble|null
     */
    public function getUnpaidAmountFrom()
    {
        return isset($this->UnpaidAmountFrom) ? $this->UnpaidAmountFrom : null;
    }
    /**
     * Set UnpaidAmountFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfdouble $unpaidAmountFrom
     * @return \patest\StructType\PaymentCriteria
     */
    public function setUnpaidAmountFrom(\patest\StructType\SinglePropertyCriteriaOfdouble $unpaidAmountFrom = null)
    {
        if (is_null($unpaidAmountFrom) || (is_array($unpaidAmountFrom) && empty($unpaidAmountFrom))) {
            unset($this->UnpaidAmountFrom);
        } else {
            $this->UnpaidAmountFrom = $unpaidAmountFrom;
        }
        return $this;
    }
    /**
     * Get UnpaidAmountTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfdouble|null
     */
    public function getUnpaidAmountTo()
    {
        return isset($this->UnpaidAmountTo) ? $this->UnpaidAmountTo : null;
    }
    /**
     * Set UnpaidAmountTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfdouble $unpaidAmountTo
     * @return \patest\StructType\PaymentCriteria
     */
    public function setUnpaidAmountTo(\patest\StructType\SinglePropertyCriteriaOfdouble $unpaidAmountTo = null)
    {
        if (is_null($unpaidAmountTo) || (is_array($unpaidAmountTo) && empty($unpaidAmountTo))) {
            unset($this->UnpaidAmountTo);
        } else {
            $this->UnpaidAmountTo = $unpaidAmountTo;
        }
        return $this;
    }
    /**
     * Get BankTransferReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getBankTransferReferenceNumber()
    {
        return isset($this->BankTransferReferenceNumber) ? $this->BankTransferReferenceNumber : null;
    }
    /**
     * Set BankTransferReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $bankTransferReferenceNumber
     * @return \patest\StructType\PaymentCriteria
     */
    public function setBankTransferReferenceNumber(\patest\StructType\SinglePropertyCriteriaOfstring $bankTransferReferenceNumber = null)
    {
        if (is_null($bankTransferReferenceNumber) || (is_array($bankTransferReferenceNumber) && empty($bankTransferReferenceNumber))) {
            unset($this->BankTransferReferenceNumber);
        } else {
            $this->BankTransferReferenceNumber = $bankTransferReferenceNumber;
        }
        return $this;
    }
    /**
     * Get CreditCardToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfguid|null
     */
    public function getCreditCardToken()
    {
        return isset($this->CreditCardToken) ? $this->CreditCardToken : null;
    }
    /**
     * Set CreditCardToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $creditCardToken
     * @return \patest\StructType\PaymentCriteria
     */
    public function setCreditCardToken(\patest\StructType\SinglePropertyCriteriaOfguid $creditCardToken = null)
    {
        if (is_null($creditCardToken) || (is_array($creditCardToken) && empty($creditCardToken))) {
            unset($this->CreditCardToken);
        } else {
            $this->CreditCardToken = $creditCardToken;
        }
        return $this;
    }
    /**
     * Get DirectDebitAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getDirectDebitAccountNumber()
    {
        return isset($this->DirectDebitAccountNumber) ? $this->DirectDebitAccountNumber : null;
    }
    /**
     * Set DirectDebitAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $directDebitAccountNumber
     * @return \patest\StructType\PaymentCriteria
     */
    public function setDirectDebitAccountNumber(\patest\StructType\SinglePropertyCriteriaOfstring $directDebitAccountNumber = null)
    {
        if (is_null($directDebitAccountNumber) || (is_array($directDebitAccountNumber) && empty($directDebitAccountNumber))) {
            unset($this->DirectDebitAccountNumber);
        } else {
            $this->DirectDebitAccountNumber = $directDebitAccountNumber;
        }
        return $this;
    }
    /**
     * Get OPSReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getOPSReferenceNumber()
    {
        return isset($this->OPSReferenceNumber) ? $this->OPSReferenceNumber : null;
    }
    /**
     * Set OPSReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $oPSReferenceNumber
     * @return \patest\StructType\PaymentCriteria
     */
    public function setOPSReferenceNumber(\patest\StructType\SinglePropertyCriteriaOfstring $oPSReferenceNumber = null)
    {
        if (is_null($oPSReferenceNumber) || (is_array($oPSReferenceNumber) && empty($oPSReferenceNumber))) {
            unset($this->OPSReferenceNumber);
        } else {
            $this->OPSReferenceNumber = $oPSReferenceNumber;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfPaymentItemStatus8Q8HnG_P7|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfPaymentItemStatus8Q8HnG_P7 $paymentStatus
     * @return \patest\StructType\PaymentCriteria
     */
    public function setPaymentStatus(\patest\StructType\SinglePropertyCriteriaOfPaymentItemStatus8Q8HnG_P7 $paymentStatus = null)
    {
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get PaymentStatusList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getPaymentStatusList()
    {
        return isset($this->PaymentStatusList) ? $this->PaymentStatusList : null;
    }
    /**
     * Set PaymentStatusList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $paymentStatusList
     * @return \patest\StructType\PaymentCriteria
     */
    public function setPaymentStatusList(\patest\StructType\SinglePropertyCriteriaOfstring $paymentStatusList = null)
    {
        if (is_null($paymentStatusList) || (is_array($paymentStatusList) && empty($paymentStatusList))) {
            unset($this->PaymentStatusList);
        } else {
            $this->PaymentStatusList = $paymentStatusList;
        }
        return $this;
    }
    /**
     * Get ReferenceNumberGeneral value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getReferenceNumberGeneral()
    {
        return isset($this->ReferenceNumberGeneral) ? $this->ReferenceNumberGeneral : null;
    }
    /**
     * Set ReferenceNumberGeneral value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $referenceNumberGeneral
     * @return \patest\StructType\PaymentCriteria
     */
    public function setReferenceNumberGeneral(\patest\StructType\SinglePropertyCriteriaOfstring $referenceNumberGeneral = null)
    {
        if (is_null($referenceNumberGeneral) || (is_array($referenceNumberGeneral) && empty($referenceNumberGeneral))) {
            unset($this->ReferenceNumberGeneral);
        } else {
            $this->ReferenceNumberGeneral = $referenceNumberGeneral;
        }
        return $this;
    }
    /**
     * Get AccountNumberGeneral value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getAccountNumberGeneral()
    {
        return isset($this->AccountNumberGeneral) ? $this->AccountNumberGeneral : null;
    }
    /**
     * Set AccountNumberGeneral value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $accountNumberGeneral
     * @return \patest\StructType\PaymentCriteria
     */
    public function setAccountNumberGeneral(\patest\StructType\SinglePropertyCriteriaOfstring $accountNumberGeneral = null)
    {
        if (is_null($accountNumberGeneral) || (is_array($accountNumberGeneral) && empty($accountNumberGeneral))) {
            unset($this->AccountNumberGeneral);
        } else {
            $this->AccountNumberGeneral = $accountNumberGeneral;
        }
        return $this;
    }
    /**
     * Get BankCodeGeneral value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getBankCodeGeneral()
    {
        return isset($this->BankCodeGeneral) ? $this->BankCodeGeneral : null;
    }
    /**
     * Set BankCodeGeneral value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $bankCodeGeneral
     * @return \patest\StructType\PaymentCriteria
     */
    public function setBankCodeGeneral(\patest\StructType\SinglePropertyCriteriaOfstring $bankCodeGeneral = null)
    {
        if (is_null($bankCodeGeneral) || (is_array($bankCodeGeneral) && empty($bankCodeGeneral))) {
            unset($this->BankCodeGeneral);
        } else {
            $this->BankCodeGeneral = $bankCodeGeneral;
        }
        return $this;
    }
    /**
     * Get ChequeAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getChequeAccountNumber()
    {
        return isset($this->ChequeAccountNumber) ? $this->ChequeAccountNumber : null;
    }
    /**
     * Set ChequeAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $chequeAccountNumber
     * @return \patest\StructType\PaymentCriteria
     */
    public function setChequeAccountNumber(\patest\StructType\SinglePropertyCriteriaOfstring $chequeAccountNumber = null)
    {
        if (is_null($chequeAccountNumber) || (is_array($chequeAccountNumber) && empty($chequeAccountNumber))) {
            unset($this->ChequeAccountNumber);
        } else {
            $this->ChequeAccountNumber = $chequeAccountNumber;
        }
        return $this;
    }
    /**
     * Get ChequeBankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getChequeBankCode()
    {
        return isset($this->ChequeBankCode) ? $this->ChequeBankCode : null;
    }
    /**
     * Set ChequeBankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $chequeBankCode
     * @return \patest\StructType\PaymentCriteria
     */
    public function setChequeBankCode(\patest\StructType\SinglePropertyCriteriaOfstring $chequeBankCode = null)
    {
        if (is_null($chequeBankCode) || (is_array($chequeBankCode) && empty($chequeBankCode))) {
            unset($this->ChequeBankCode);
        } else {
            $this->ChequeBankCode = $chequeBankCode;
        }
        return $this;
    }
    /**
     * Get ChequeBranchCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getChequeBranchCode()
    {
        return isset($this->ChequeBranchCode) ? $this->ChequeBranchCode : null;
    }
    /**
     * Set ChequeBranchCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $chequeBranchCode
     * @return \patest\StructType\PaymentCriteria
     */
    public function setChequeBranchCode(\patest\StructType\SinglePropertyCriteriaOfstring $chequeBranchCode = null)
    {
        if (is_null($chequeBranchCode) || (is_array($chequeBranchCode) && empty($chequeBranchCode))) {
            unset($this->ChequeBranchCode);
        } else {
            $this->ChequeBranchCode = $chequeBranchCode;
        }
        return $this;
    }
    /**
     * Get ChequeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getChequeNumber()
    {
        return isset($this->ChequeNumber) ? $this->ChequeNumber : null;
    }
    /**
     * Set ChequeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $chequeNumber
     * @return \patest\StructType\PaymentCriteria
     */
    public function setChequeNumber(\patest\StructType\SinglePropertyCriteriaOfstring $chequeNumber = null)
    {
        if (is_null($chequeNumber) || (is_array($chequeNumber) && empty($chequeNumber))) {
            unset($this->ChequeNumber);
        } else {
            $this->ChequeNumber = $chequeNumber;
        }
        return $this;
    }
    /**
     * Get CouponDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfguid|null
     */
    public function getCouponDefinitionId()
    {
        return isset($this->CouponDefinitionId) ? $this->CouponDefinitionId : null;
    }
    /**
     * Set CouponDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $couponDefinitionId
     * @return \patest\StructType\PaymentCriteria
     */
    public function setCouponDefinitionId(\patest\StructType\SinglePropertyCriteriaOfguid $couponDefinitionId = null)
    {
        if (is_null($couponDefinitionId) || (is_array($couponDefinitionId) && empty($couponDefinitionId))) {
            unset($this->CouponDefinitionId);
        } else {
            $this->CouponDefinitionId = $couponDefinitionId;
        }
        return $this;
    }
    /**
     * Get CouponOrVoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getCouponOrVoucherNumber()
    {
        return isset($this->CouponOrVoucherNumber) ? $this->CouponOrVoucherNumber : null;
    }
    /**
     * Set CouponOrVoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $couponOrVoucherNumber
     * @return \patest\StructType\PaymentCriteria
     */
    public function setCouponOrVoucherNumber(\patest\StructType\SinglePropertyCriteriaOfstring $couponOrVoucherNumber = null)
    {
        if (is_null($couponOrVoucherNumber) || (is_array($couponOrVoucherNumber) && empty($couponOrVoucherNumber))) {
            unset($this->CouponOrVoucherNumber);
        } else {
            $this->CouponOrVoucherNumber = $couponOrVoucherNumber;
        }
        return $this;
    }
    /**
     * Get DirectDebitBankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getDirectDebitBankCode()
    {
        return isset($this->DirectDebitBankCode) ? $this->DirectDebitBankCode : null;
    }
    /**
     * Set DirectDebitBankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $directDebitBankCode
     * @return \patest\StructType\PaymentCriteria
     */
    public function setDirectDebitBankCode(\patest\StructType\SinglePropertyCriteriaOfstring $directDebitBankCode = null)
    {
        if (is_null($directDebitBankCode) || (is_array($directDebitBankCode) && empty($directDebitBankCode))) {
            unset($this->DirectDebitBankCode);
        } else {
            $this->DirectDebitBankCode = $directDebitBankCode;
        }
        return $this;
    }
    /**
     * Get GiftCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getGiftCardNumber()
    {
        return isset($this->GiftCardNumber) ? $this->GiftCardNumber : null;
    }
    /**
     * Set GiftCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $giftCardNumber
     * @return \patest\StructType\PaymentCriteria
     */
    public function setGiftCardNumber(\patest\StructType\SinglePropertyCriteriaOfstring $giftCardNumber = null)
    {
        if (is_null($giftCardNumber) || (is_array($giftCardNumber) && empty($giftCardNumber))) {
            unset($this->GiftCardNumber);
        } else {
            $this->GiftCardNumber = $giftCardNumber;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfguid|null
     */
    public function getGiftVoucherDefinitionId()
    {
        return isset($this->GiftVoucherDefinitionId) ? $this->GiftVoucherDefinitionId : null;
    }
    /**
     * Set GiftVoucherDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $giftVoucherDefinitionId
     * @return \patest\StructType\PaymentCriteria
     */
    public function setGiftVoucherDefinitionId(\patest\StructType\SinglePropertyCriteriaOfguid $giftVoucherDefinitionId = null)
    {
        if (is_null($giftVoucherDefinitionId) || (is_array($giftVoucherDefinitionId) && empty($giftVoucherDefinitionId))) {
            unset($this->GiftVoucherDefinitionId);
        } else {
            $this->GiftVoucherDefinitionId = $giftVoucherDefinitionId;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfint|null
     */
    public function getMandateNumber()
    {
        return isset($this->MandateNumber) ? $this->MandateNumber : null;
    }
    /**
     * Set MandateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfint $mandateNumber
     * @return \patest\StructType\PaymentCriteria
     */
    public function setMandateNumber(\patest\StructType\SinglePropertyCriteriaOfint $mandateNumber = null)
    {
        if (is_null($mandateNumber) || (is_array($mandateNumber) && empty($mandateNumber))) {
            unset($this->MandateNumber);
        } else {
            $this->MandateNumber = $mandateNumber;
        }
        return $this;
    }
    /**
     * Get MandateTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfguid|null
     */
    public function getMandateTypeId()
    {
        return isset($this->MandateTypeId) ? $this->MandateTypeId : null;
    }
    /**
     * Set MandateTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $mandateTypeId
     * @return \patest\StructType\PaymentCriteria
     */
    public function setMandateTypeId(\patest\StructType\SinglePropertyCriteriaOfguid $mandateTypeId = null)
    {
        if (is_null($mandateTypeId) || (is_array($mandateTypeId) && empty($mandateTypeId))) {
            unset($this->MandateTypeId);
        } else {
            $this->MandateTypeId = $mandateTypeId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfPaymentMethodType8Q8HnG_P7|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfPaymentMethodType8Q8HnG_P7 $paymentMethodType
     * @return \patest\StructType\PaymentCriteria
     */
    public function setPaymentMethodType(\patest\StructType\SinglePropertyCriteriaOfPaymentMethodType8Q8HnG_P7 $paymentMethodType = null)
    {
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get RefundCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfguid|null
     */
    public function getRefundCategoryId()
    {
        return isset($this->RefundCategoryId) ? $this->RefundCategoryId : null;
    }
    /**
     * Set RefundCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $refundCategoryId
     * @return \patest\StructType\PaymentCriteria
     */
    public function setRefundCategoryId(\patest\StructType\SinglePropertyCriteriaOfguid $refundCategoryId = null)
    {
        if (is_null($refundCategoryId) || (is_array($refundCategoryId) && empty($refundCategoryId))) {
            unset($this->RefundCategoryId);
        } else {
            $this->RefundCategoryId = $refundCategoryId;
        }
        return $this;
    }
    /**
     * Get CreditCardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getCreditCardSuffix()
    {
        return isset($this->CreditCardSuffix) ? $this->CreditCardSuffix : null;
    }
    /**
     * Set CreditCardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $creditCardSuffix
     * @return \patest\StructType\PaymentCriteria
     */
    public function setCreditCardSuffix(\patest\StructType\SinglePropertyCriteriaOfstring $creditCardSuffix = null)
    {
        if (is_null($creditCardSuffix) || (is_array($creditCardSuffix) && empty($creditCardSuffix))) {
            unset($this->CreditCardSuffix);
        } else {
            $this->CreditCardSuffix = $creditCardSuffix;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfguid|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $paymentMethodId
     * @return \patest\StructType\PaymentCriteria
     */
    public function setPaymentMethodId(\patest\StructType\SinglePropertyCriteriaOfguid $paymentMethodId = null)
    {
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get CouponDefinitionIdList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getCouponDefinitionIdList()
    {
        return isset($this->CouponDefinitionIdList) ? $this->CouponDefinitionIdList : null;
    }
    /**
     * Set CouponDefinitionIdList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $couponDefinitionIdList
     * @return \patest\StructType\PaymentCriteria
     */
    public function setCouponDefinitionIdList(\patest\StructType\SinglePropertyCriteriaOfstring $couponDefinitionIdList = null)
    {
        if (is_null($couponDefinitionIdList) || (is_array($couponDefinitionIdList) && empty($couponDefinitionIdList))) {
            unset($this->CouponDefinitionIdList);
        } else {
            $this->CouponDefinitionIdList = $couponDefinitionIdList;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinitionList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getGiftVoucherDefinitionList()
    {
        return isset($this->GiftVoucherDefinitionList) ? $this->GiftVoucherDefinitionList : null;
    }
    /**
     * Set GiftVoucherDefinitionList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $giftVoucherDefinitionList
     * @return \patest\StructType\PaymentCriteria
     */
    public function setGiftVoucherDefinitionList(\patest\StructType\SinglePropertyCriteriaOfstring $giftVoucherDefinitionList = null)
    {
        if (is_null($giftVoucherDefinitionList) || (is_array($giftVoucherDefinitionList) && empty($giftVoucherDefinitionList))) {
            unset($this->GiftVoucherDefinitionList);
        } else {
            $this->GiftVoucherDefinitionList = $giftVoucherDefinitionList;
        }
        return $this;
    }
    /**
     * Get GiftVoucherTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfguid|null
     */
    public function getGiftVoucherTypeId()
    {
        return isset($this->GiftVoucherTypeId) ? $this->GiftVoucherTypeId : null;
    }
    /**
     * Set GiftVoucherTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfguid $giftVoucherTypeId
     * @return \patest\StructType\PaymentCriteria
     */
    public function setGiftVoucherTypeId(\patest\StructType\SinglePropertyCriteriaOfguid $giftVoucherTypeId = null)
    {
        if (is_null($giftVoucherTypeId) || (is_array($giftVoucherTypeId) && empty($giftVoucherTypeId))) {
            unset($this->GiftVoucherTypeId);
        } else {
            $this->GiftVoucherTypeId = $giftVoucherTypeId;
        }
        return $this;
    }
    /**
     * Get RefundCategoryIdList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SinglePropertyCriteriaOfstring|null
     */
    public function getRefundCategoryIdList()
    {
        return isset($this->RefundCategoryIdList) ? $this->RefundCategoryIdList : null;
    }
    /**
     * Set RefundCategoryIdList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SinglePropertyCriteriaOfstring $refundCategoryIdList
     * @return \patest\StructType\PaymentCriteria
     */
    public function setRefundCategoryIdList(\patest\StructType\SinglePropertyCriteriaOfstring $refundCategoryIdList = null)
    {
        if (is_null($refundCategoryIdList) || (is_array($refundCategoryIdList) && empty($refundCategoryIdList))) {
            unset($this->RefundCategoryIdList);
        } else {
            $this->RefundCategoryIdList = $refundCategoryIdList;
        }
        return $this;
    }
}
