<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParameterInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ParameterInfo
 * @subpackage Structs
 */
class ParameterInfo extends AbstractStructBase
{
    /**
     * The HasValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasValue;
    /**
     * The KeyValue
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $KeyValue;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NodeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NodeType;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Owner;
    /**
     * Constructor method for ParameterInfo
     * @uses ParameterInfo::setHasValue()
     * @uses ParameterInfo::setKeyValue()
     * @uses ParameterInfo::setName()
     * @uses ParameterInfo::setNodeType()
     * @uses ParameterInfo::setValue()
     * @uses ParameterInfo::setOwner()
     * @param bool $hasValue
     * @param string $keyValue
     * @param string $name
     * @param string $nodeType
     * @param string $value
     * @param string $owner
     */
    public function __construct($hasValue = null, $keyValue = null, $name = null, $nodeType = null, $value = null, $owner = null)
    {
        $this
            ->setHasValue($hasValue)
            ->setKeyValue($keyValue)
            ->setName($name)
            ->setNodeType($nodeType)
            ->setValue($value)
            ->setOwner($owner);
    }
    /**
     * Get HasValue value
     * @return bool|null
     */
    public function getHasValue()
    {
        return $this->HasValue;
    }
    /**
     * Set HasValue value
     * @param bool $hasValue
     * @return \patest\StructType\ParameterInfo
     */
    public function setHasValue($hasValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasValue) && !is_bool($hasValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasValue, true), gettype($hasValue)), __LINE__);
        }
        $this->HasValue = $hasValue;
        return $this;
    }
    /**
     * Get KeyValue value
     * @return string|null
     */
    public function getKeyValue()
    {
        return $this->KeyValue;
    }
    /**
     * Set KeyValue value
     * @param string $keyValue
     * @return \patest\StructType\ParameterInfo
     */
    public function setKeyValue($keyValue = null)
    {
        // validation for constraint: string
        if (!is_null($keyValue) && !is_string($keyValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyValue, true), gettype($keyValue)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($keyValue) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $keyValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($keyValue, true)), __LINE__);
        }
        $this->KeyValue = $keyValue;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\ParameterInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NodeType value
     * @return string|null
     */
    public function getNodeType()
    {
        return $this->NodeType;
    }
    /**
     * Set NodeType value
     * @uses \patest\EnumType\ParameterNodeType::valueIsValid()
     * @uses \patest\EnumType\ParameterNodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nodeType
     * @return \patest\StructType\ParameterInfo
     */
    public function setNodeType($nodeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ParameterNodeType::valueIsValid($nodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ParameterNodeType', is_array($nodeType) ? implode(', ', $nodeType) : var_export($nodeType, true), implode(', ', \patest\EnumType\ParameterNodeType::getValidValues())), __LINE__);
        }
        $this->NodeType = $nodeType;
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \patest\StructType\ParameterInfo
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $owner
     * @return \patest\StructType\ParameterInfo
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($owner, true), gettype($owner)), __LINE__);
        }
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
}
