<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverridableTicketItemSpecificProperties StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OverridableTicketItemSpecificProperties
 * @subpackage Structs
 */
class OverridableTicketItemSpecificProperties extends AbstractStructBase
{
    /**
     * The AffectProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AffectProperties;
    /**
     * The CompensationOfTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CompensationOfTicketId;
    /**
     * The ForcedAllocationTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ForcedAllocationTypeId;
    /**
     * The IsReplaceableInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReplaceableInSubscription;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The ReturnAgainstSubscriptionBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ReturnAgainstSubscriptionBalance;
    /**
     * The SubscriberTicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriberTicketType;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The PrintMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintMethod;
    /**
     * The PrintMethodData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintMethodData;
    /**
     * The TurnbackDonationProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TurnbackDonationProductId;
    /**
     * Constructor method for OverridableTicketItemSpecificProperties
     * @uses OverridableTicketItemSpecificProperties::setAffectProperties()
     * @uses OverridableTicketItemSpecificProperties::setCompensationOfTicketId()
     * @uses OverridableTicketItemSpecificProperties::setForcedAllocationTypeId()
     * @uses OverridableTicketItemSpecificProperties::setIsReplaceableInSubscription()
     * @uses OverridableTicketItemSpecificProperties::setItemId()
     * @uses OverridableTicketItemSpecificProperties::setReturnAgainstSubscriptionBalance()
     * @uses OverridableTicketItemSpecificProperties::setSubscriberTicketType()
     * @uses OverridableTicketItemSpecificProperties::setSubscriptionInstanceId()
     * @uses OverridableTicketItemSpecificProperties::setPrintMethod()
     * @uses OverridableTicketItemSpecificProperties::setPrintMethodData()
     * @uses OverridableTicketItemSpecificProperties::setTurnbackDonationProductId()
     * @param string[] $affectProperties
     * @param string $compensationOfTicketId
     * @param string $forcedAllocationTypeId
     * @param bool $isReplaceableInSubscription
     * @param int $itemId
     * @param bool $returnAgainstSubscriptionBalance
     * @param string $subscriberTicketType
     * @param string $subscriptionInstanceId
     * @param string $printMethod
     * @param string $printMethodData
     * @param string $turnbackDonationProductId
     */
    public function __construct(array $affectProperties = array(), $compensationOfTicketId = null, $forcedAllocationTypeId = null, $isReplaceableInSubscription = null, $itemId = null, $returnAgainstSubscriptionBalance = null, $subscriberTicketType = null, $subscriptionInstanceId = null, $printMethod = null, $printMethodData = null, $turnbackDonationProductId = null)
    {
        $this
            ->setAffectProperties($affectProperties)
            ->setCompensationOfTicketId($compensationOfTicketId)
            ->setForcedAllocationTypeId($forcedAllocationTypeId)
            ->setIsReplaceableInSubscription($isReplaceableInSubscription)
            ->setItemId($itemId)
            ->setReturnAgainstSubscriptionBalance($returnAgainstSubscriptionBalance)
            ->setSubscriberTicketType($subscriberTicketType)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setPrintMethod($printMethod)
            ->setPrintMethodData($printMethodData)
            ->setTurnbackDonationProductId($turnbackDonationProductId);
    }
    /**
     * Get AffectProperties value
     * @return string[]|null
     */
    public function getAffectProperties()
    {
        return $this->AffectProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setAffectProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffectProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffectPropertiesForArrayConstraintsFromSetAffectProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $overridableTicketItemSpecificPropertiesAffectPropertiesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OverridableTicketItemProperties::valueIsValid($overridableTicketItemSpecificPropertiesAffectPropertiesItem)) {
                $invalidValues[] = is_object($overridableTicketItemSpecificPropertiesAffectPropertiesItem) ? get_class($overridableTicketItemSpecificPropertiesAffectPropertiesItem) : sprintf('%s(%s)', gettype($overridableTicketItemSpecificPropertiesAffectPropertiesItem), var_export($overridableTicketItemSpecificPropertiesAffectPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OverridableTicketItemProperties', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OverridableTicketItemProperties::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffectProperties value
     * @uses \patest\EnumType\OverridableTicketItemProperties::valueIsValid()
     * @uses \patest\EnumType\OverridableTicketItemProperties::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $affectProperties
     * @return \patest\StructType\OverridableTicketItemSpecificProperties
     */
    public function setAffectProperties(array $affectProperties = array())
    {
        // validation for constraint: list
        if ('' !== ($affectPropertiesArrayErrorMessage = self::validateAffectPropertiesForArrayConstraintsFromSetAffectProperties($affectProperties))) {
            throw new \InvalidArgumentException($affectPropertiesArrayErrorMessage, __LINE__);
        }
        $this->AffectProperties = is_array($affectProperties) ? implode(' ', $affectProperties) : null;
        return $this;
    }
    /**
     * Get CompensationOfTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompensationOfTicketId()
    {
        return isset($this->CompensationOfTicketId) ? $this->CompensationOfTicketId : null;
    }
    /**
     * Set CompensationOfTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $compensationOfTicketId
     * @return \patest\StructType\OverridableTicketItemSpecificProperties
     */
    public function setCompensationOfTicketId($compensationOfTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($compensationOfTicketId) && !is_string($compensationOfTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compensationOfTicketId, true), gettype($compensationOfTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($compensationOfTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $compensationOfTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($compensationOfTicketId, true)), __LINE__);
        }
        if (is_null($compensationOfTicketId) || (is_array($compensationOfTicketId) && empty($compensationOfTicketId))) {
            unset($this->CompensationOfTicketId);
        } else {
            $this->CompensationOfTicketId = $compensationOfTicketId;
        }
        return $this;
    }
    /**
     * Get ForcedAllocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForcedAllocationTypeId()
    {
        return isset($this->ForcedAllocationTypeId) ? $this->ForcedAllocationTypeId : null;
    }
    /**
     * Set ForcedAllocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forcedAllocationTypeId
     * @return \patest\StructType\OverridableTicketItemSpecificProperties
     */
    public function setForcedAllocationTypeId($forcedAllocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($forcedAllocationTypeId) && !is_string($forcedAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forcedAllocationTypeId, true), gettype($forcedAllocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($forcedAllocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $forcedAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($forcedAllocationTypeId, true)), __LINE__);
        }
        if (is_null($forcedAllocationTypeId) || (is_array($forcedAllocationTypeId) && empty($forcedAllocationTypeId))) {
            unset($this->ForcedAllocationTypeId);
        } else {
            $this->ForcedAllocationTypeId = $forcedAllocationTypeId;
        }
        return $this;
    }
    /**
     * Get IsReplaceableInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReplaceableInSubscription()
    {
        return isset($this->IsReplaceableInSubscription) ? $this->IsReplaceableInSubscription : null;
    }
    /**
     * Set IsReplaceableInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReplaceableInSubscription
     * @return \patest\StructType\OverridableTicketItemSpecificProperties
     */
    public function setIsReplaceableInSubscription($isReplaceableInSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReplaceableInSubscription) && !is_bool($isReplaceableInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReplaceableInSubscription, true), gettype($isReplaceableInSubscription)), __LINE__);
        }
        if (is_null($isReplaceableInSubscription) || (is_array($isReplaceableInSubscription) && empty($isReplaceableInSubscription))) {
            unset($this->IsReplaceableInSubscription);
        } else {
            $this->IsReplaceableInSubscription = $isReplaceableInSubscription;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\OverridableTicketItemSpecificProperties
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get ReturnAgainstSubscriptionBalance value
     * @return bool|null
     */
    public function getReturnAgainstSubscriptionBalance()
    {
        return $this->ReturnAgainstSubscriptionBalance;
    }
    /**
     * Set ReturnAgainstSubscriptionBalance value
     * @param bool $returnAgainstSubscriptionBalance
     * @return \patest\StructType\OverridableTicketItemSpecificProperties
     */
    public function setReturnAgainstSubscriptionBalance($returnAgainstSubscriptionBalance = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnAgainstSubscriptionBalance) && !is_bool($returnAgainstSubscriptionBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnAgainstSubscriptionBalance, true), gettype($returnAgainstSubscriptionBalance)), __LINE__);
        }
        $this->ReturnAgainstSubscriptionBalance = $returnAgainstSubscriptionBalance;
        return $this;
    }
    /**
     * Get SubscriberTicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberTicketType()
    {
        return isset($this->SubscriberTicketType) ? $this->SubscriberTicketType : null;
    }
    /**
     * Set SubscriberTicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberTicketType::valueIsValid()
     * @uses \patest\EnumType\SubscriberTicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberTicketType
     * @return \patest\StructType\OverridableTicketItemSpecificProperties
     */
    public function setSubscriberTicketType($subscriberTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberTicketType::valueIsValid($subscriberTicketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberTicketType', is_array($subscriberTicketType) ? implode(', ', $subscriberTicketType) : var_export($subscriberTicketType, true), implode(', ', \patest\EnumType\SubscriberTicketType::getValidValues())), __LINE__);
        }
        if (is_null($subscriberTicketType) || (is_array($subscriberTicketType) && empty($subscriberTicketType))) {
            unset($this->SubscriberTicketType);
        } else {
            $this->SubscriberTicketType = $subscriberTicketType;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\OverridableTicketItemSpecificProperties
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get PrintMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintMethod()
    {
        return isset($this->PrintMethod) ? $this->PrintMethod : null;
    }
    /**
     * Set PrintMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printMethod
     * @return \patest\StructType\OverridableTicketItemSpecificProperties
     */
    public function setPrintMethod($printMethod = null)
    {
        // validation for constraint: string
        if (!is_null($printMethod) && !is_string($printMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printMethod, true), gettype($printMethod)), __LINE__);
        }
        if (is_null($printMethod) || (is_array($printMethod) && empty($printMethod))) {
            unset($this->PrintMethod);
        } else {
            $this->PrintMethod = $printMethod;
        }
        return $this;
    }
    /**
     * Get PrintMethodData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintMethodData()
    {
        return isset($this->PrintMethodData) ? $this->PrintMethodData : null;
    }
    /**
     * Set PrintMethodData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printMethodData
     * @return \patest\StructType\OverridableTicketItemSpecificProperties
     */
    public function setPrintMethodData($printMethodData = null)
    {
        // validation for constraint: string
        if (!is_null($printMethodData) && !is_string($printMethodData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printMethodData, true), gettype($printMethodData)), __LINE__);
        }
        if (is_null($printMethodData) || (is_array($printMethodData) && empty($printMethodData))) {
            unset($this->PrintMethodData);
        } else {
            $this->PrintMethodData = $printMethodData;
        }
        return $this;
    }
    /**
     * Get TurnbackDonationProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnbackDonationProductId()
    {
        return isset($this->TurnbackDonationProductId) ? $this->TurnbackDonationProductId : null;
    }
    /**
     * Set TurnbackDonationProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnbackDonationProductId
     * @return \patest\StructType\OverridableTicketItemSpecificProperties
     */
    public function setTurnbackDonationProductId($turnbackDonationProductId = null)
    {
        // validation for constraint: string
        if (!is_null($turnbackDonationProductId) && !is_string($turnbackDonationProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnbackDonationProductId, true), gettype($turnbackDonationProductId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($turnbackDonationProductId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $turnbackDonationProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($turnbackDonationProductId, true)), __LINE__);
        }
        if (is_null($turnbackDonationProductId) || (is_array($turnbackDonationProductId) && empty($turnbackDonationProductId))) {
            unset($this->TurnbackDonationProductId);
        } else {
            $this->TurnbackDonationProductId = $turnbackDonationProductId;
        }
        return $this;
    }
}
