<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverridableExistingTicketProperty StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OverridableExistingTicketProperty
 * @subpackage Structs
 */
class OverridableExistingTicketProperty extends AbstractStructBase
{
    /**
     * The AffectProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AffectProperties;
    /**
     * The ItemIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ServiceSpecificItemIdentity
     */
    public $ItemIdentity;
    /**
     * The NewOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewOwnerId;
    /**
     * The NewPriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceType;
    /**
     * Constructor method for OverridableExistingTicketProperty
     * @uses OverridableExistingTicketProperty::setAffectProperties()
     * @uses OverridableExistingTicketProperty::setItemIdentity()
     * @uses OverridableExistingTicketProperty::setNewOwnerId()
     * @uses OverridableExistingTicketProperty::setNewPriceType()
     * @param string[] $affectProperties
     * @param \patest\StructType\ServiceSpecificItemIdentity $itemIdentity
     * @param string $newOwnerId
     * @param string $newPriceType
     */
    public function __construct(array $affectProperties = array(), \patest\StructType\ServiceSpecificItemIdentity $itemIdentity = null, $newOwnerId = null, $newPriceType = null)
    {
        $this
            ->setAffectProperties($affectProperties)
            ->setItemIdentity($itemIdentity)
            ->setNewOwnerId($newOwnerId)
            ->setNewPriceType($newPriceType);
    }
    /**
     * Get AffectProperties value
     * @return string[]|null
     */
    public function getAffectProperties()
    {
        return $this->AffectProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setAffectProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffectProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffectPropertiesForArrayConstraintsFromSetAffectProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $overridableExistingTicketPropertyAffectPropertiesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OverridableExistingTicketProperties::valueIsValid($overridableExistingTicketPropertyAffectPropertiesItem)) {
                $invalidValues[] = is_object($overridableExistingTicketPropertyAffectPropertiesItem) ? get_class($overridableExistingTicketPropertyAffectPropertiesItem) : sprintf('%s(%s)', gettype($overridableExistingTicketPropertyAffectPropertiesItem), var_export($overridableExistingTicketPropertyAffectPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OverridableExistingTicketProperties', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OverridableExistingTicketProperties::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffectProperties value
     * @uses \patest\EnumType\OverridableExistingTicketProperties::valueIsValid()
     * @uses \patest\EnumType\OverridableExistingTicketProperties::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $affectProperties
     * @return \patest\StructType\OverridableExistingTicketProperty
     */
    public function setAffectProperties(array $affectProperties = array())
    {
        // validation for constraint: list
        if ('' !== ($affectPropertiesArrayErrorMessage = self::validateAffectPropertiesForArrayConstraintsFromSetAffectProperties($affectProperties))) {
            throw new \InvalidArgumentException($affectPropertiesArrayErrorMessage, __LINE__);
        }
        $this->AffectProperties = is_array($affectProperties) ? implode(' ', $affectProperties) : null;
        return $this;
    }
    /**
     * Get ItemIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ServiceSpecificItemIdentity|null
     */
    public function getItemIdentity()
    {
        return isset($this->ItemIdentity) ? $this->ItemIdentity : null;
    }
    /**
     * Set ItemIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ServiceSpecificItemIdentity $itemIdentity
     * @return \patest\StructType\OverridableExistingTicketProperty
     */
    public function setItemIdentity(\patest\StructType\ServiceSpecificItemIdentity $itemIdentity = null)
    {
        if (is_null($itemIdentity) || (is_array($itemIdentity) && empty($itemIdentity))) {
            unset($this->ItemIdentity);
        } else {
            $this->ItemIdentity = $itemIdentity;
        }
        return $this;
    }
    /**
     * Get NewOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewOwnerId()
    {
        return isset($this->NewOwnerId) ? $this->NewOwnerId : null;
    }
    /**
     * Set NewOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newOwnerId
     * @return \patest\StructType\OverridableExistingTicketProperty
     */
    public function setNewOwnerId($newOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($newOwnerId) && !is_string($newOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOwnerId, true), gettype($newOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newOwnerId, true)), __LINE__);
        }
        if (is_null($newOwnerId) || (is_array($newOwnerId) && empty($newOwnerId))) {
            unset($this->NewOwnerId);
        } else {
            $this->NewOwnerId = $newOwnerId;
        }
        return $this;
    }
    /**
     * Get NewPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceType()
    {
        return isset($this->NewPriceType) ? $this->NewPriceType : null;
    }
    /**
     * Set NewPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceType
     * @return \patest\StructType\OverridableExistingTicketProperty
     */
    public function setNewPriceType($newPriceType = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceType) && !is_string($newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceType, true), gettype($newPriceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceType, true)), __LINE__);
        }
        if (is_null($newPriceType) || (is_array($newPriceType) && empty($newPriceType))) {
            unset($this->NewPriceType);
        } else {
            $this->NewPriceType = $newPriceType;
        }
        return $this;
    }
}
