<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverridableDonationItemProperties StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OverridableDonationItemProperties
 * @subpackage Structs
 */
class OverridableDonationItemProperties extends AbstractStructBase
{
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The ChannelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChannelId;
    /**
     * The DonationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationDate;
    /**
     * The DonationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DonationId;
    /**
     * The FundId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FundId;
    /**
     * The GenerateTaxStatement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GenerateTaxStatement;
    /**
     * The GenerateThankYouLetter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GenerateThankYouLetter;
    /**
     * The GiftDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftDescription;
    /**
     * The IsAnonymous
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAnonymous;
    /**
     * The IsPrintSpecialClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrintSpecialClientName;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The NameOnDonation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $NameOnDonation;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notification;
    /**
     * The PersonToTribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonToTribute;
    /**
     * The SoftCreditDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSoftCreditDetail
     */
    public $SoftCreditDetails;
    /**
     * The ThankYouLetterSpecialMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThankYouLetterSpecialMessage;
    /**
     * The TributeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeType;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * Constructor method for OverridableDonationItemProperties
     * @uses OverridableDonationItemProperties::setAppealId()
     * @uses OverridableDonationItemProperties::setCampaignId()
     * @uses OverridableDonationItemProperties::setChannelId()
     * @uses OverridableDonationItemProperties::setDonationDate()
     * @uses OverridableDonationItemProperties::setDonationId()
     * @uses OverridableDonationItemProperties::setFundId()
     * @uses OverridableDonationItemProperties::setGenerateTaxStatement()
     * @uses OverridableDonationItemProperties::setGenerateThankYouLetter()
     * @uses OverridableDonationItemProperties::setGiftDescription()
     * @uses OverridableDonationItemProperties::setIsAnonymous()
     * @uses OverridableDonationItemProperties::setIsPrintSpecialClientName()
     * @uses OverridableDonationItemProperties::setItemId()
     * @uses OverridableDonationItemProperties::setMessage()
     * @uses OverridableDonationItemProperties::setNameOnDonation()
     * @uses OverridableDonationItemProperties::setNotification()
     * @uses OverridableDonationItemProperties::setPersonToTribute()
     * @uses OverridableDonationItemProperties::setSoftCreditDetails()
     * @uses OverridableDonationItemProperties::setThankYouLetterSpecialMessage()
     * @uses OverridableDonationItemProperties::setTributeType()
     * @uses OverridableDonationItemProperties::setValue()
     * @param string $appealId
     * @param string $campaignId
     * @param string $channelId
     * @param string $donationDate
     * @param string $donationId
     * @param string $fundId
     * @param bool $generateTaxStatement
     * @param bool $generateThankYouLetter
     * @param string $giftDescription
     * @param bool $isAnonymous
     * @param bool $isPrintSpecialClientName
     * @param int $itemId
     * @param string $message
     * @param \patest\StructType\GlobalString $nameOnDonation
     * @param string $notification
     * @param string $personToTribute
     * @param \patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails
     * @param string $thankYouLetterSpecialMessage
     * @param string $tributeType
     * @param float $value
     */
    public function __construct($appealId = null, $campaignId = null, $channelId = null, $donationDate = null, $donationId = null, $fundId = null, $generateTaxStatement = null, $generateThankYouLetter = null, $giftDescription = null, $isAnonymous = null, $isPrintSpecialClientName = null, $itemId = null, $message = null, \patest\StructType\GlobalString $nameOnDonation = null, $notification = null, $personToTribute = null, \patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails = null, $thankYouLetterSpecialMessage = null, $tributeType = null, $value = null)
    {
        $this
            ->setAppealId($appealId)
            ->setCampaignId($campaignId)
            ->setChannelId($channelId)
            ->setDonationDate($donationDate)
            ->setDonationId($donationId)
            ->setFundId($fundId)
            ->setGenerateTaxStatement($generateTaxStatement)
            ->setGenerateThankYouLetter($generateThankYouLetter)
            ->setGiftDescription($giftDescription)
            ->setIsAnonymous($isAnonymous)
            ->setIsPrintSpecialClientName($isPrintSpecialClientName)
            ->setItemId($itemId)
            ->setMessage($message)
            ->setNameOnDonation($nameOnDonation)
            ->setNotification($notification)
            ->setPersonToTribute($personToTribute)
            ->setSoftCreditDetails($softCreditDetails)
            ->setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage)
            ->setTributeType($tributeType)
            ->setValue($value);
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get ChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannelId()
    {
        return isset($this->ChannelId) ? $this->ChannelId : null;
    }
    /**
     * Set ChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channelId
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setChannelId($channelId = null)
    {
        // validation for constraint: string
        if (!is_null($channelId) && !is_string($channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelId, true), gettype($channelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($channelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($channelId, true)), __LINE__);
        }
        if (is_null($channelId) || (is_array($channelId) && empty($channelId))) {
            unset($this->ChannelId);
        } else {
            $this->ChannelId = $channelId;
        }
        return $this;
    }
    /**
     * Get DonationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationDate()
    {
        return isset($this->DonationDate) ? $this->DonationDate : null;
    }
    /**
     * Set DonationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationDate
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setDonationDate($donationDate = null)
    {
        // validation for constraint: string
        if (!is_null($donationDate) && !is_string($donationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationDate, true), gettype($donationDate)), __LINE__);
        }
        if (is_null($donationDate) || (is_array($donationDate) && empty($donationDate))) {
            unset($this->DonationDate);
        } else {
            $this->DonationDate = $donationDate;
        }
        return $this;
    }
    /**
     * Get DonationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationId()
    {
        return isset($this->DonationId) ? $this->DonationId : null;
    }
    /**
     * Set DonationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationId
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setDonationId($donationId = null)
    {
        // validation for constraint: string
        if (!is_null($donationId) && !is_string($donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationId, true), gettype($donationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($donationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($donationId, true)), __LINE__);
        }
        if (is_null($donationId) || (is_array($donationId) && empty($donationId))) {
            unset($this->DonationId);
        } else {
            $this->DonationId = $donationId;
        }
        return $this;
    }
    /**
     * Get FundId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFundId()
    {
        return isset($this->FundId) ? $this->FundId : null;
    }
    /**
     * Set FundId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fundId
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setFundId($fundId = null)
    {
        // validation for constraint: string
        if (!is_null($fundId) && !is_string($fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundId, true), gettype($fundId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fundId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fundId, true)), __LINE__);
        }
        if (is_null($fundId) || (is_array($fundId) && empty($fundId))) {
            unset($this->FundId);
        } else {
            $this->FundId = $fundId;
        }
        return $this;
    }
    /**
     * Get GenerateTaxStatement value
     * @return bool|null
     */
    public function getGenerateTaxStatement()
    {
        return $this->GenerateTaxStatement;
    }
    /**
     * Set GenerateTaxStatement value
     * @param bool $generateTaxStatement
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setGenerateTaxStatement($generateTaxStatement = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateTaxStatement) && !is_bool($generateTaxStatement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateTaxStatement, true), gettype($generateTaxStatement)), __LINE__);
        }
        $this->GenerateTaxStatement = $generateTaxStatement;
        return $this;
    }
    /**
     * Get GenerateThankYouLetter value
     * @return bool|null
     */
    public function getGenerateThankYouLetter()
    {
        return $this->GenerateThankYouLetter;
    }
    /**
     * Set GenerateThankYouLetter value
     * @param bool $generateThankYouLetter
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setGenerateThankYouLetter($generateThankYouLetter = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateThankYouLetter) && !is_bool($generateThankYouLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateThankYouLetter, true), gettype($generateThankYouLetter)), __LINE__);
        }
        $this->GenerateThankYouLetter = $generateThankYouLetter;
        return $this;
    }
    /**
     * Get GiftDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftDescription()
    {
        return isset($this->GiftDescription) ? $this->GiftDescription : null;
    }
    /**
     * Set GiftDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftDescription
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setGiftDescription($giftDescription = null)
    {
        // validation for constraint: string
        if (!is_null($giftDescription) && !is_string($giftDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftDescription, true), gettype($giftDescription)), __LINE__);
        }
        if (is_null($giftDescription) || (is_array($giftDescription) && empty($giftDescription))) {
            unset($this->GiftDescription);
        } else {
            $this->GiftDescription = $giftDescription;
        }
        return $this;
    }
    /**
     * Get IsAnonymous value
     * @return bool|null
     */
    public function getIsAnonymous()
    {
        return $this->IsAnonymous;
    }
    /**
     * Set IsAnonymous value
     * @param bool $isAnonymous
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setIsAnonymous($isAnonymous = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAnonymous) && !is_bool($isAnonymous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAnonymous, true), gettype($isAnonymous)), __LINE__);
        }
        $this->IsAnonymous = $isAnonymous;
        return $this;
    }
    /**
     * Get IsPrintSpecialClientName value
     * @return bool|null
     */
    public function getIsPrintSpecialClientName()
    {
        return $this->IsPrintSpecialClientName;
    }
    /**
     * Set IsPrintSpecialClientName value
     * @param bool $isPrintSpecialClientName
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setIsPrintSpecialClientName($isPrintSpecialClientName = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrintSpecialClientName) && !is_bool($isPrintSpecialClientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrintSpecialClientName, true), gettype($isPrintSpecialClientName)), __LINE__);
        }
        $this->IsPrintSpecialClientName = $isPrintSpecialClientName;
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get NameOnDonation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNameOnDonation()
    {
        return isset($this->NameOnDonation) ? $this->NameOnDonation : null;
    }
    /**
     * Set NameOnDonation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $nameOnDonation
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setNameOnDonation(\patest\StructType\GlobalString $nameOnDonation = null)
    {
        if (is_null($nameOnDonation) || (is_array($nameOnDonation) && empty($nameOnDonation))) {
            unset($this->NameOnDonation);
        } else {
            $this->NameOnDonation = $nameOnDonation;
        }
        return $this;
    }
    /**
     * Get Notification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotification()
    {
        return isset($this->Notification) ? $this->Notification : null;
    }
    /**
     * Set Notification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notification
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setNotification($notification = null)
    {
        // validation for constraint: string
        if (!is_null($notification) && !is_string($notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notification, true), gettype($notification)), __LINE__);
        }
        if (is_null($notification) || (is_array($notification) && empty($notification))) {
            unset($this->Notification);
        } else {
            $this->Notification = $notification;
        }
        return $this;
    }
    /**
     * Get PersonToTribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonToTribute()
    {
        return isset($this->PersonToTribute) ? $this->PersonToTribute : null;
    }
    /**
     * Set PersonToTribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personToTribute
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setPersonToTribute($personToTribute = null)
    {
        // validation for constraint: string
        if (!is_null($personToTribute) && !is_string($personToTribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personToTribute, true), gettype($personToTribute)), __LINE__);
        }
        if (is_null($personToTribute) || (is_array($personToTribute) && empty($personToTribute))) {
            unset($this->PersonToTribute);
        } else {
            $this->PersonToTribute = $personToTribute;
        }
        return $this;
    }
    /**
     * Get SoftCreditDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSoftCreditDetail|null
     */
    public function getSoftCreditDetails()
    {
        return isset($this->SoftCreditDetails) ? $this->SoftCreditDetails : null;
    }
    /**
     * Set SoftCreditDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setSoftCreditDetails(\patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails = null)
    {
        if (is_null($softCreditDetails) || (is_array($softCreditDetails) && empty($softCreditDetails))) {
            unset($this->SoftCreditDetails);
        } else {
            $this->SoftCreditDetails = $softCreditDetails;
        }
        return $this;
    }
    /**
     * Get ThankYouLetterSpecialMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThankYouLetterSpecialMessage()
    {
        return isset($this->ThankYouLetterSpecialMessage) ? $this->ThankYouLetterSpecialMessage : null;
    }
    /**
     * Set ThankYouLetterSpecialMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thankYouLetterSpecialMessage
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage = null)
    {
        // validation for constraint: string
        if (!is_null($thankYouLetterSpecialMessage) && !is_string($thankYouLetterSpecialMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thankYouLetterSpecialMessage, true), gettype($thankYouLetterSpecialMessage)), __LINE__);
        }
        if (is_null($thankYouLetterSpecialMessage) || (is_array($thankYouLetterSpecialMessage) && empty($thankYouLetterSpecialMessage))) {
            unset($this->ThankYouLetterSpecialMessage);
        } else {
            $this->ThankYouLetterSpecialMessage = $thankYouLetterSpecialMessage;
        }
        return $this;
    }
    /**
     * Get TributeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeType()
    {
        return isset($this->TributeType) ? $this->TributeType : null;
    }
    /**
     * Set TributeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TributeType::valueIsValid()
     * @uses \patest\EnumType\TributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tributeType
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setTributeType($tributeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TributeType::valueIsValid($tributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TributeType', is_array($tributeType) ? implode(', ', $tributeType) : var_export($tributeType, true), implode(', ', \patest\EnumType\TributeType::getValidValues())), __LINE__);
        }
        if (is_null($tributeType) || (is_array($tributeType) && empty($tributeType))) {
            unset($this->TributeType);
        } else {
            $this->TributeType = $tributeType;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $value
     * @return \patest\StructType\OverridableDonationItemProperties
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
