<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotifyClientByEmail-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NotifyClientByEmail-Response
 * @subpackage Structs
 */
class NotifyClientByEmail_Response extends AbstractStructBase
{
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Error;
    /**
     * The OperationFaultCodeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationFaultCodeName;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Success;
    /**
     * Constructor method for NotifyClientByEmail-Response
     * @uses NotifyClientByEmail_Response::setEmail()
     * @uses NotifyClientByEmail_Response::setError()
     * @uses NotifyClientByEmail_Response::setOperationFaultCodeName()
     * @uses NotifyClientByEmail_Response::setSuccess()
     * @param string $email
     * @param string $error
     * @param string $operationFaultCodeName
     * @param bool $success
     */
    public function __construct($email = null, $error = null, $operationFaultCodeName = null, $success = null)
    {
        $this
            ->setEmail($email)
            ->setError($error)
            ->setOperationFaultCodeName($operationFaultCodeName)
            ->setSuccess($success);
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\NotifyClientByEmail_Response
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $error
     * @return \patest\StructType\NotifyClientByEmail_Response
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get OperationFaultCodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationFaultCodeName()
    {
        return isset($this->OperationFaultCodeName) ? $this->OperationFaultCodeName : null;
    }
    /**
     * Set OperationFaultCodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationFaultCodeName
     * @return \patest\StructType\NotifyClientByEmail_Response
     */
    public function setOperationFaultCodeName($operationFaultCodeName = null)
    {
        // validation for constraint: string
        if (!is_null($operationFaultCodeName) && !is_string($operationFaultCodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationFaultCodeName, true), gettype($operationFaultCodeName)), __LINE__);
        }
        if (is_null($operationFaultCodeName) || (is_array($operationFaultCodeName) && empty($operationFaultCodeName))) {
            unset($this->OperationFaultCodeName);
        } else {
            $this->OperationFaultCodeName = $operationFaultCodeName;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \patest\StructType\NotifyClientByEmail_Response
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
}
