<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonValidDelivery StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NonValidDelivery
 * @subpackage Structs
 */
class NonValidDelivery extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DeliveryDescription
     */
    public $Description;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReasonCode;
    /**
     * Constructor method for NonValidDelivery
     * @uses NonValidDelivery::setDescription()
     * @uses NonValidDelivery::setReasonCode()
     * @param \patest\StructType\DeliveryDescription $description
     * @param string $reasonCode
     */
    public function __construct(\patest\StructType\DeliveryDescription $description = null, $reasonCode = null)
    {
        $this
            ->setDescription($description)
            ->setReasonCode($reasonCode);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DeliveryDescription|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DeliveryDescription $description
     * @return \patest\StructType\NonValidDelivery
     */
    public function setDescription(\patest\StructType\DeliveryDescription $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonCode
     * @return \patest\StructType\NonValidDelivery
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
}
