<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewHospitalityTicketsRequestDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NewHospitalityTicketsRequestDetails
 * @subpackage Structs
 */
class NewHospitalityTicketsRequestDetails extends HospitalityTicketsRequestDetailsBase
{
    /**
     * The EffectiveAvailabilityFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterIdentification
     */
    public $EffectiveAvailabilityFilter;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The SeatsToCatch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCatchSeatRequest
     */
    public $SeatsToCatch;
    /**
     * Constructor method for NewHospitalityTicketsRequestDetails
     * @uses NewHospitalityTicketsRequestDetails::setEffectiveAvailabilityFilter()
     * @uses NewHospitalityTicketsRequestDetails::setEventId()
     * @uses NewHospitalityTicketsRequestDetails::setSeatsToCatch()
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @param string $eventId
     * @param \patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch
     */
    public function __construct(\patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null, $eventId = null, \patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch = null)
    {
        $this
            ->setEffectiveAvailabilityFilter($effectiveAvailabilityFilter)
            ->setEventId($eventId)
            ->setSeatsToCatch($seatsToCatch);
    }
    /**
     * Get EffectiveAvailabilityFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterIdentification|null
     */
    public function getEffectiveAvailabilityFilter()
    {
        return isset($this->EffectiveAvailabilityFilter) ? $this->EffectiveAvailabilityFilter : null;
    }
    /**
     * Set EffectiveAvailabilityFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @return \patest\StructType\NewHospitalityTicketsRequestDetails
     */
    public function setEffectiveAvailabilityFilter(\patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null)
    {
        if (is_null($effectiveAvailabilityFilter) || (is_array($effectiveAvailabilityFilter) && empty($effectiveAvailabilityFilter))) {
            unset($this->EffectiveAvailabilityFilter);
        } else {
            $this->EffectiveAvailabilityFilter = $effectiveAvailabilityFilter;
        }
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\NewHospitalityTicketsRequestDetails
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get SeatsToCatch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCatchSeatRequest|null
     */
    public function getSeatsToCatch()
    {
        return isset($this->SeatsToCatch) ? $this->SeatsToCatch : null;
    }
    /**
     * Set SeatsToCatch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch
     * @return \patest\StructType\NewHospitalityTicketsRequestDetails
     */
    public function setSeatsToCatch(\patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch = null)
    {
        if (is_null($seatsToCatch) || (is_array($seatsToCatch) && empty($seatsToCatch))) {
            unset($this->SeatsToCatch);
        } else {
            $this->SeatsToCatch = $seatsToCatch;
        }
        return $this;
    }
}
