<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoveSubscriptionReservedSeatSelectionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MoveSubscriptionReservedSeatSelectionRequest
 * @subpackage Structs
 */
class MoveSubscriptionReservedSeatSelectionRequest extends ExtensibleDataContract
{
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Direction;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Distance;
    /**
     * The IsMoveRelatedEventTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMoveRelatedEventTickets;
    /**
     * The ItemIdsToMove
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $ItemIdsToMove;
    /**
     * The StartingDestinationSeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StartingDestinationSeatId;
    /**
     * The TargetAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetAreaId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The IsFailOnSeatUnavailableAtAnyEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFailOnSeatUnavailableAtAnyEvent;
    /**
     * Constructor method for MoveSubscriptionReservedSeatSelectionRequest
     * @uses MoveSubscriptionReservedSeatSelectionRequest::setDirection()
     * @uses MoveSubscriptionReservedSeatSelectionRequest::setDistance()
     * @uses MoveSubscriptionReservedSeatSelectionRequest::setIsMoveRelatedEventTickets()
     * @uses MoveSubscriptionReservedSeatSelectionRequest::setItemIdsToMove()
     * @uses MoveSubscriptionReservedSeatSelectionRequest::setStartingDestinationSeatId()
     * @uses MoveSubscriptionReservedSeatSelectionRequest::setTargetAreaId()
     * @uses MoveSubscriptionReservedSeatSelectionRequest::setTransactionGuid()
     * @uses MoveSubscriptionReservedSeatSelectionRequest::setTransactionSnapshotType()
     * @uses MoveSubscriptionReservedSeatSelectionRequest::setIsFailOnSeatUnavailableAtAnyEvent()
     * @param string $direction
     * @param int $distance
     * @param bool $isMoveRelatedEventTickets
     * @param \patest\ArrayType\ArrayOfint $itemIdsToMove
     * @param int $startingDestinationSeatId
     * @param string $targetAreaId
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param bool $isFailOnSeatUnavailableAtAnyEvent
     */
    public function __construct($direction = null, $distance = null, $isMoveRelatedEventTickets = null, \patest\ArrayType\ArrayOfint $itemIdsToMove = null, $startingDestinationSeatId = null, $targetAreaId = null, $transactionGuid = null, $transactionSnapshotType = null, $isFailOnSeatUnavailableAtAnyEvent = null)
    {
        $this
            ->setDirection($direction)
            ->setDistance($distance)
            ->setIsMoveRelatedEventTickets($isMoveRelatedEventTickets)
            ->setItemIdsToMove($itemIdsToMove)
            ->setStartingDestinationSeatId($startingDestinationSeatId)
            ->setTargetAreaId($targetAreaId)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setIsFailOnSeatUnavailableAtAnyEvent($isFailOnSeatUnavailableAtAnyEvent);
    }
    /**
     * Get Direction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirection()
    {
        return isset($this->Direction) ? $this->Direction : null;
    }
    /**
     * Set Direction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MoveDirection::valueIsValid()
     * @uses \patest\EnumType\MoveDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionRequest
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MoveDirection::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MoveDirection', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \patest\EnumType\MoveDirection::getValidValues())), __LINE__);
        }
        if (is_null($direction) || (is_array($direction) && empty($direction))) {
            unset($this->Direction);
        } else {
            $this->Direction = $direction;
        }
        return $this;
    }
    /**
     * Get Distance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDistance()
    {
        return isset($this->Distance) ? $this->Distance : null;
    }
    /**
     * Set Distance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $distance
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionRequest
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !(is_int($distance) || ctype_digit($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        if (is_null($distance) || (is_array($distance) && empty($distance))) {
            unset($this->Distance);
        } else {
            $this->Distance = $distance;
        }
        return $this;
    }
    /**
     * Get IsMoveRelatedEventTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMoveRelatedEventTickets()
    {
        return isset($this->IsMoveRelatedEventTickets) ? $this->IsMoveRelatedEventTickets : null;
    }
    /**
     * Set IsMoveRelatedEventTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMoveRelatedEventTickets
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionRequest
     */
    public function setIsMoveRelatedEventTickets($isMoveRelatedEventTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMoveRelatedEventTickets) && !is_bool($isMoveRelatedEventTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMoveRelatedEventTickets, true), gettype($isMoveRelatedEventTickets)), __LINE__);
        }
        if (is_null($isMoveRelatedEventTickets) || (is_array($isMoveRelatedEventTickets) && empty($isMoveRelatedEventTickets))) {
            unset($this->IsMoveRelatedEventTickets);
        } else {
            $this->IsMoveRelatedEventTickets = $isMoveRelatedEventTickets;
        }
        return $this;
    }
    /**
     * Get ItemIdsToMove value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getItemIdsToMove()
    {
        return isset($this->ItemIdsToMove) ? $this->ItemIdsToMove : null;
    }
    /**
     * Set ItemIdsToMove value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $itemIdsToMove
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionRequest
     */
    public function setItemIdsToMove(\patest\ArrayType\ArrayOfint $itemIdsToMove = null)
    {
        if (is_null($itemIdsToMove) || (is_array($itemIdsToMove) && empty($itemIdsToMove))) {
            unset($this->ItemIdsToMove);
        } else {
            $this->ItemIdsToMove = $itemIdsToMove;
        }
        return $this;
    }
    /**
     * Get StartingDestinationSeatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStartingDestinationSeatId()
    {
        return isset($this->StartingDestinationSeatId) ? $this->StartingDestinationSeatId : null;
    }
    /**
     * Set StartingDestinationSeatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $startingDestinationSeatId
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionRequest
     */
    public function setStartingDestinationSeatId($startingDestinationSeatId = null)
    {
        // validation for constraint: int
        if (!is_null($startingDestinationSeatId) && !(is_int($startingDestinationSeatId) || ctype_digit($startingDestinationSeatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startingDestinationSeatId, true), gettype($startingDestinationSeatId)), __LINE__);
        }
        if (is_null($startingDestinationSeatId) || (is_array($startingDestinationSeatId) && empty($startingDestinationSeatId))) {
            unset($this->StartingDestinationSeatId);
        } else {
            $this->StartingDestinationSeatId = $startingDestinationSeatId;
        }
        return $this;
    }
    /**
     * Get TargetAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetAreaId()
    {
        return isset($this->TargetAreaId) ? $this->TargetAreaId : null;
    }
    /**
     * Set TargetAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetAreaId
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionRequest
     */
    public function setTargetAreaId($targetAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($targetAreaId) && !is_string($targetAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetAreaId, true), gettype($targetAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetAreaId, true)), __LINE__);
        }
        if (is_null($targetAreaId) || (is_array($targetAreaId) && empty($targetAreaId))) {
            unset($this->TargetAreaId);
        } else {
            $this->TargetAreaId = $targetAreaId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionRequest
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionRequest
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get IsFailOnSeatUnavailableAtAnyEvent value
     * @return bool|null
     */
    public function getIsFailOnSeatUnavailableAtAnyEvent()
    {
        return $this->IsFailOnSeatUnavailableAtAnyEvent;
    }
    /**
     * Set IsFailOnSeatUnavailableAtAnyEvent value
     * @param bool $isFailOnSeatUnavailableAtAnyEvent
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionRequest
     */
    public function setIsFailOnSeatUnavailableAtAnyEvent($isFailOnSeatUnavailableAtAnyEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFailOnSeatUnavailableAtAnyEvent) && !is_bool($isFailOnSeatUnavailableAtAnyEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFailOnSeatUnavailableAtAnyEvent, true), gettype($isFailOnSeatUnavailableAtAnyEvent)), __LINE__);
        }
        $this->IsFailOnSeatUnavailableAtAnyEvent = $isFailOnSeatUnavailableAtAnyEvent;
        return $this;
    }
}
