<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoveReservedSeatSelectionForMultipleEvents-Request
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MoveReservedSeatSelectionForMultipleEvents-Request
 * @subpackage Structs
 */
class MoveReservedSeatSelectionForMultipleEvents_Request extends ExtensibleDataContract
{
    /**
     * The IsAllowPartialMovePerEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAllowPartialMovePerEvent;
    /**
     * The IsAttemptAllEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAttemptAllEvents;
    /**
     * The IsGetResultInfoPerItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsGetResultInfoPerItemId;
    /**
     * The RelatedToSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedToSeriesId;
    /**
     * The SeatingInfoPerTicketItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfMoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem
     */
    public $SeatingInfoPerTicketItem;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for MoveReservedSeatSelectionForMultipleEvents-Request
     * @uses MoveReservedSeatSelectionForMultipleEvents_Request::setIsAllowPartialMovePerEvent()
     * @uses MoveReservedSeatSelectionForMultipleEvents_Request::setIsAttemptAllEvents()
     * @uses MoveReservedSeatSelectionForMultipleEvents_Request::setIsGetResultInfoPerItemId()
     * @uses MoveReservedSeatSelectionForMultipleEvents_Request::setRelatedToSeriesId()
     * @uses MoveReservedSeatSelectionForMultipleEvents_Request::setSeatingInfoPerTicketItem()
     * @uses MoveReservedSeatSelectionForMultipleEvents_Request::setTransactionGuid()
     * @uses MoveReservedSeatSelectionForMultipleEvents_Request::setTransactionSnapshotType()
     * @param bool $isAllowPartialMovePerEvent
     * @param bool $isAttemptAllEvents
     * @param bool $isGetResultInfoPerItemId
     * @param string $relatedToSeriesId
     * @param \patest\ArrayType\ArrayOfMoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem $seatingInfoPerTicketItem
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct($isAllowPartialMovePerEvent = null, $isAttemptAllEvents = null, $isGetResultInfoPerItemId = null, $relatedToSeriesId = null, \patest\ArrayType\ArrayOfMoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem $seatingInfoPerTicketItem = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setIsAllowPartialMovePerEvent($isAllowPartialMovePerEvent)
            ->setIsAttemptAllEvents($isAttemptAllEvents)
            ->setIsGetResultInfoPerItemId($isGetResultInfoPerItemId)
            ->setRelatedToSeriesId($relatedToSeriesId)
            ->setSeatingInfoPerTicketItem($seatingInfoPerTicketItem)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get IsAllowPartialMovePerEvent value
     * @return bool|null
     */
    public function getIsAllowPartialMovePerEvent()
    {
        return $this->IsAllowPartialMovePerEvent;
    }
    /**
     * Set IsAllowPartialMovePerEvent value
     * @param bool $isAllowPartialMovePerEvent
     * @return \patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Request
     */
    public function setIsAllowPartialMovePerEvent($isAllowPartialMovePerEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllowPartialMovePerEvent) && !is_bool($isAllowPartialMovePerEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllowPartialMovePerEvent, true), gettype($isAllowPartialMovePerEvent)), __LINE__);
        }
        $this->IsAllowPartialMovePerEvent = $isAllowPartialMovePerEvent;
        return $this;
    }
    /**
     * Get IsAttemptAllEvents value
     * @return bool|null
     */
    public function getIsAttemptAllEvents()
    {
        return $this->IsAttemptAllEvents;
    }
    /**
     * Set IsAttemptAllEvents value
     * @param bool $isAttemptAllEvents
     * @return \patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Request
     */
    public function setIsAttemptAllEvents($isAttemptAllEvents = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAttemptAllEvents) && !is_bool($isAttemptAllEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAttemptAllEvents, true), gettype($isAttemptAllEvents)), __LINE__);
        }
        $this->IsAttemptAllEvents = $isAttemptAllEvents;
        return $this;
    }
    /**
     * Get IsGetResultInfoPerItemId value
     * @return bool|null
     */
    public function getIsGetResultInfoPerItemId()
    {
        return $this->IsGetResultInfoPerItemId;
    }
    /**
     * Set IsGetResultInfoPerItemId value
     * @param bool $isGetResultInfoPerItemId
     * @return \patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Request
     */
    public function setIsGetResultInfoPerItemId($isGetResultInfoPerItemId = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGetResultInfoPerItemId) && !is_bool($isGetResultInfoPerItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGetResultInfoPerItemId, true), gettype($isGetResultInfoPerItemId)), __LINE__);
        }
        $this->IsGetResultInfoPerItemId = $isGetResultInfoPerItemId;
        return $this;
    }
    /**
     * Get RelatedToSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedToSeriesId()
    {
        return isset($this->RelatedToSeriesId) ? $this->RelatedToSeriesId : null;
    }
    /**
     * Set RelatedToSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedToSeriesId
     * @return \patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Request
     */
    public function setRelatedToSeriesId($relatedToSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedToSeriesId) && !is_string($relatedToSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedToSeriesId, true), gettype($relatedToSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedToSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedToSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedToSeriesId, true)), __LINE__);
        }
        if (is_null($relatedToSeriesId) || (is_array($relatedToSeriesId) && empty($relatedToSeriesId))) {
            unset($this->RelatedToSeriesId);
        } else {
            $this->RelatedToSeriesId = $relatedToSeriesId;
        }
        return $this;
    }
    /**
     * Get SeatingInfoPerTicketItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfMoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem|null
     */
    public function getSeatingInfoPerTicketItem()
    {
        return isset($this->SeatingInfoPerTicketItem) ? $this->SeatingInfoPerTicketItem : null;
    }
    /**
     * Set SeatingInfoPerTicketItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfMoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem $seatingInfoPerTicketItem
     * @return \patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Request
     */
    public function setSeatingInfoPerTicketItem(\patest\ArrayType\ArrayOfMoveReservedSeatSelectionForMultipleEventsSeatingInfoPerTicketItem $seatingInfoPerTicketItem = null)
    {
        if (is_null($seatingInfoPerTicketItem) || (is_array($seatingInfoPerTicketItem) && empty($seatingInfoPerTicketItem))) {
            unset($this->SeatingInfoPerTicketItem);
        } else {
            $this->SeatingInfoPerTicketItem = $seatingInfoPerTicketItem;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
