<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MergeClients-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MergeClients-Request
 * @subpackage Structs
 */
class MergeClients_Request extends AbstractStructBase
{
    /**
     * The DestinationClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DestinationClientId;
    /**
     * The SourceClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceClientId;
    /**
     * Constructor method for MergeClients-Request
     * @uses MergeClients_Request::setDestinationClientId()
     * @uses MergeClients_Request::setSourceClientId()
     * @param string $destinationClientId
     * @param string $sourceClientId
     */
    public function __construct($destinationClientId = null, $sourceClientId = null)
    {
        $this
            ->setDestinationClientId($destinationClientId)
            ->setSourceClientId($sourceClientId);
    }
    /**
     * Get DestinationClientId value
     * @return string|null
     */
    public function getDestinationClientId()
    {
        return $this->DestinationClientId;
    }
    /**
     * Set DestinationClientId value
     * @param string $destinationClientId
     * @return \patest\StructType\MergeClients_Request
     */
    public function setDestinationClientId($destinationClientId = null)
    {
        // validation for constraint: string
        if (!is_null($destinationClientId) && !is_string($destinationClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationClientId, true), gettype($destinationClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($destinationClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $destinationClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($destinationClientId, true)), __LINE__);
        }
        $this->DestinationClientId = $destinationClientId;
        return $this;
    }
    /**
     * Get SourceClientId value
     * @return string|null
     */
    public function getSourceClientId()
    {
        return $this->SourceClientId;
    }
    /**
     * Set SourceClientId value
     * @param string $sourceClientId
     * @return \patest\StructType\MergeClients_Request
     */
    public function setSourceClientId($sourceClientId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceClientId) && !is_string($sourceClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceClientId, true), gettype($sourceClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceClientId, true)), __LINE__);
        }
        $this->SourceClientId = $sourceClientId;
        return $this;
    }
}
