<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.UIMerchandiseProductExtended StructType
 * @subpackage Structs
 */
class Merchandise_UIMerchandiseProductExtended extends Merchandise_MerchandiseProductItem
{
    /**
     * The AddOns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_UIAddOnsItemInformation
     */
    public $AddOns;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_UIAttributeItemInformation
     */
    public $Attributes;
    /**
     * The AttributesLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttributesLabel;
    /**
     * The HasAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasAttributes;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The MerchandiseName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchandiseName;
    /**
     * The MerchandisePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MerchandisePrice;
    /**
     * The Personalize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Personalize;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for Merchandise.UIMerchandiseProductExtended
     * @uses Merchandise_UIMerchandiseProductExtended::setAddOns()
     * @uses Merchandise_UIMerchandiseProductExtended::setAttributes()
     * @uses Merchandise_UIMerchandiseProductExtended::setAttributesLabel()
     * @uses Merchandise_UIMerchandiseProductExtended::setHasAttributes()
     * @uses Merchandise_UIMerchandiseProductExtended::setItemId()
     * @uses Merchandise_UIMerchandiseProductExtended::setMerchandiseName()
     * @uses Merchandise_UIMerchandiseProductExtended::setMerchandisePrice()
     * @uses Merchandise_UIMerchandiseProductExtended::setPersonalize()
     * @uses Merchandise_UIMerchandiseProductExtended::setTransactionGuid()
     * @param \patest\StructType\RecordSetOfMerchandise_UIAddOnsItemInformation $addOns
     * @param \patest\StructType\RecordSetOfMerchandise_UIAttributeItemInformation $attributes
     * @param string $attributesLabel
     * @param bool $hasAttributes
     * @param int $itemId
     * @param string $merchandiseName
     * @param \patest\StructType\Money $merchandisePrice
     * @param bool $personalize
     * @param string $transactionGuid
     */
    public function __construct(\patest\StructType\RecordSetOfMerchandise_UIAddOnsItemInformation $addOns = null, \patest\StructType\RecordSetOfMerchandise_UIAttributeItemInformation $attributes = null, $attributesLabel = null, $hasAttributes = null, $itemId = null, $merchandiseName = null, \patest\StructType\Money $merchandisePrice = null, $personalize = null, $transactionGuid = null)
    {
        $this
            ->setAddOns($addOns)
            ->setAttributes($attributes)
            ->setAttributesLabel($attributesLabel)
            ->setHasAttributes($hasAttributes)
            ->setItemId($itemId)
            ->setMerchandiseName($merchandiseName)
            ->setMerchandisePrice($merchandisePrice)
            ->setPersonalize($personalize)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get AddOns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_UIAddOnsItemInformation|null
     */
    public function getAddOns()
    {
        return isset($this->AddOns) ? $this->AddOns : null;
    }
    /**
     * Set AddOns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_UIAddOnsItemInformation $addOns
     * @return \patest\StructType\Merchandise_UIMerchandiseProductExtended
     */
    public function setAddOns(\patest\StructType\RecordSetOfMerchandise_UIAddOnsItemInformation $addOns = null)
    {
        if (is_null($addOns) || (is_array($addOns) && empty($addOns))) {
            unset($this->AddOns);
        } else {
            $this->AddOns = $addOns;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_UIAttributeItemInformation|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_UIAttributeItemInformation $attributes
     * @return \patest\StructType\Merchandise_UIMerchandiseProductExtended
     */
    public function setAttributes(\patest\StructType\RecordSetOfMerchandise_UIAttributeItemInformation $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get AttributesLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttributesLabel()
    {
        return isset($this->AttributesLabel) ? $this->AttributesLabel : null;
    }
    /**
     * Set AttributesLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attributesLabel
     * @return \patest\StructType\Merchandise_UIMerchandiseProductExtended
     */
    public function setAttributesLabel($attributesLabel = null)
    {
        // validation for constraint: string
        if (!is_null($attributesLabel) && !is_string($attributesLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributesLabel, true), gettype($attributesLabel)), __LINE__);
        }
        if (is_null($attributesLabel) || (is_array($attributesLabel) && empty($attributesLabel))) {
            unset($this->AttributesLabel);
        } else {
            $this->AttributesLabel = $attributesLabel;
        }
        return $this;
    }
    /**
     * Get HasAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasAttributes()
    {
        return isset($this->HasAttributes) ? $this->HasAttributes : null;
    }
    /**
     * Set HasAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasAttributes
     * @return \patest\StructType\Merchandise_UIMerchandiseProductExtended
     */
    public function setHasAttributes($hasAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasAttributes) && !is_bool($hasAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasAttributes, true), gettype($hasAttributes)), __LINE__);
        }
        if (is_null($hasAttributes) || (is_array($hasAttributes) && empty($hasAttributes))) {
            unset($this->HasAttributes);
        } else {
            $this->HasAttributes = $hasAttributes;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\Merchandise_UIMerchandiseProductExtended
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get MerchandiseName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseName()
    {
        return isset($this->MerchandiseName) ? $this->MerchandiseName : null;
    }
    /**
     * Set MerchandiseName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseName
     * @return \patest\StructType\Merchandise_UIMerchandiseProductExtended
     */
    public function setMerchandiseName($merchandiseName = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseName) && !is_string($merchandiseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseName, true), gettype($merchandiseName)), __LINE__);
        }
        if (is_null($merchandiseName) || (is_array($merchandiseName) && empty($merchandiseName))) {
            unset($this->MerchandiseName);
        } else {
            $this->MerchandiseName = $merchandiseName;
        }
        return $this;
    }
    /**
     * Get MerchandisePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMerchandisePrice()
    {
        return isset($this->MerchandisePrice) ? $this->MerchandisePrice : null;
    }
    /**
     * Set MerchandisePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $merchandisePrice
     * @return \patest\StructType\Merchandise_UIMerchandiseProductExtended
     */
    public function setMerchandisePrice(\patest\StructType\Money $merchandisePrice = null)
    {
        if (is_null($merchandisePrice) || (is_array($merchandisePrice) && empty($merchandisePrice))) {
            unset($this->MerchandisePrice);
        } else {
            $this->MerchandisePrice = $merchandisePrice;
        }
        return $this;
    }
    /**
     * Get Personalize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPersonalize()
    {
        return isset($this->Personalize) ? $this->Personalize : null;
    }
    /**
     * Set Personalize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $personalize
     * @return \patest\StructType\Merchandise_UIMerchandiseProductExtended
     */
    public function setPersonalize($personalize = null)
    {
        // validation for constraint: boolean
        if (!is_null($personalize) && !is_bool($personalize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($personalize, true), gettype($personalize)), __LINE__);
        }
        if (is_null($personalize) || (is_array($personalize) && empty($personalize))) {
            unset($this->Personalize);
        } else {
            $this->Personalize = $personalize;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Merchandise_UIMerchandiseProductExtended
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
