<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.StockTakeHeaderFilter StructType
 * @subpackage Structs
 */
class Merchandise_StockTakeHeaderFilter extends FilterEntity
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The ItemTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemTypeId;
    /**
     * The LocationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LocationId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * Constructor method for Merchandise.StockTakeHeaderFilter
     * @uses Merchandise_StockTakeHeaderFilter::setCategoryId()
     * @uses Merchandise_StockTakeHeaderFilter::setItemTypeId()
     * @uses Merchandise_StockTakeHeaderFilter::setLocationId()
     * @uses Merchandise_StockTakeHeaderFilter::setName()
     * @param string $categoryId
     * @param string $itemTypeId
     * @param string $locationId
     * @param \patest\StructType\GlobalString $name
     */
    public function __construct($categoryId = null, $itemTypeId = null, $locationId = null, \patest\StructType\GlobalString $name = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setItemTypeId($itemTypeId)
            ->setLocationId($locationId)
            ->setName($name);
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Merchandise_StockTakeHeaderFilter
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemTypeId()
    {
        return isset($this->ItemTypeId) ? $this->ItemTypeId : null;
    }
    /**
     * Set ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemTypeId
     * @return \patest\StructType\Merchandise_StockTakeHeaderFilter
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeId) && !is_string($itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemTypeId, true)), __LINE__);
        }
        if (is_null($itemTypeId) || (is_array($itemTypeId) && empty($itemTypeId))) {
            unset($this->ItemTypeId);
        } else {
            $this->ItemTypeId = $itemTypeId;
        }
        return $this;
    }
    /**
     * Get LocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationId()
    {
        return isset($this->LocationId) ? $this->LocationId : null;
    }
    /**
     * Set LocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationId
     * @return \patest\StructType\Merchandise_StockTakeHeaderFilter
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: string
        if (!is_null($locationId) && !is_string($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationId, true), gettype($locationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($locationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($locationId, true)), __LINE__);
        }
        if (is_null($locationId) || (is_array($locationId) && empty($locationId))) {
            unset($this->LocationId);
        } else {
            $this->LocationId = $locationId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Merchandise_StockTakeHeaderFilter
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
