<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.ProductAddOn StructType
 * @subpackage Structs
 */
class Merchandise_ProductAddOn extends Merchandise_MerchandiseBase
{
    /**
     * The AddOnTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddOnTypeId;
    /**
     * The DisplayOrderOnScreen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DisplayOrderOnScreen;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * Constructor method for Merchandise.ProductAddOn
     * @uses Merchandise_ProductAddOn::setAddOnTypeId()
     * @uses Merchandise_ProductAddOn::setDisplayOrderOnScreen()
     * @uses Merchandise_ProductAddOn::setProductId()
     * @param string $addOnTypeId
     * @param int $displayOrderOnScreen
     * @param string $productId
     */
    public function __construct($addOnTypeId = null, $displayOrderOnScreen = null, $productId = null)
    {
        $this
            ->setAddOnTypeId($addOnTypeId)
            ->setDisplayOrderOnScreen($displayOrderOnScreen)
            ->setProductId($productId);
    }
    /**
     * Get AddOnTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddOnTypeId()
    {
        return isset($this->AddOnTypeId) ? $this->AddOnTypeId : null;
    }
    /**
     * Set AddOnTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addOnTypeId
     * @return \patest\StructType\Merchandise_ProductAddOn
     */
    public function setAddOnTypeId($addOnTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($addOnTypeId) && !is_string($addOnTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addOnTypeId, true), gettype($addOnTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($addOnTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addOnTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($addOnTypeId, true)), __LINE__);
        }
        if (is_null($addOnTypeId) || (is_array($addOnTypeId) && empty($addOnTypeId))) {
            unset($this->AddOnTypeId);
        } else {
            $this->AddOnTypeId = $addOnTypeId;
        }
        return $this;
    }
    /**
     * Get DisplayOrderOnScreen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDisplayOrderOnScreen()
    {
        return isset($this->DisplayOrderOnScreen) ? $this->DisplayOrderOnScreen : null;
    }
    /**
     * Set DisplayOrderOnScreen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $displayOrderOnScreen
     * @return \patest\StructType\Merchandise_ProductAddOn
     */
    public function setDisplayOrderOnScreen($displayOrderOnScreen = null)
    {
        // validation for constraint: int
        if (!is_null($displayOrderOnScreen) && !(is_int($displayOrderOnScreen) || ctype_digit($displayOrderOnScreen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayOrderOnScreen, true), gettype($displayOrderOnScreen)), __LINE__);
        }
        if (is_null($displayOrderOnScreen) || (is_array($displayOrderOnScreen) && empty($displayOrderOnScreen))) {
            unset($this->DisplayOrderOnScreen);
        } else {
            $this->DisplayOrderOnScreen = $displayOrderOnScreen;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\Merchandise_ProductAddOn
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
}
