<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.MerchandiseIngredient StructType
 * @subpackage Structs
 */
class Merchandise_MerchandiseIngredient extends Merchandise_MerchandiseBase
{
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The Esv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Esv;
    /**
     * The IngredientMerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IngredientMerchandiseId;
    /**
     * The ItemTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemTypeId;
    /**
     * The MainQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MainQuantity;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The PercentageFromTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PercentageFromTotal;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The UnitEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $UnitEsv;
    /**
     * The UOMId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UOMId;
    /**
     * Constructor method for Merchandise.MerchandiseIngredient
     * @uses Merchandise_MerchandiseIngredient::setBarcode()
     * @uses Merchandise_MerchandiseIngredient::setCategoryId()
     * @uses Merchandise_MerchandiseIngredient::setEsv()
     * @uses Merchandise_MerchandiseIngredient::setIngredientMerchandiseId()
     * @uses Merchandise_MerchandiseIngredient::setItemTypeId()
     * @uses Merchandise_MerchandiseIngredient::setMainQuantity()
     * @uses Merchandise_MerchandiseIngredient::setMerchandiseId()
     * @uses Merchandise_MerchandiseIngredient::setPercentageFromTotal()
     * @uses Merchandise_MerchandiseIngredient::setProductId()
     * @uses Merchandise_MerchandiseIngredient::setQuantity()
     * @uses Merchandise_MerchandiseIngredient::setUnitEsv()
     * @uses Merchandise_MerchandiseIngredient::setUOMId()
     * @param string $barcode
     * @param string $categoryId
     * @param float $esv
     * @param string $ingredientMerchandiseId
     * @param string $itemTypeId
     * @param float $mainQuantity
     * @param string $merchandiseId
     * @param float $percentageFromTotal
     * @param string $productId
     * @param float $quantity
     * @param float $unitEsv
     * @param string $uOMId
     */
    public function __construct($barcode = null, $categoryId = null, $esv = null, $ingredientMerchandiseId = null, $itemTypeId = null, $mainQuantity = null, $merchandiseId = null, $percentageFromTotal = null, $productId = null, $quantity = null, $unitEsv = null, $uOMId = null)
    {
        $this
            ->setBarcode($barcode)
            ->setCategoryId($categoryId)
            ->setEsv($esv)
            ->setIngredientMerchandiseId($ingredientMerchandiseId)
            ->setItemTypeId($itemTypeId)
            ->setMainQuantity($mainQuantity)
            ->setMerchandiseId($merchandiseId)
            ->setPercentageFromTotal($percentageFromTotal)
            ->setProductId($productId)
            ->setQuantity($quantity)
            ->setUnitEsv($unitEsv)
            ->setUOMId($uOMId);
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get Esv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEsv()
    {
        return isset($this->Esv) ? $this->Esv : null;
    }
    /**
     * Set Esv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $esv
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setEsv($esv = null)
    {
        // validation for constraint: float
        if (!is_null($esv) && !(is_float($esv) || is_numeric($esv))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($esv, true), gettype($esv)), __LINE__);
        }
        if (is_null($esv) || (is_array($esv) && empty($esv))) {
            unset($this->Esv);
        } else {
            $this->Esv = $esv;
        }
        return $this;
    }
    /**
     * Get IngredientMerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIngredientMerchandiseId()
    {
        return isset($this->IngredientMerchandiseId) ? $this->IngredientMerchandiseId : null;
    }
    /**
     * Set IngredientMerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ingredientMerchandiseId
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setIngredientMerchandiseId($ingredientMerchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($ingredientMerchandiseId) && !is_string($ingredientMerchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ingredientMerchandiseId, true), gettype($ingredientMerchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ingredientMerchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ingredientMerchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ingredientMerchandiseId, true)), __LINE__);
        }
        if (is_null($ingredientMerchandiseId) || (is_array($ingredientMerchandiseId) && empty($ingredientMerchandiseId))) {
            unset($this->IngredientMerchandiseId);
        } else {
            $this->IngredientMerchandiseId = $ingredientMerchandiseId;
        }
        return $this;
    }
    /**
     * Get ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemTypeId()
    {
        return isset($this->ItemTypeId) ? $this->ItemTypeId : null;
    }
    /**
     * Set ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemTypeId
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeId) && !is_string($itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemTypeId, true)), __LINE__);
        }
        if (is_null($itemTypeId) || (is_array($itemTypeId) && empty($itemTypeId))) {
            unset($this->ItemTypeId);
        } else {
            $this->ItemTypeId = $itemTypeId;
        }
        return $this;
    }
    /**
     * Get MainQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMainQuantity()
    {
        return isset($this->MainQuantity) ? $this->MainQuantity : null;
    }
    /**
     * Set MainQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mainQuantity
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setMainQuantity($mainQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($mainQuantity) && !(is_float($mainQuantity) || is_numeric($mainQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mainQuantity, true), gettype($mainQuantity)), __LINE__);
        }
        if (is_null($mainQuantity) || (is_array($mainQuantity) && empty($mainQuantity))) {
            unset($this->MainQuantity);
        } else {
            $this->MainQuantity = $mainQuantity;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return isset($this->MerchandiseId) ? $this->MerchandiseId : null;
    }
    /**
     * Set MerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseId
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        if (is_null($merchandiseId) || (is_array($merchandiseId) && empty($merchandiseId))) {
            unset($this->MerchandiseId);
        } else {
            $this->MerchandiseId = $merchandiseId;
        }
        return $this;
    }
    /**
     * Get PercentageFromTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPercentageFromTotal()
    {
        return isset($this->PercentageFromTotal) ? $this->PercentageFromTotal : null;
    }
    /**
     * Set PercentageFromTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $percentageFromTotal
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setPercentageFromTotal($percentageFromTotal = null)
    {
        // validation for constraint: float
        if (!is_null($percentageFromTotal) && !(is_float($percentageFromTotal) || is_numeric($percentageFromTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentageFromTotal, true), gettype($percentageFromTotal)), __LINE__);
        }
        if (is_null($percentageFromTotal) || (is_array($percentageFromTotal) && empty($percentageFromTotal))) {
            unset($this->PercentageFromTotal);
        } else {
            $this->PercentageFromTotal = $percentageFromTotal;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantity
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get UnitEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getUnitEsv()
    {
        return isset($this->UnitEsv) ? $this->UnitEsv : null;
    }
    /**
     * Set UnitEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $unitEsv
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setUnitEsv($unitEsv = null)
    {
        // validation for constraint: float
        if (!is_null($unitEsv) && !(is_float($unitEsv) || is_numeric($unitEsv))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitEsv, true), gettype($unitEsv)), __LINE__);
        }
        if (is_null($unitEsv) || (is_array($unitEsv) && empty($unitEsv))) {
            unset($this->UnitEsv);
        } else {
            $this->UnitEsv = $unitEsv;
        }
        return $this;
    }
    /**
     * Get UOMId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUOMId()
    {
        return isset($this->UOMId) ? $this->UOMId : null;
    }
    /**
     * Set UOMId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uOMId
     * @return \patest\StructType\Merchandise_MerchandiseIngredient
     */
    public function setUOMId($uOMId = null)
    {
        // validation for constraint: string
        if (!is_null($uOMId) && !is_string($uOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uOMId, true), gettype($uOMId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uOMId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uOMId, true)), __LINE__);
        }
        if (is_null($uOMId) || (is_array($uOMId) && empty($uOMId))) {
            unset($this->UOMId);
        } else {
            $this->UOMId = $uOMId;
        }
        return $this;
    }
}
