<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.ItemType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Merchandise.ItemType
 * @subpackage Structs
 */
class Merchandise_ItemType extends Merchandise_MerchandiseBase
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The Attribute1TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Attribute1TypeId;
    /**
     * The Attribute2TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Attribute2TypeId;
    /**
     * The Attribute3TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Attribute3TypeId;
    /**
     * The Attribute4TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Attribute4TypeId;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsBarCodeToBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBarCodeToBePrinted;
    /**
     * The IsClassificationActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClassificationActive;
    /**
     * The IsCountable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCountable;
    /**
     * The IsPurchaseable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPurchaseable;
    /**
     * The IsSellable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSellable;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Merchandise_Media
     */
    public $Media;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NotificationToUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NotificationToUserId;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The SellOnlyAsPartOfPrompt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SellOnlyAsPartOfPrompt;
    /**
     * The StockType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StockType;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Merchandise.ItemType
     * @uses Merchandise_ItemType::setAclSchemeId()
     * @uses Merchandise_ItemType::setAttribute1TypeId()
     * @uses Merchandise_ItemType::setAttribute2TypeId()
     * @uses Merchandise_ItemType::setAttribute3TypeId()
     * @uses Merchandise_ItemType::setAttribute4TypeId()
     * @uses Merchandise_ItemType::setCategoryId()
     * @uses Merchandise_ItemType::setCrossOrgUnitsAclSchemeId()
     * @uses Merchandise_ItemType::setDescription()
     * @uses Merchandise_ItemType::setExternalId()
     * @uses Merchandise_ItemType::setIsActive()
     * @uses Merchandise_ItemType::setIsBarCodeToBePrinted()
     * @uses Merchandise_ItemType::setIsClassificationActive()
     * @uses Merchandise_ItemType::setIsCountable()
     * @uses Merchandise_ItemType::setIsPurchaseable()
     * @uses Merchandise_ItemType::setIsSellable()
     * @uses Merchandise_ItemType::setIsSystem()
     * @uses Merchandise_ItemType::setLedgerId()
     * @uses Merchandise_ItemType::setMedia()
     * @uses Merchandise_ItemType::setName()
     * @uses Merchandise_ItemType::setNotificationToUserId()
     * @uses Merchandise_ItemType::setOrdinal()
     * @uses Merchandise_ItemType::setOrganizationUnitId()
     * @uses Merchandise_ItemType::setProjectIdentifierId()
     * @uses Merchandise_ItemType::setSellOnlyAsPartOfPrompt()
     * @uses Merchandise_ItemType::setStockType()
     * @uses Merchandise_ItemType::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param string $attribute1TypeId
     * @param string $attribute2TypeId
     * @param string $attribute3TypeId
     * @param string $attribute4TypeId
     * @param string $categoryId
     * @param int $crossOrgUnitsAclSchemeId
     * @param \patest\StructType\GlobalString $description
     * @param string $externalId
     * @param bool $isActive
     * @param bool $isBarCodeToBePrinted
     * @param bool $isClassificationActive
     * @param bool $isCountable
     * @param bool $isPurchaseable
     * @param bool $isSellable
     * @param bool $isSystem
     * @param string $ledgerId
     * @param \patest\StructType\Merchandise_Media $media
     * @param \patest\StructType\GlobalString $name
     * @param string $notificationToUserId
     * @param int $ordinal
     * @param string $organizationUnitId
     * @param string $projectIdentifierId
     * @param bool $sellOnlyAsPartOfPrompt
     * @param string $stockType
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $attribute1TypeId = null, $attribute2TypeId = null, $attribute3TypeId = null, $attribute4TypeId = null, $categoryId = null, $crossOrgUnitsAclSchemeId = null, \patest\StructType\GlobalString $description = null, $externalId = null, $isActive = null, $isBarCodeToBePrinted = null, $isClassificationActive = null, $isCountable = null, $isPurchaseable = null, $isSellable = null, $isSystem = null, $ledgerId = null, \patest\StructType\Merchandise_Media $media = null, \patest\StructType\GlobalString $name = null, $notificationToUserId = null, $ordinal = null, $organizationUnitId = null, $projectIdentifierId = null, $sellOnlyAsPartOfPrompt = null, $stockType = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setAttribute1TypeId($attribute1TypeId)
            ->setAttribute2TypeId($attribute2TypeId)
            ->setAttribute3TypeId($attribute3TypeId)
            ->setAttribute4TypeId($attribute4TypeId)
            ->setCategoryId($categoryId)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setDescription($description)
            ->setExternalId($externalId)
            ->setIsActive($isActive)
            ->setIsBarCodeToBePrinted($isBarCodeToBePrinted)
            ->setIsClassificationActive($isClassificationActive)
            ->setIsCountable($isCountable)
            ->setIsPurchaseable($isPurchaseable)
            ->setIsSellable($isSellable)
            ->setIsSystem($isSystem)
            ->setLedgerId($ledgerId)
            ->setMedia($media)
            ->setName($name)
            ->setNotificationToUserId($notificationToUserId)
            ->setOrdinal($ordinal)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setSellOnlyAsPartOfPrompt($sellOnlyAsPartOfPrompt)
            ->setStockType($stockType)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get Attribute1TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttribute1TypeId()
    {
        return isset($this->Attribute1TypeId) ? $this->Attribute1TypeId : null;
    }
    /**
     * Set Attribute1TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attribute1TypeId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setAttribute1TypeId($attribute1TypeId = null)
    {
        // validation for constraint: string
        if (!is_null($attribute1TypeId) && !is_string($attribute1TypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribute1TypeId, true), gettype($attribute1TypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attribute1TypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attribute1TypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attribute1TypeId, true)), __LINE__);
        }
        if (is_null($attribute1TypeId) || (is_array($attribute1TypeId) && empty($attribute1TypeId))) {
            unset($this->Attribute1TypeId);
        } else {
            $this->Attribute1TypeId = $attribute1TypeId;
        }
        return $this;
    }
    /**
     * Get Attribute2TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttribute2TypeId()
    {
        return isset($this->Attribute2TypeId) ? $this->Attribute2TypeId : null;
    }
    /**
     * Set Attribute2TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attribute2TypeId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setAttribute2TypeId($attribute2TypeId = null)
    {
        // validation for constraint: string
        if (!is_null($attribute2TypeId) && !is_string($attribute2TypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribute2TypeId, true), gettype($attribute2TypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attribute2TypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attribute2TypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attribute2TypeId, true)), __LINE__);
        }
        if (is_null($attribute2TypeId) || (is_array($attribute2TypeId) && empty($attribute2TypeId))) {
            unset($this->Attribute2TypeId);
        } else {
            $this->Attribute2TypeId = $attribute2TypeId;
        }
        return $this;
    }
    /**
     * Get Attribute3TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttribute3TypeId()
    {
        return isset($this->Attribute3TypeId) ? $this->Attribute3TypeId : null;
    }
    /**
     * Set Attribute3TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attribute3TypeId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setAttribute3TypeId($attribute3TypeId = null)
    {
        // validation for constraint: string
        if (!is_null($attribute3TypeId) && !is_string($attribute3TypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribute3TypeId, true), gettype($attribute3TypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attribute3TypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attribute3TypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attribute3TypeId, true)), __LINE__);
        }
        if (is_null($attribute3TypeId) || (is_array($attribute3TypeId) && empty($attribute3TypeId))) {
            unset($this->Attribute3TypeId);
        } else {
            $this->Attribute3TypeId = $attribute3TypeId;
        }
        return $this;
    }
    /**
     * Get Attribute4TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttribute4TypeId()
    {
        return isset($this->Attribute4TypeId) ? $this->Attribute4TypeId : null;
    }
    /**
     * Set Attribute4TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attribute4TypeId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setAttribute4TypeId($attribute4TypeId = null)
    {
        // validation for constraint: string
        if (!is_null($attribute4TypeId) && !is_string($attribute4TypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribute4TypeId, true), gettype($attribute4TypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attribute4TypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attribute4TypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attribute4TypeId, true)), __LINE__);
        }
        if (is_null($attribute4TypeId) || (is_array($attribute4TypeId) && empty($attribute4TypeId))) {
            unset($this->Attribute4TypeId);
        } else {
            $this->Attribute4TypeId = $attribute4TypeId;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsBarCodeToBePrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBarCodeToBePrinted()
    {
        return isset($this->IsBarCodeToBePrinted) ? $this->IsBarCodeToBePrinted : null;
    }
    /**
     * Set IsBarCodeToBePrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBarCodeToBePrinted
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setIsBarCodeToBePrinted($isBarCodeToBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBarCodeToBePrinted) && !is_bool($isBarCodeToBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBarCodeToBePrinted, true), gettype($isBarCodeToBePrinted)), __LINE__);
        }
        if (is_null($isBarCodeToBePrinted) || (is_array($isBarCodeToBePrinted) && empty($isBarCodeToBePrinted))) {
            unset($this->IsBarCodeToBePrinted);
        } else {
            $this->IsBarCodeToBePrinted = $isBarCodeToBePrinted;
        }
        return $this;
    }
    /**
     * Get IsClassificationActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClassificationActive()
    {
        return isset($this->IsClassificationActive) ? $this->IsClassificationActive : null;
    }
    /**
     * Set IsClassificationActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClassificationActive
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setIsClassificationActive($isClassificationActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClassificationActive) && !is_bool($isClassificationActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClassificationActive, true), gettype($isClassificationActive)), __LINE__);
        }
        if (is_null($isClassificationActive) || (is_array($isClassificationActive) && empty($isClassificationActive))) {
            unset($this->IsClassificationActive);
        } else {
            $this->IsClassificationActive = $isClassificationActive;
        }
        return $this;
    }
    /**
     * Get IsCountable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCountable()
    {
        return isset($this->IsCountable) ? $this->IsCountable : null;
    }
    /**
     * Set IsCountable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCountable
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setIsCountable($isCountable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCountable) && !is_bool($isCountable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCountable, true), gettype($isCountable)), __LINE__);
        }
        if (is_null($isCountable) || (is_array($isCountable) && empty($isCountable))) {
            unset($this->IsCountable);
        } else {
            $this->IsCountable = $isCountable;
        }
        return $this;
    }
    /**
     * Get IsPurchaseable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPurchaseable()
    {
        return isset($this->IsPurchaseable) ? $this->IsPurchaseable : null;
    }
    /**
     * Set IsPurchaseable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPurchaseable
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setIsPurchaseable($isPurchaseable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPurchaseable) && !is_bool($isPurchaseable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPurchaseable, true), gettype($isPurchaseable)), __LINE__);
        }
        if (is_null($isPurchaseable) || (is_array($isPurchaseable) && empty($isPurchaseable))) {
            unset($this->IsPurchaseable);
        } else {
            $this->IsPurchaseable = $isPurchaseable;
        }
        return $this;
    }
    /**
     * Get IsSellable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSellable()
    {
        return isset($this->IsSellable) ? $this->IsSellable : null;
    }
    /**
     * Set IsSellable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSellable
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setIsSellable($isSellable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSellable) && !is_bool($isSellable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSellable, true), gettype($isSellable)), __LINE__);
        }
        if (is_null($isSellable) || (is_array($isSellable) && empty($isSellable))) {
            unset($this->IsSellable);
        } else {
            $this->IsSellable = $isSellable;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Merchandise_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Merchandise_Media $media
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setMedia(\patest\StructType\Merchandise_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NotificationToUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationToUserId()
    {
        return isset($this->NotificationToUserId) ? $this->NotificationToUserId : null;
    }
    /**
     * Set NotificationToUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationToUserId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setNotificationToUserId($notificationToUserId = null)
    {
        // validation for constraint: string
        if (!is_null($notificationToUserId) && !is_string($notificationToUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationToUserId, true), gettype($notificationToUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($notificationToUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $notificationToUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($notificationToUserId, true)), __LINE__);
        }
        if (is_null($notificationToUserId) || (is_array($notificationToUserId) && empty($notificationToUserId))) {
            unset($this->NotificationToUserId);
        } else {
            $this->NotificationToUserId = $notificationToUserId;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get SellOnlyAsPartOfPrompt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSellOnlyAsPartOfPrompt()
    {
        return isset($this->SellOnlyAsPartOfPrompt) ? $this->SellOnlyAsPartOfPrompt : null;
    }
    /**
     * Set SellOnlyAsPartOfPrompt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sellOnlyAsPartOfPrompt
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setSellOnlyAsPartOfPrompt($sellOnlyAsPartOfPrompt = null)
    {
        // validation for constraint: boolean
        if (!is_null($sellOnlyAsPartOfPrompt) && !is_bool($sellOnlyAsPartOfPrompt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sellOnlyAsPartOfPrompt, true), gettype($sellOnlyAsPartOfPrompt)), __LINE__);
        }
        if (is_null($sellOnlyAsPartOfPrompt) || (is_array($sellOnlyAsPartOfPrompt) && empty($sellOnlyAsPartOfPrompt))) {
            unset($this->SellOnlyAsPartOfPrompt);
        } else {
            $this->SellOnlyAsPartOfPrompt = $sellOnlyAsPartOfPrompt;
        }
        return $this;
    }
    /**
     * Get StockType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockType()
    {
        return isset($this->StockType) ? $this->StockType : null;
    }
    /**
     * Set StockType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\StockType::valueIsValid()
     * @uses \patest\EnumType\StockType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stockType
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setStockType($stockType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StockType::valueIsValid($stockType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StockType', is_array($stockType) ? implode(', ', $stockType) : var_export($stockType, true), implode(', ', \patest\EnumType\StockType::getValidValues())), __LINE__);
        }
        if (is_null($stockType) || (is_array($stockType) && empty($stockType))) {
            unset($this->StockType);
        } else {
            $this->StockType = $stockType;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Merchandise_ItemType
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
