<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.InternalTransferFilter StructType
 * @subpackage Structs
 */
class Merchandise_InternalTransferFilter extends FilterEntity
{
    /**
     * The FormNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormNo;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The FromLocationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FromLocationId;
    /**
     * The IsEditMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEditMode;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The ToLocationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ToLocationId;
    /**
     * Constructor method for Merchandise.InternalTransferFilter
     * @uses Merchandise_InternalTransferFilter::setFormNo()
     * @uses Merchandise_InternalTransferFilter::setFromDate()
     * @uses Merchandise_InternalTransferFilter::setFromLocationId()
     * @uses Merchandise_InternalTransferFilter::setIsEditMode()
     * @uses Merchandise_InternalTransferFilter::setToDate()
     * @uses Merchandise_InternalTransferFilter::setToLocationId()
     * @param string $formNo
     * @param string $fromDate
     * @param string $fromLocationId
     * @param bool $isEditMode
     * @param string $toDate
     * @param string $toLocationId
     */
    public function __construct($formNo = null, $fromDate = null, $fromLocationId = null, $isEditMode = null, $toDate = null, $toLocationId = null)
    {
        $this
            ->setFormNo($formNo)
            ->setFromDate($fromDate)
            ->setFromLocationId($fromLocationId)
            ->setIsEditMode($isEditMode)
            ->setToDate($toDate)
            ->setToLocationId($toLocationId);
    }
    /**
     * Get FormNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormNo()
    {
        return isset($this->FormNo) ? $this->FormNo : null;
    }
    /**
     * Set FormNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formNo
     * @return \patest\StructType\Merchandise_InternalTransferFilter
     */
    public function setFormNo($formNo = null)
    {
        // validation for constraint: string
        if (!is_null($formNo) && !is_string($formNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formNo, true), gettype($formNo)), __LINE__);
        }
        if (is_null($formNo) || (is_array($formNo) && empty($formNo))) {
            unset($this->FormNo);
        } else {
            $this->FormNo = $formNo;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Merchandise_InternalTransferFilter
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get FromLocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromLocationId()
    {
        return isset($this->FromLocationId) ? $this->FromLocationId : null;
    }
    /**
     * Set FromLocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromLocationId
     * @return \patest\StructType\Merchandise_InternalTransferFilter
     */
    public function setFromLocationId($fromLocationId = null)
    {
        // validation for constraint: string
        if (!is_null($fromLocationId) && !is_string($fromLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromLocationId, true), gettype($fromLocationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fromLocationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fromLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fromLocationId, true)), __LINE__);
        }
        if (is_null($fromLocationId) || (is_array($fromLocationId) && empty($fromLocationId))) {
            unset($this->FromLocationId);
        } else {
            $this->FromLocationId = $fromLocationId;
        }
        return $this;
    }
    /**
     * Get IsEditMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEditMode()
    {
        return isset($this->IsEditMode) ? $this->IsEditMode : null;
    }
    /**
     * Set IsEditMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEditMode
     * @return \patest\StructType\Merchandise_InternalTransferFilter
     */
    public function setIsEditMode($isEditMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEditMode) && !is_bool($isEditMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEditMode, true), gettype($isEditMode)), __LINE__);
        }
        if (is_null($isEditMode) || (is_array($isEditMode) && empty($isEditMode))) {
            unset($this->IsEditMode);
        } else {
            $this->IsEditMode = $isEditMode;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Merchandise_InternalTransferFilter
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get ToLocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToLocationId()
    {
        return isset($this->ToLocationId) ? $this->ToLocationId : null;
    }
    /**
     * Set ToLocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toLocationId
     * @return \patest\StructType\Merchandise_InternalTransferFilter
     */
    public function setToLocationId($toLocationId = null)
    {
        // validation for constraint: string
        if (!is_null($toLocationId) && !is_string($toLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toLocationId, true), gettype($toLocationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($toLocationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $toLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($toLocationId, true)), __LINE__);
        }
        if (is_null($toLocationId) || (is_array($toLocationId) && empty($toLocationId))) {
            unset($this->ToLocationId);
        } else {
            $this->ToLocationId = $toLocationId;
        }
        return $this;
    }
}
