<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.CustomerOrderFilter StructType
 * @subpackage Structs
 */
class Merchandise_CustomerOrderFilter extends FilterEntity
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerId;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDate;
    /**
     * The FormDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormDate;
    /**
     * The IsDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDelivered;
    /**
     * The SalesTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SalesTransactionNumber;
    /**
     * Constructor method for Merchandise.CustomerOrderFilter
     * @uses Merchandise_CustomerOrderFilter::setCustomerId()
     * @uses Merchandise_CustomerOrderFilter::setDeliveryDate()
     * @uses Merchandise_CustomerOrderFilter::setDueDate()
     * @uses Merchandise_CustomerOrderFilter::setFormDate()
     * @uses Merchandise_CustomerOrderFilter::setIsDelivered()
     * @uses Merchandise_CustomerOrderFilter::setSalesTransactionNumber()
     * @param string $customerId
     * @param string $deliveryDate
     * @param string $dueDate
     * @param string $formDate
     * @param bool $isDelivered
     * @param int $salesTransactionNumber
     */
    public function __construct($customerId = null, $deliveryDate = null, $dueDate = null, $formDate = null, $isDelivered = null, $salesTransactionNumber = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDeliveryDate($deliveryDate)
            ->setDueDate($dueDate)
            ->setFormDate($formDate)
            ->setIsDelivered($isDelivered)
            ->setSalesTransactionNumber($salesTransactionNumber);
    }
    /**
     * Get CustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerId()
    {
        return isset($this->CustomerId) ? $this->CustomerId : null;
    }
    /**
     * Set CustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerId
     * @return \patest\StructType\Merchandise_CustomerOrderFilter
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerId, true)), __LINE__);
        }
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->CustomerId);
        } else {
            $this->CustomerId = $customerId;
        }
        return $this;
    }
    /**
     * Get DeliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return isset($this->DeliveryDate) ? $this->DeliveryDate : null;
    }
    /**
     * Set DeliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryDate
     * @return \patest\StructType\Merchandise_CustomerOrderFilter
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        if (is_null($deliveryDate) || (is_array($deliveryDate) && empty($deliveryDate))) {
            unset($this->DeliveryDate);
        } else {
            $this->DeliveryDate = $deliveryDate;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDate
     * @return \patest\StructType\Merchandise_CustomerOrderFilter
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get FormDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormDate()
    {
        return isset($this->FormDate) ? $this->FormDate : null;
    }
    /**
     * Set FormDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formDate
     * @return \patest\StructType\Merchandise_CustomerOrderFilter
     */
    public function setFormDate($formDate = null)
    {
        // validation for constraint: string
        if (!is_null($formDate) && !is_string($formDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formDate, true), gettype($formDate)), __LINE__);
        }
        if (is_null($formDate) || (is_array($formDate) && empty($formDate))) {
            unset($this->FormDate);
        } else {
            $this->FormDate = $formDate;
        }
        return $this;
    }
    /**
     * Get IsDelivered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDelivered()
    {
        return isset($this->IsDelivered) ? $this->IsDelivered : null;
    }
    /**
     * Set IsDelivered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDelivered
     * @return \patest\StructType\Merchandise_CustomerOrderFilter
     */
    public function setIsDelivered($isDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDelivered) && !is_bool($isDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDelivered, true), gettype($isDelivered)), __LINE__);
        }
        if (is_null($isDelivered) || (is_array($isDelivered) && empty($isDelivered))) {
            unset($this->IsDelivered);
        } else {
            $this->IsDelivered = $isDelivered;
        }
        return $this;
    }
    /**
     * Get SalesTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSalesTransactionNumber()
    {
        return isset($this->SalesTransactionNumber) ? $this->SalesTransactionNumber : null;
    }
    /**
     * Set SalesTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $salesTransactionNumber
     * @return \patest\StructType\Merchandise_CustomerOrderFilter
     */
    public function setSalesTransactionNumber($salesTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($salesTransactionNumber) && !(is_int($salesTransactionNumber) || ctype_digit($salesTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salesTransactionNumber, true), gettype($salesTransactionNumber)), __LINE__);
        }
        if (is_null($salesTransactionNumber) || (is_array($salesTransactionNumber) && empty($salesTransactionNumber))) {
            unset($this->SalesTransactionNumber);
        } else {
            $this->SalesTransactionNumber = $salesTransactionNumber;
        }
        return $this;
    }
}
