<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.ClassificationContent StructType
 * @subpackage Structs
 */
class Merchandise_ClassificationContent extends Merchandise_MerchandiseBase
{
    /**
     * The ClassificationNodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClassificationNodeId;
    /**
     * The ContentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContentId;
    /**
     * The ContentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContentType;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * Constructor method for Merchandise.ClassificationContent
     * @uses Merchandise_ClassificationContent::setClassificationNodeId()
     * @uses Merchandise_ClassificationContent::setContentId()
     * @uses Merchandise_ClassificationContent::setContentType()
     * @uses Merchandise_ClassificationContent::setOrdinal()
     * @param string $classificationNodeId
     * @param string $contentId
     * @param string $contentType
     * @param int $ordinal
     */
    public function __construct($classificationNodeId = null, $contentId = null, $contentType = null, $ordinal = null)
    {
        $this
            ->setClassificationNodeId($classificationNodeId)
            ->setContentId($contentId)
            ->setContentType($contentType)
            ->setOrdinal($ordinal);
    }
    /**
     * Get ClassificationNodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClassificationNodeId()
    {
        return isset($this->ClassificationNodeId) ? $this->ClassificationNodeId : null;
    }
    /**
     * Set ClassificationNodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classificationNodeId
     * @return \patest\StructType\Merchandise_ClassificationContent
     */
    public function setClassificationNodeId($classificationNodeId = null)
    {
        // validation for constraint: string
        if (!is_null($classificationNodeId) && !is_string($classificationNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classificationNodeId, true), gettype($classificationNodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($classificationNodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $classificationNodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($classificationNodeId, true)), __LINE__);
        }
        if (is_null($classificationNodeId) || (is_array($classificationNodeId) && empty($classificationNodeId))) {
            unset($this->ClassificationNodeId);
        } else {
            $this->ClassificationNodeId = $classificationNodeId;
        }
        return $this;
    }
    /**
     * Get ContentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentId()
    {
        return isset($this->ContentId) ? $this->ContentId : null;
    }
    /**
     * Set ContentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentId
     * @return \patest\StructType\Merchandise_ClassificationContent
     */
    public function setContentId($contentId = null)
    {
        // validation for constraint: string
        if (!is_null($contentId) && !is_string($contentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentId, true), gettype($contentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contentId, true)), __LINE__);
        }
        if (is_null($contentId) || (is_array($contentId) && empty($contentId))) {
            unset($this->ContentId);
        } else {
            $this->ContentId = $contentId;
        }
        return $this;
    }
    /**
     * Get ContentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentType()
    {
        return isset($this->ContentType) ? $this->ContentType : null;
    }
    /**
     * Set ContentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClassificationContentType::valueIsValid()
     * @uses \patest\EnumType\ClassificationContentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contentType
     * @return \patest\StructType\Merchandise_ClassificationContent
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClassificationContentType::valueIsValid($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClassificationContentType', is_array($contentType) ? implode(', ', $contentType) : var_export($contentType, true), implode(', ', \patest\EnumType\ClassificationContentType::getValidValues())), __LINE__);
        }
        if (is_null($contentType) || (is_array($contentType) && empty($contentType))) {
            unset($this->ContentType);
        } else {
            $this->ContentType = $contentType;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Merchandise_ClassificationContent
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
}
