<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.AttributeTypeValue StructType
 * @subpackage Structs
 */
class Merchandise_AttributeTypeValue extends AnyEntity
{
    /**
     * The TypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeName;
    /**
     * The ValueName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValueName;
    /**
     * Constructor method for Merchandise.AttributeTypeValue
     * @uses Merchandise_AttributeTypeValue::setTypeName()
     * @uses Merchandise_AttributeTypeValue::setValueName()
     * @param string $typeName
     * @param string $valueName
     */
    public function __construct($typeName = null, $valueName = null)
    {
        $this
            ->setTypeName($typeName)
            ->setValueName($valueName);
    }
    /**
     * Get TypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeName()
    {
        return isset($this->TypeName) ? $this->TypeName : null;
    }
    /**
     * Set TypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeName
     * @return \patest\StructType\Merchandise_AttributeTypeValue
     */
    public function setTypeName($typeName = null)
    {
        // validation for constraint: string
        if (!is_null($typeName) && !is_string($typeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeName, true), gettype($typeName)), __LINE__);
        }
        if (is_null($typeName) || (is_array($typeName) && empty($typeName))) {
            unset($this->TypeName);
        } else {
            $this->TypeName = $typeName;
        }
        return $this;
    }
    /**
     * Get ValueName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueName()
    {
        return isset($this->ValueName) ? $this->ValueName : null;
    }
    /**
     * Set ValueName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valueName
     * @return \patest\StructType\Merchandise_AttributeTypeValue
     */
    public function setValueName($valueName = null)
    {
        // validation for constraint: string
        if (!is_null($valueName) && !is_string($valueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueName, true), gettype($valueName)), __LINE__);
        }
        if (is_null($valueName) || (is_array($valueName) && empty($valueName))) {
            unset($this->ValueName);
        } else {
            $this->ValueName = $valueName;
        }
        return $this;
    }
}
