<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.AddOnType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Merchandise.AddOnType
 * @subpackage Structs
 */
class Merchandise_AddOnType extends Merchandise_MerchandiseBase
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AddOnComponents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_AddOnComponent
     */
    public $AddOnComponents;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The HasComponents
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasComponents;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Merchandise_Media
     */
    public $Media;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Price;
    /**
     * The PriceModifierDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceModifierDefinitionId;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The RelatedMerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedMerchandiseId;
    /**
     * The UOMId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UOMId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Merchandise.AddOnType
     * @uses Merchandise_AddOnType::setAclSchemeId()
     * @uses Merchandise_AddOnType::setAddOnComponents()
     * @uses Merchandise_AddOnType::setCrossOrgUnitsAclSchemeId()
     * @uses Merchandise_AddOnType::setDescription()
     * @uses Merchandise_AddOnType::setHasComponents()
     * @uses Merchandise_AddOnType::setIsActive()
     * @uses Merchandise_AddOnType::setMedia()
     * @uses Merchandise_AddOnType::setName()
     * @uses Merchandise_AddOnType::setOrganizationUnitId()
     * @uses Merchandise_AddOnType::setPrice()
     * @uses Merchandise_AddOnType::setPriceModifierDefinitionId()
     * @uses Merchandise_AddOnType::setQuantity()
     * @uses Merchandise_AddOnType::setRelatedMerchandiseId()
     * @uses Merchandise_AddOnType::setUOMId()
     * @uses Merchandise_AddOnType::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param \patest\StructType\RecordSetOfMerchandise_AddOnComponent $addOnComponents
     * @param int $crossOrgUnitsAclSchemeId
     * @param \patest\StructType\GlobalString $description
     * @param bool $hasComponents
     * @param bool $isActive
     * @param \patest\StructType\Merchandise_Media $media
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param \patest\StructType\Money $price
     * @param string $priceModifierDefinitionId
     * @param float $quantity
     * @param string $relatedMerchandiseId
     * @param string $uOMId
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, \patest\StructType\RecordSetOfMerchandise_AddOnComponent $addOnComponents = null, $crossOrgUnitsAclSchemeId = null, \patest\StructType\GlobalString $description = null, $hasComponents = null, $isActive = null, \patest\StructType\Merchandise_Media $media = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, \patest\StructType\Money $price = null, $priceModifierDefinitionId = null, $quantity = null, $relatedMerchandiseId = null, $uOMId = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setAddOnComponents($addOnComponents)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setDescription($description)
            ->setHasComponents($hasComponents)
            ->setIsActive($isActive)
            ->setMedia($media)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPrice($price)
            ->setPriceModifierDefinitionId($priceModifierDefinitionId)
            ->setQuantity($quantity)
            ->setRelatedMerchandiseId($relatedMerchandiseId)
            ->setUOMId($uOMId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AddOnComponents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_AddOnComponent|null
     */
    public function getAddOnComponents()
    {
        return isset($this->AddOnComponents) ? $this->AddOnComponents : null;
    }
    /**
     * Set AddOnComponents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_AddOnComponent $addOnComponents
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setAddOnComponents(\patest\StructType\RecordSetOfMerchandise_AddOnComponent $addOnComponents = null)
    {
        if (is_null($addOnComponents) || (is_array($addOnComponents) && empty($addOnComponents))) {
            unset($this->AddOnComponents);
        } else {
            $this->AddOnComponents = $addOnComponents;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get HasComponents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasComponents()
    {
        return isset($this->HasComponents) ? $this->HasComponents : null;
    }
    /**
     * Set HasComponents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasComponents
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setHasComponents($hasComponents = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasComponents) && !is_bool($hasComponents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasComponents, true), gettype($hasComponents)), __LINE__);
        }
        if (is_null($hasComponents) || (is_array($hasComponents) && empty($hasComponents))) {
            unset($this->HasComponents);
        } else {
            $this->HasComponents = $hasComponents;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Merchandise_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Merchandise_Media $media
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setMedia(\patest\StructType\Merchandise_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $price
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setPrice(\patest\StructType\Money $price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get PriceModifierDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceModifierDefinitionId()
    {
        return isset($this->PriceModifierDefinitionId) ? $this->PriceModifierDefinitionId : null;
    }
    /**
     * Set PriceModifierDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceModifierDefinitionId
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setPriceModifierDefinitionId($priceModifierDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($priceModifierDefinitionId) && !is_string($priceModifierDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceModifierDefinitionId, true), gettype($priceModifierDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceModifierDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceModifierDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceModifierDefinitionId, true)), __LINE__);
        }
        if (is_null($priceModifierDefinitionId) || (is_array($priceModifierDefinitionId) && empty($priceModifierDefinitionId))) {
            unset($this->PriceModifierDefinitionId);
        } else {
            $this->PriceModifierDefinitionId = $priceModifierDefinitionId;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantity
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get RelatedMerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedMerchandiseId()
    {
        return isset($this->RelatedMerchandiseId) ? $this->RelatedMerchandiseId : null;
    }
    /**
     * Set RelatedMerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedMerchandiseId
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setRelatedMerchandiseId($relatedMerchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedMerchandiseId) && !is_string($relatedMerchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedMerchandiseId, true), gettype($relatedMerchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedMerchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedMerchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedMerchandiseId, true)), __LINE__);
        }
        if (is_null($relatedMerchandiseId) || (is_array($relatedMerchandiseId) && empty($relatedMerchandiseId))) {
            unset($this->RelatedMerchandiseId);
        } else {
            $this->RelatedMerchandiseId = $relatedMerchandiseId;
        }
        return $this;
    }
    /**
     * Get UOMId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUOMId()
    {
        return isset($this->UOMId) ? $this->UOMId : null;
    }
    /**
     * Set UOMId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uOMId
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setUOMId($uOMId = null)
    {
        // validation for constraint: string
        if (!is_null($uOMId) && !is_string($uOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uOMId, true), gettype($uOMId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uOMId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uOMId, true)), __LINE__);
        }
        if (is_null($uOMId) || (is_array($uOMId) && empty($uOMId))) {
            unset($this->UOMId);
        } else {
            $this->UOMId = $uOMId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Merchandise_AddOnType
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
