<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchandiseMedia StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MerchandiseMedia
 * @subpackage Structs
 */
class MerchandiseMedia extends AbstractStructBase
{
    /**
     * The BriefOverview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $BriefOverview;
    /**
     * The DetailOverview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DetailOverview;
    /**
     * The ImageMedia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfImageMedia
     */
    public $ImageMedia;
    /**
     * The Incentive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Incentive;
    /**
     * The ReviewUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ReviewUrl;
    /**
     * The TrailerUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TrailerUrl;
    /**
     * Constructor method for MerchandiseMedia
     * @uses MerchandiseMedia::setBriefOverview()
     * @uses MerchandiseMedia::setDetailOverview()
     * @uses MerchandiseMedia::setImageMedia()
     * @uses MerchandiseMedia::setIncentive()
     * @uses MerchandiseMedia::setReviewUrl()
     * @uses MerchandiseMedia::setTrailerUrl()
     * @param \patest\StructType\GlobalString $briefOverview
     * @param \patest\StructType\GlobalString $detailOverview
     * @param \patest\ArrayType\ArrayOfImageMedia $imageMedia
     * @param \patest\StructType\GlobalString $incentive
     * @param \patest\StructType\GlobalString $reviewUrl
     * @param \patest\StructType\GlobalString $trailerUrl
     */
    public function __construct(\patest\StructType\GlobalString $briefOverview = null, \patest\StructType\GlobalString $detailOverview = null, \patest\ArrayType\ArrayOfImageMedia $imageMedia = null, \patest\StructType\GlobalString $incentive = null, \patest\StructType\GlobalString $reviewUrl = null, \patest\StructType\GlobalString $trailerUrl = null)
    {
        $this
            ->setBriefOverview($briefOverview)
            ->setDetailOverview($detailOverview)
            ->setImageMedia($imageMedia)
            ->setIncentive($incentive)
            ->setReviewUrl($reviewUrl)
            ->setTrailerUrl($trailerUrl);
    }
    /**
     * Get BriefOverview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBriefOverview()
    {
        return isset($this->BriefOverview) ? $this->BriefOverview : null;
    }
    /**
     * Set BriefOverview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $briefOverview
     * @return \patest\StructType\MerchandiseMedia
     */
    public function setBriefOverview(\patest\StructType\GlobalString $briefOverview = null)
    {
        if (is_null($briefOverview) || (is_array($briefOverview) && empty($briefOverview))) {
            unset($this->BriefOverview);
        } else {
            $this->BriefOverview = $briefOverview;
        }
        return $this;
    }
    /**
     * Get DetailOverview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDetailOverview()
    {
        return isset($this->DetailOverview) ? $this->DetailOverview : null;
    }
    /**
     * Set DetailOverview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $detailOverview
     * @return \patest\StructType\MerchandiseMedia
     */
    public function setDetailOverview(\patest\StructType\GlobalString $detailOverview = null)
    {
        if (is_null($detailOverview) || (is_array($detailOverview) && empty($detailOverview))) {
            unset($this->DetailOverview);
        } else {
            $this->DetailOverview = $detailOverview;
        }
        return $this;
    }
    /**
     * Get ImageMedia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfImageMedia|null
     */
    public function getImageMedia()
    {
        return isset($this->ImageMedia) ? $this->ImageMedia : null;
    }
    /**
     * Set ImageMedia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfImageMedia $imageMedia
     * @return \patest\StructType\MerchandiseMedia
     */
    public function setImageMedia(\patest\ArrayType\ArrayOfImageMedia $imageMedia = null)
    {
        if (is_null($imageMedia) || (is_array($imageMedia) && empty($imageMedia))) {
            unset($this->ImageMedia);
        } else {
            $this->ImageMedia = $imageMedia;
        }
        return $this;
    }
    /**
     * Get Incentive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getIncentive()
    {
        return isset($this->Incentive) ? $this->Incentive : null;
    }
    /**
     * Set Incentive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $incentive
     * @return \patest\StructType\MerchandiseMedia
     */
    public function setIncentive(\patest\StructType\GlobalString $incentive = null)
    {
        if (is_null($incentive) || (is_array($incentive) && empty($incentive))) {
            unset($this->Incentive);
        } else {
            $this->Incentive = $incentive;
        }
        return $this;
    }
    /**
     * Get ReviewUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getReviewUrl()
    {
        return isset($this->ReviewUrl) ? $this->ReviewUrl : null;
    }
    /**
     * Set ReviewUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $reviewUrl
     * @return \patest\StructType\MerchandiseMedia
     */
    public function setReviewUrl(\patest\StructType\GlobalString $reviewUrl = null)
    {
        if (is_null($reviewUrl) || (is_array($reviewUrl) && empty($reviewUrl))) {
            unset($this->ReviewUrl);
        } else {
            $this->ReviewUrl = $reviewUrl;
        }
        return $this;
    }
    /**
     * Get TrailerUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTrailerUrl()
    {
        return isset($this->TrailerUrl) ? $this->TrailerUrl : null;
    }
    /**
     * Set TrailerUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $trailerUrl
     * @return \patest\StructType\MerchandiseMedia
     */
    public function setTrailerUrl(\patest\StructType\GlobalString $trailerUrl = null)
    {
        if (is_null($trailerUrl) || (is_array($trailerUrl) && empty($trailerUrl))) {
            unset($this->TrailerUrl);
        } else {
            $this->TrailerUrl = $trailerUrl;
        }
        return $this;
    }
}
