<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchandiseItemsDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MerchandiseItemsDescription
 * @subpackage Structs
 */
class MerchandiseItemsDescription extends AbstractStructBase
{
    /**
     * The AddOns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfMerchandiseProductItemAddOn
     */
    public $AddOns;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The OrderIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\OrderIdentity
     */
    public $OrderIdentity;
    /**
     * The PricePerUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PricePerUnit;
    /**
     * The PricingKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingKind;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for MerchandiseItemsDescription
     * @uses MerchandiseItemsDescription::setAddOns()
     * @uses MerchandiseItemsDescription::setMerchandiseId()
     * @uses MerchandiseItemsDescription::setOrderIdentity()
     * @uses MerchandiseItemsDescription::setPricePerUnit()
     * @uses MerchandiseItemsDescription::setPricingKind()
     * @uses MerchandiseItemsDescription::setQuantity()
     * @param \patest\ArrayType\ArrayOfMerchandiseProductItemAddOn $addOns
     * @param string $merchandiseId
     * @param \patest\StructType\OrderIdentity $orderIdentity
     * @param float $pricePerUnit
     * @param string $pricingKind
     * @param int $quantity
     */
    public function __construct(\patest\ArrayType\ArrayOfMerchandiseProductItemAddOn $addOns = null, $merchandiseId = null, \patest\StructType\OrderIdentity $orderIdentity = null, $pricePerUnit = null, $pricingKind = null, $quantity = null)
    {
        $this
            ->setAddOns($addOns)
            ->setMerchandiseId($merchandiseId)
            ->setOrderIdentity($orderIdentity)
            ->setPricePerUnit($pricePerUnit)
            ->setPricingKind($pricingKind)
            ->setQuantity($quantity);
    }
    /**
     * Get AddOns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfMerchandiseProductItemAddOn|null
     */
    public function getAddOns()
    {
        return isset($this->AddOns) ? $this->AddOns : null;
    }
    /**
     * Set AddOns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfMerchandiseProductItemAddOn $addOns
     * @return \patest\StructType\MerchandiseItemsDescription
     */
    public function setAddOns(\patest\ArrayType\ArrayOfMerchandiseProductItemAddOn $addOns = null)
    {
        if (is_null($addOns) || (is_array($addOns) && empty($addOns))) {
            unset($this->AddOns);
        } else {
            $this->AddOns = $addOns;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return $this->MerchandiseId;
    }
    /**
     * Set MerchandiseId value
     * @param string $merchandiseId
     * @return \patest\StructType\MerchandiseItemsDescription
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        $this->MerchandiseId = $merchandiseId;
        return $this;
    }
    /**
     * Get OrderIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\OrderIdentity|null
     */
    public function getOrderIdentity()
    {
        return isset($this->OrderIdentity) ? $this->OrderIdentity : null;
    }
    /**
     * Set OrderIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\OrderIdentity $orderIdentity
     * @return \patest\StructType\MerchandiseItemsDescription
     */
    public function setOrderIdentity(\patest\StructType\OrderIdentity $orderIdentity = null)
    {
        if (is_null($orderIdentity) || (is_array($orderIdentity) && empty($orderIdentity))) {
            unset($this->OrderIdentity);
        } else {
            $this->OrderIdentity = $orderIdentity;
        }
        return $this;
    }
    /**
     * Get PricePerUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPricePerUnit()
    {
        return isset($this->PricePerUnit) ? $this->PricePerUnit : null;
    }
    /**
     * Set PricePerUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pricePerUnit
     * @return \patest\StructType\MerchandiseItemsDescription
     */
    public function setPricePerUnit($pricePerUnit = null)
    {
        // validation for constraint: float
        if (!is_null($pricePerUnit) && !(is_float($pricePerUnit) || is_numeric($pricePerUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricePerUnit, true), gettype($pricePerUnit)), __LINE__);
        }
        if (is_null($pricePerUnit) || (is_array($pricePerUnit) && empty($pricePerUnit))) {
            unset($this->PricePerUnit);
        } else {
            $this->PricePerUnit = $pricePerUnit;
        }
        return $this;
    }
    /**
     * Get PricingKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingKind()
    {
        return isset($this->PricingKind) ? $this->PricingKind : null;
    }
    /**
     * Set PricingKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PricingKind::valueIsValid()
     * @uses \patest\EnumType\PricingKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingKind
     * @return \patest\StructType\MerchandiseItemsDescription
     */
    public function setPricingKind($pricingKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PricingKind::valueIsValid($pricingKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PricingKind', is_array($pricingKind) ? implode(', ', $pricingKind) : var_export($pricingKind, true), implode(', ', \patest\EnumType\PricingKind::getValidValues())), __LINE__);
        }
        if (is_null($pricingKind) || (is_array($pricingKind) && empty($pricingKind))) {
            unset($this->PricingKind);
        } else {
            $this->PricingKind = $pricingKind;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \patest\StructType\MerchandiseItemsDescription
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
}
