<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Memcached.Cluster StructType
 * @subpackage Structs
 */
class Memcached_Cluster extends AnyEntity
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Nodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMemcached_Node
     */
    public $Nodes;
    /**
     * The NodesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NodesCount;
    /**
     * The NodesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NodesSummary;
    /**
     * Constructor method for Memcached.Cluster
     * @uses Memcached_Cluster::setName()
     * @uses Memcached_Cluster::setNodes()
     * @uses Memcached_Cluster::setNodesCount()
     * @uses Memcached_Cluster::setNodesSummary()
     * @param string $name
     * @param \patest\StructType\RecordSetOfMemcached_Node $nodes
     * @param int $nodesCount
     * @param string $nodesSummary
     */
    public function __construct($name = null, \patest\StructType\RecordSetOfMemcached_Node $nodes = null, $nodesCount = null, $nodesSummary = null)
    {
        $this
            ->setName($name)
            ->setNodes($nodes)
            ->setNodesCount($nodesCount)
            ->setNodesSummary($nodesSummary);
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Memcached_Cluster
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Nodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMemcached_Node|null
     */
    public function getNodes()
    {
        return isset($this->Nodes) ? $this->Nodes : null;
    }
    /**
     * Set Nodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMemcached_Node $nodes
     * @return \patest\StructType\Memcached_Cluster
     */
    public function setNodes(\patest\StructType\RecordSetOfMemcached_Node $nodes = null)
    {
        if (is_null($nodes) || (is_array($nodes) && empty($nodes))) {
            unset($this->Nodes);
        } else {
            $this->Nodes = $nodes;
        }
        return $this;
    }
    /**
     * Get NodesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNodesCount()
    {
        return isset($this->NodesCount) ? $this->NodesCount : null;
    }
    /**
     * Set NodesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nodesCount
     * @return \patest\StructType\Memcached_Cluster
     */
    public function setNodesCount($nodesCount = null)
    {
        // validation for constraint: int
        if (!is_null($nodesCount) && !(is_int($nodesCount) || ctype_digit($nodesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nodesCount, true), gettype($nodesCount)), __LINE__);
        }
        if (is_null($nodesCount) || (is_array($nodesCount) && empty($nodesCount))) {
            unset($this->NodesCount);
        } else {
            $this->NodesCount = $nodesCount;
        }
        return $this;
    }
    /**
     * Get NodesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNodesSummary()
    {
        return isset($this->NodesSummary) ? $this->NodesSummary : null;
    }
    /**
     * Set NodesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nodesSummary
     * @return \patest\StructType\Memcached_Cluster
     */
    public function setNodesSummary($nodesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($nodesSummary) && !is_string($nodesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nodesSummary, true), gettype($nodesSummary)), __LINE__);
        }
        if (is_null($nodesSummary) || (is_array($nodesSummary) && empty($nodesSummary))) {
            unset($this->NodesSummary);
        } else {
            $this->NodesSummary = $nodesSummary;
        }
        return $this;
    }
}
