<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.MembershipInstanceExtended StructType
 * @subpackage Structs
 */
class Membership_MembershipInstanceExtended extends Membership_MembershipInstance
{
    /**
     * The BackwardTransaction
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BackwardTransaction;
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDate;
    /**
     * The MembershipName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MembershipName;
    /**
     * The OwnerClientName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerClientName;
    /**
     * The PurchaserClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserClientId;
    /**
     * The PurchaserClientName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PurchaserClientName;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Membership.MembershipInstanceExtended
     * @uses Membership_MembershipInstanceExtended::setBackwardTransaction()
     * @uses Membership_MembershipInstanceExtended::setCommitDate()
     * @uses Membership_MembershipInstanceExtended::setMembershipName()
     * @uses Membership_MembershipInstanceExtended::setOwnerClientName()
     * @uses Membership_MembershipInstanceExtended::setPurchaserClientId()
     * @uses Membership_MembershipInstanceExtended::setPurchaserClientName()
     * @uses Membership_MembershipInstanceExtended::setTransactionNumber()
     * @param string $backwardTransaction
     * @param string $commitDate
     * @param \patest\StructType\GlobalString $membershipName
     * @param string $ownerClientName
     * @param string $purchaserClientId
     * @param string $purchaserClientName
     * @param int $transactionNumber
     */
    public function __construct($backwardTransaction = null, $commitDate = null, \patest\StructType\GlobalString $membershipName = null, $ownerClientName = null, $purchaserClientId = null, $purchaserClientName = null, $transactionNumber = null)
    {
        $this
            ->setBackwardTransaction($backwardTransaction)
            ->setCommitDate($commitDate)
            ->setMembershipName($membershipName)
            ->setOwnerClientName($ownerClientName)
            ->setPurchaserClientId($purchaserClientId)
            ->setPurchaserClientName($purchaserClientName)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get BackwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackwardTransaction()
    {
        return isset($this->BackwardTransaction) ? $this->BackwardTransaction : null;
    }
    /**
     * Set BackwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backwardTransaction
     * @return \patest\StructType\Membership_MembershipInstanceExtended
     */
    public function setBackwardTransaction($backwardTransaction = null)
    {
        // validation for constraint: string
        if (!is_null($backwardTransaction) && !is_string($backwardTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backwardTransaction, true), gettype($backwardTransaction)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($backwardTransaction) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $backwardTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($backwardTransaction, true)), __LINE__);
        }
        if (is_null($backwardTransaction) || (is_array($backwardTransaction) && empty($backwardTransaction))) {
            unset($this->BackwardTransaction);
        } else {
            $this->BackwardTransaction = $backwardTransaction;
        }
        return $this;
    }
    /**
     * Get CommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDate()
    {
        return isset($this->CommitDate) ? $this->CommitDate : null;
    }
    /**
     * Set CommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDate
     * @return \patest\StructType\Membership_MembershipInstanceExtended
     */
    public function setCommitDate($commitDate = null)
    {
        // validation for constraint: string
        if (!is_null($commitDate) && !is_string($commitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDate, true), gettype($commitDate)), __LINE__);
        }
        if (is_null($commitDate) || (is_array($commitDate) && empty($commitDate))) {
            unset($this->CommitDate);
        } else {
            $this->CommitDate = $commitDate;
        }
        return $this;
    }
    /**
     * Get MembershipName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMembershipName()
    {
        return isset($this->MembershipName) ? $this->MembershipName : null;
    }
    /**
     * Set MembershipName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $membershipName
     * @return \patest\StructType\Membership_MembershipInstanceExtended
     */
    public function setMembershipName(\patest\StructType\GlobalString $membershipName = null)
    {
        if (is_null($membershipName) || (is_array($membershipName) && empty($membershipName))) {
            unset($this->MembershipName);
        } else {
            $this->MembershipName = $membershipName;
        }
        return $this;
    }
    /**
     * Get OwnerClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerClientName()
    {
        return isset($this->OwnerClientName) ? $this->OwnerClientName : null;
    }
    /**
     * Set OwnerClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerClientName
     * @return \patest\StructType\Membership_MembershipInstanceExtended
     */
    public function setOwnerClientName($ownerClientName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerClientName) && !is_string($ownerClientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerClientName, true), gettype($ownerClientName)), __LINE__);
        }
        if (is_null($ownerClientName) || (is_array($ownerClientName) && empty($ownerClientName))) {
            unset($this->OwnerClientName);
        } else {
            $this->OwnerClientName = $ownerClientName;
        }
        return $this;
    }
    /**
     * Get PurchaserClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserClientId()
    {
        return isset($this->PurchaserClientId) ? $this->PurchaserClientId : null;
    }
    /**
     * Set PurchaserClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserClientId
     * @return \patest\StructType\Membership_MembershipInstanceExtended
     */
    public function setPurchaserClientId($purchaserClientId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserClientId) && !is_string($purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserClientId, true), gettype($purchaserClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserClientId, true)), __LINE__);
        }
        if (is_null($purchaserClientId) || (is_array($purchaserClientId) && empty($purchaserClientId))) {
            unset($this->PurchaserClientId);
        } else {
            $this->PurchaserClientId = $purchaserClientId;
        }
        return $this;
    }
    /**
     * Get PurchaserClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserClientName()
    {
        return isset($this->PurchaserClientName) ? $this->PurchaserClientName : null;
    }
    /**
     * Set PurchaserClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserClientName
     * @return \patest\StructType\Membership_MembershipInstanceExtended
     */
    public function setPurchaserClientName($purchaserClientName = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserClientName) && !is_string($purchaserClientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserClientName, true), gettype($purchaserClientName)), __LINE__);
        }
        if (is_null($purchaserClientName) || (is_array($purchaserClientName) && empty($purchaserClientName))) {
            unset($this->PurchaserClientName);
        } else {
            $this->PurchaserClientName = $purchaserClientName;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Membership_MembershipInstanceExtended
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
