<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.MembershipInAction StructType
 * @subpackage Structs
 */
class Membership_MembershipInAction extends Membership_MembershipExtended
{
    /**
     * The CurrentPriceTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CurrentPriceTypeId;
    /**
     * The CurrentSchemeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CurrentSchemeId;
    /**
     * The CurrentSchemeLevelPriority
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CurrentSchemeLevelPriority;
    /**
     * The IsSelected
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSelected;
    /**
     * The NewDefinitionId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewDefinitionId;
    /**
     * Constructor method for Membership.MembershipInAction
     * @uses Membership_MembershipInAction::setCurrentPriceTypeId()
     * @uses Membership_MembershipInAction::setCurrentSchemeId()
     * @uses Membership_MembershipInAction::setCurrentSchemeLevelPriority()
     * @uses Membership_MembershipInAction::setIsSelected()
     * @uses Membership_MembershipInAction::setNewDefinitionId()
     * @param string $currentPriceTypeId
     * @param string $currentSchemeId
     * @param int $currentSchemeLevelPriority
     * @param bool $isSelected
     * @param string $newDefinitionId
     */
    public function __construct($currentPriceTypeId = null, $currentSchemeId = null, $currentSchemeLevelPriority = null, $isSelected = null, $newDefinitionId = null)
    {
        $this
            ->setCurrentPriceTypeId($currentPriceTypeId)
            ->setCurrentSchemeId($currentSchemeId)
            ->setCurrentSchemeLevelPriority($currentSchemeLevelPriority)
            ->setIsSelected($isSelected)
            ->setNewDefinitionId($newDefinitionId);
    }
    /**
     * Get CurrentPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentPriceTypeId()
    {
        return isset($this->CurrentPriceTypeId) ? $this->CurrentPriceTypeId : null;
    }
    /**
     * Set CurrentPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentPriceTypeId
     * @return \patest\StructType\Membership_MembershipInAction
     */
    public function setCurrentPriceTypeId($currentPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($currentPriceTypeId) && !is_string($currentPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentPriceTypeId, true), gettype($currentPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($currentPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $currentPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($currentPriceTypeId, true)), __LINE__);
        }
        if (is_null($currentPriceTypeId) || (is_array($currentPriceTypeId) && empty($currentPriceTypeId))) {
            unset($this->CurrentPriceTypeId);
        } else {
            $this->CurrentPriceTypeId = $currentPriceTypeId;
        }
        return $this;
    }
    /**
     * Get CurrentSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentSchemeId()
    {
        return isset($this->CurrentSchemeId) ? $this->CurrentSchemeId : null;
    }
    /**
     * Set CurrentSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentSchemeId
     * @return \patest\StructType\Membership_MembershipInAction
     */
    public function setCurrentSchemeId($currentSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($currentSchemeId) && !is_string($currentSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentSchemeId, true), gettype($currentSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($currentSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $currentSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($currentSchemeId, true)), __LINE__);
        }
        if (is_null($currentSchemeId) || (is_array($currentSchemeId) && empty($currentSchemeId))) {
            unset($this->CurrentSchemeId);
        } else {
            $this->CurrentSchemeId = $currentSchemeId;
        }
        return $this;
    }
    /**
     * Get CurrentSchemeLevelPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCurrentSchemeLevelPriority()
    {
        return isset($this->CurrentSchemeLevelPriority) ? $this->CurrentSchemeLevelPriority : null;
    }
    /**
     * Set CurrentSchemeLevelPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $currentSchemeLevelPriority
     * @return \patest\StructType\Membership_MembershipInAction
     */
    public function setCurrentSchemeLevelPriority($currentSchemeLevelPriority = null)
    {
        // validation for constraint: int
        if (!is_null($currentSchemeLevelPriority) && !(is_int($currentSchemeLevelPriority) || ctype_digit($currentSchemeLevelPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentSchemeLevelPriority, true), gettype($currentSchemeLevelPriority)), __LINE__);
        }
        if (is_null($currentSchemeLevelPriority) || (is_array($currentSchemeLevelPriority) && empty($currentSchemeLevelPriority))) {
            unset($this->CurrentSchemeLevelPriority);
        } else {
            $this->CurrentSchemeLevelPriority = $currentSchemeLevelPriority;
        }
        return $this;
    }
    /**
     * Get IsSelected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSelected()
    {
        return isset($this->IsSelected) ? $this->IsSelected : null;
    }
    /**
     * Set IsSelected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSelected
     * @return \patest\StructType\Membership_MembershipInAction
     */
    public function setIsSelected($isSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelected) && !is_bool($isSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelected, true), gettype($isSelected)), __LINE__);
        }
        if (is_null($isSelected) || (is_array($isSelected) && empty($isSelected))) {
            unset($this->IsSelected);
        } else {
            $this->IsSelected = $isSelected;
        }
        return $this;
    }
    /**
     * Get NewDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewDefinitionId()
    {
        return isset($this->NewDefinitionId) ? $this->NewDefinitionId : null;
    }
    /**
     * Set NewDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newDefinitionId
     * @return \patest\StructType\Membership_MembershipInAction
     */
    public function setNewDefinitionId($newDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($newDefinitionId) && !is_string($newDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newDefinitionId, true), gettype($newDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newDefinitionId, true)), __LINE__);
        }
        if (is_null($newDefinitionId) || (is_array($newDefinitionId) && empty($newDefinitionId))) {
            unset($this->NewDefinitionId);
        } else {
            $this->NewDefinitionId = $newDefinitionId;
        }
        return $this;
    }
}
