<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.MembershipDefinition StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Membership.MembershipDefinition
 * @subpackage Structs
 */
class Membership_MembershipDefinition extends Membership_Base
{
    /**
     * The AccessControlData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessControl_EntityAccessControlData
     */
    public $AccessControlData;
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AllianceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AllianceId;
    /**
     * The AllianceName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AllianceName;
    /**
     * The AvailableForDisplayFrom
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForDisplayFrom;
    /**
     * The AvailableForDisplayUntil
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForDisplayUntil;
    /**
     * The AvailableForSaleFrom
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForSaleFrom;
    /**
     * The AvailableForSaleUntil
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvailableForSaleUntil;
    /**
     * The BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized;
    /**
     * The CanAutoRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanAutoRenew;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The DefaultBenefitPackage
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultBenefitPackage;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The IsAccessCardNotDedicated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAccessCardNotDedicated;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAutoRenewableByScheduledJob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoRenewableByScheduledJob;
    /**
     * The IsAvailableForDisplay
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForDisplay;
    /**
     * The IsAvailableForSale
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableForSale;
    /**
     * The IsFreezeAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFreezeAllowed;
    /**
     * The JointMembershipAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $JointMembershipAvailable;
    /**
     * The JointMembershipPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $JointMembershipPlanId;
    /**
     * The JointMembershipPrintingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointMembershipPrintingOption;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The MaxEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MaxEndDate;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Membership_Media
     */
    public $Media;
    /**
     * The MinStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinStartDate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NumberCounterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NumberCounterId;
    /**
     * The NumberPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberPrefix;
    /**
     * The NumberSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberSize;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PriceTypesBenefits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMembership_PriceTypeBenefitPair
     */
    public $PriceTypesBenefits;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The SaleLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SaleLimit;
    /**
     * The SchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeId;
    /**
     * The SchemeLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeLevelId;
    /**
     * The SchemeLevelName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SchemeLevelName;
    /**
     * The SchemeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SchemeName;
    /**
     * The ShowTimeGenerateNfcPass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowTimeGenerateNfcPass;
    /**
     * The TargetAutoRenewalMembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetAutoRenewalMembershipDefinitionId;
    /**
     * The UseDefaultCounter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseDefaultCounter;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Membership.MembershipDefinition
     * @uses Membership_MembershipDefinition::setAccessControlData()
     * @uses Membership_MembershipDefinition::setAclSchemeId()
     * @uses Membership_MembershipDefinition::setAllianceId()
     * @uses Membership_MembershipDefinition::setAllianceName()
     * @uses Membership_MembershipDefinition::setAvailableForDisplayFrom()
     * @uses Membership_MembershipDefinition::setAvailableForDisplayUntil()
     * @uses Membership_MembershipDefinition::setAvailableForSaleFrom()
     * @uses Membership_MembershipDefinition::setAvailableForSaleUntil()
     * @uses Membership_MembershipDefinition::setBenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized()
     * @uses Membership_MembershipDefinition::setCanAutoRenew()
     * @uses Membership_MembershipDefinition::setCreationDate()
     * @uses Membership_MembershipDefinition::setCrossOrgUnitsAclSchemeId()
     * @uses Membership_MembershipDefinition::setDefaultBenefitPackage()
     * @uses Membership_MembershipDefinition::setDescription()
     * @uses Membership_MembershipDefinition::setIsAccessCardNotDedicated()
     * @uses Membership_MembershipDefinition::setIsActive()
     * @uses Membership_MembershipDefinition::setIsAutoRenewableByScheduledJob()
     * @uses Membership_MembershipDefinition::setIsAvailableForDisplay()
     * @uses Membership_MembershipDefinition::setIsAvailableForSale()
     * @uses Membership_MembershipDefinition::setIsFreezeAllowed()
     * @uses Membership_MembershipDefinition::setJointMembershipAvailable()
     * @uses Membership_MembershipDefinition::setJointMembershipPlanId()
     * @uses Membership_MembershipDefinition::setJointMembershipPrintingOption()
     * @uses Membership_MembershipDefinition::setLastUpdateDateTime()
     * @uses Membership_MembershipDefinition::setLedgerId()
     * @uses Membership_MembershipDefinition::setMaxEndDate()
     * @uses Membership_MembershipDefinition::setMedia()
     * @uses Membership_MembershipDefinition::setMinStartDate()
     * @uses Membership_MembershipDefinition::setName()
     * @uses Membership_MembershipDefinition::setNumberCounterId()
     * @uses Membership_MembershipDefinition::setNumberPrefix()
     * @uses Membership_MembershipDefinition::setNumberSize()
     * @uses Membership_MembershipDefinition::setOrganizationUnitId()
     * @uses Membership_MembershipDefinition::setPriceTypesBenefits()
     * @uses Membership_MembershipDefinition::setPriority()
     * @uses Membership_MembershipDefinition::setProjectIdentifierId()
     * @uses Membership_MembershipDefinition::setSaleLimit()
     * @uses Membership_MembershipDefinition::setSchemeId()
     * @uses Membership_MembershipDefinition::setSchemeLevelId()
     * @uses Membership_MembershipDefinition::setSchemeLevelName()
     * @uses Membership_MembershipDefinition::setSchemeName()
     * @uses Membership_MembershipDefinition::setShowTimeGenerateNfcPass()
     * @uses Membership_MembershipDefinition::setTargetAutoRenewalMembershipDefinitionId()
     * @uses Membership_MembershipDefinition::setUseDefaultCounter()
     * @uses Membership_MembershipDefinition::setVisibleBySubordinates()
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @param int $aclSchemeId
     * @param string $allianceId
     * @param \patest\StructType\GlobalString $allianceName
     * @param string $availableForDisplayFrom
     * @param string $availableForDisplayUntil
     * @param string $availableForSaleFrom
     * @param string $availableForSaleUntil
     * @param bool $benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized
     * @param bool $canAutoRenew
     * @param string $creationDate
     * @param int $crossOrgUnitsAclSchemeId
     * @param string $defaultBenefitPackage
     * @param \patest\StructType\GlobalString $description
     * @param bool $isAccessCardNotDedicated
     * @param bool $isActive
     * @param bool $isAutoRenewableByScheduledJob
     * @param bool $isAvailableForDisplay
     * @param bool $isAvailableForSale
     * @param bool $isFreezeAllowed
     * @param bool $jointMembershipAvailable
     * @param string $jointMembershipPlanId
     * @param string $jointMembershipPrintingOption
     * @param string $lastUpdateDateTime
     * @param string $ledgerId
     * @param string $maxEndDate
     * @param \patest\StructType\Membership_Media $media
     * @param string $minStartDate
     * @param \patest\StructType\GlobalString $name
     * @param string $numberCounterId
     * @param string $numberPrefix
     * @param int $numberSize
     * @param string $organizationUnitId
     * @param \patest\StructType\RecordSetOfMembership_PriceTypeBenefitPair $priceTypesBenefits
     * @param int $priority
     * @param string $projectIdentifierId
     * @param int $saleLimit
     * @param string $schemeId
     * @param string $schemeLevelId
     * @param \patest\StructType\GlobalString $schemeLevelName
     * @param \patest\StructType\GlobalString $schemeName
     * @param bool $showTimeGenerateNfcPass
     * @param string $targetAutoRenewalMembershipDefinitionId
     * @param bool $useDefaultCounter
     * @param bool $visibleBySubordinates
     */
    public function __construct(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null, $aclSchemeId = null, $allianceId = null, \patest\StructType\GlobalString $allianceName = null, $availableForDisplayFrom = null, $availableForDisplayUntil = null, $availableForSaleFrom = null, $availableForSaleUntil = null, $benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized = null, $canAutoRenew = null, $creationDate = null, $crossOrgUnitsAclSchemeId = null, $defaultBenefitPackage = null, \patest\StructType\GlobalString $description = null, $isAccessCardNotDedicated = null, $isActive = null, $isAutoRenewableByScheduledJob = null, $isAvailableForDisplay = null, $isAvailableForSale = null, $isFreezeAllowed = null, $jointMembershipAvailable = null, $jointMembershipPlanId = null, $jointMembershipPrintingOption = null, $lastUpdateDateTime = null, $ledgerId = null, $maxEndDate = null, \patest\StructType\Membership_Media $media = null, $minStartDate = null, \patest\StructType\GlobalString $name = null, $numberCounterId = null, $numberPrefix = null, $numberSize = null, $organizationUnitId = null, \patest\StructType\RecordSetOfMembership_PriceTypeBenefitPair $priceTypesBenefits = null, $priority = null, $projectIdentifierId = null, $saleLimit = null, $schemeId = null, $schemeLevelId = null, \patest\StructType\GlobalString $schemeLevelName = null, \patest\StructType\GlobalString $schemeName = null, $showTimeGenerateNfcPass = null, $targetAutoRenewalMembershipDefinitionId = null, $useDefaultCounter = null, $visibleBySubordinates = null)
    {
        $this
            ->setAccessControlData($accessControlData)
            ->setAclSchemeId($aclSchemeId)
            ->setAllianceId($allianceId)
            ->setAllianceName($allianceName)
            ->setAvailableForDisplayFrom($availableForDisplayFrom)
            ->setAvailableForDisplayUntil($availableForDisplayUntil)
            ->setAvailableForSaleFrom($availableForSaleFrom)
            ->setAvailableForSaleUntil($availableForSaleUntil)
            ->setBenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized)
            ->setCanAutoRenew($canAutoRenew)
            ->setCreationDate($creationDate)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setDefaultBenefitPackage($defaultBenefitPackage)
            ->setDescription($description)
            ->setIsAccessCardNotDedicated($isAccessCardNotDedicated)
            ->setIsActive($isActive)
            ->setIsAutoRenewableByScheduledJob($isAutoRenewableByScheduledJob)
            ->setIsAvailableForDisplay($isAvailableForDisplay)
            ->setIsAvailableForSale($isAvailableForSale)
            ->setIsFreezeAllowed($isFreezeAllowed)
            ->setJointMembershipAvailable($jointMembershipAvailable)
            ->setJointMembershipPlanId($jointMembershipPlanId)
            ->setJointMembershipPrintingOption($jointMembershipPrintingOption)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setLedgerId($ledgerId)
            ->setMaxEndDate($maxEndDate)
            ->setMedia($media)
            ->setMinStartDate($minStartDate)
            ->setName($name)
            ->setNumberCounterId($numberCounterId)
            ->setNumberPrefix($numberPrefix)
            ->setNumberSize($numberSize)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPriceTypesBenefits($priceTypesBenefits)
            ->setPriority($priority)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setSaleLimit($saleLimit)
            ->setSchemeId($schemeId)
            ->setSchemeLevelId($schemeLevelId)
            ->setSchemeLevelName($schemeLevelName)
            ->setSchemeName($schemeName)
            ->setShowTimeGenerateNfcPass($showTimeGenerateNfcPass)
            ->setTargetAutoRenewalMembershipDefinitionId($targetAutoRenewalMembershipDefinitionId)
            ->setUseDefaultCounter($useDefaultCounter)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AccessControlData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessControl_EntityAccessControlData|null
     */
    public function getAccessControlData()
    {
        return isset($this->AccessControlData) ? $this->AccessControlData : null;
    }
    /**
     * Set AccessControlData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setAccessControlData(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null)
    {
        if (is_null($accessControlData) || (is_array($accessControlData) && empty($accessControlData))) {
            unset($this->AccessControlData);
        } else {
            $this->AccessControlData = $accessControlData;
        }
        return $this;
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AllianceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllianceId()
    {
        return isset($this->AllianceId) ? $this->AllianceId : null;
    }
    /**
     * Set AllianceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allianceId
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setAllianceId($allianceId = null)
    {
        // validation for constraint: string
        if (!is_null($allianceId) && !is_string($allianceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allianceId, true), gettype($allianceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($allianceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $allianceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($allianceId, true)), __LINE__);
        }
        if (is_null($allianceId) || (is_array($allianceId) && empty($allianceId))) {
            unset($this->AllianceId);
        } else {
            $this->AllianceId = $allianceId;
        }
        return $this;
    }
    /**
     * Get AllianceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAllianceName()
    {
        return isset($this->AllianceName) ? $this->AllianceName : null;
    }
    /**
     * Set AllianceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $allianceName
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setAllianceName(\patest\StructType\GlobalString $allianceName = null)
    {
        if (is_null($allianceName) || (is_array($allianceName) && empty($allianceName))) {
            unset($this->AllianceName);
        } else {
            $this->AllianceName = $allianceName;
        }
        return $this;
    }
    /**
     * Get AvailableForDisplayFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForDisplayFrom()
    {
        return isset($this->AvailableForDisplayFrom) ? $this->AvailableForDisplayFrom : null;
    }
    /**
     * Set AvailableForDisplayFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForDisplayFrom
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setAvailableForDisplayFrom($availableForDisplayFrom = null)
    {
        // validation for constraint: string
        if (!is_null($availableForDisplayFrom) && !is_string($availableForDisplayFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForDisplayFrom, true), gettype($availableForDisplayFrom)), __LINE__);
        }
        if (is_null($availableForDisplayFrom) || (is_array($availableForDisplayFrom) && empty($availableForDisplayFrom))) {
            unset($this->AvailableForDisplayFrom);
        } else {
            $this->AvailableForDisplayFrom = $availableForDisplayFrom;
        }
        return $this;
    }
    /**
     * Get AvailableForDisplayUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForDisplayUntil()
    {
        return isset($this->AvailableForDisplayUntil) ? $this->AvailableForDisplayUntil : null;
    }
    /**
     * Set AvailableForDisplayUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForDisplayUntil
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setAvailableForDisplayUntil($availableForDisplayUntil = null)
    {
        // validation for constraint: string
        if (!is_null($availableForDisplayUntil) && !is_string($availableForDisplayUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForDisplayUntil, true), gettype($availableForDisplayUntil)), __LINE__);
        }
        if (is_null($availableForDisplayUntil) || (is_array($availableForDisplayUntil) && empty($availableForDisplayUntil))) {
            unset($this->AvailableForDisplayUntil);
        } else {
            $this->AvailableForDisplayUntil = $availableForDisplayUntil;
        }
        return $this;
    }
    /**
     * Get AvailableForSaleFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForSaleFrom()
    {
        return isset($this->AvailableForSaleFrom) ? $this->AvailableForSaleFrom : null;
    }
    /**
     * Set AvailableForSaleFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForSaleFrom
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setAvailableForSaleFrom($availableForSaleFrom = null)
    {
        // validation for constraint: string
        if (!is_null($availableForSaleFrom) && !is_string($availableForSaleFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForSaleFrom, true), gettype($availableForSaleFrom)), __LINE__);
        }
        if (is_null($availableForSaleFrom) || (is_array($availableForSaleFrom) && empty($availableForSaleFrom))) {
            unset($this->AvailableForSaleFrom);
        } else {
            $this->AvailableForSaleFrom = $availableForSaleFrom;
        }
        return $this;
    }
    /**
     * Get AvailableForSaleUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableForSaleUntil()
    {
        return isset($this->AvailableForSaleUntil) ? $this->AvailableForSaleUntil : null;
    }
    /**
     * Set AvailableForSaleUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableForSaleUntil
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setAvailableForSaleUntil($availableForSaleUntil = null)
    {
        // validation for constraint: string
        if (!is_null($availableForSaleUntil) && !is_string($availableForSaleUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableForSaleUntil, true), gettype($availableForSaleUntil)), __LINE__);
        }
        if (is_null($availableForSaleUntil) || (is_array($availableForSaleUntil) && empty($availableForSaleUntil))) {
            unset($this->AvailableForSaleUntil);
        } else {
            $this->AvailableForSaleUntil = $availableForSaleUntil;
        }
        return $this;
    }
    /**
     * Get BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized()
    {
        return isset($this->BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized) ? $this->BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized : null;
    }
    /**
     * Set BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setBenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized = null)
    {
        // validation for constraint: boolean
        if (!is_null($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized) && !is_bool($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized, true), gettype($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized)), __LINE__);
        }
        if (is_null($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized) || (is_array($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized) && empty($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized))) {
            unset($this->BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized);
        } else {
            $this->BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized = $benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized;
        }
        return $this;
    }
    /**
     * Get CanAutoRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanAutoRenew()
    {
        return isset($this->CanAutoRenew) ? $this->CanAutoRenew : null;
    }
    /**
     * Set CanAutoRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canAutoRenew
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setCanAutoRenew($canAutoRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($canAutoRenew) && !is_bool($canAutoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canAutoRenew, true), gettype($canAutoRenew)), __LINE__);
        }
        if (is_null($canAutoRenew) || (is_array($canAutoRenew) && empty($canAutoRenew))) {
            unset($this->CanAutoRenew);
        } else {
            $this->CanAutoRenew = $canAutoRenew;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get DefaultBenefitPackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultBenefitPackage()
    {
        return isset($this->DefaultBenefitPackage) ? $this->DefaultBenefitPackage : null;
    }
    /**
     * Set DefaultBenefitPackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultBenefitPackage
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setDefaultBenefitPackage($defaultBenefitPackage = null)
    {
        // validation for constraint: string
        if (!is_null($defaultBenefitPackage) && !is_string($defaultBenefitPackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultBenefitPackage, true), gettype($defaultBenefitPackage)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultBenefitPackage) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultBenefitPackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultBenefitPackage, true)), __LINE__);
        }
        if (is_null($defaultBenefitPackage) || (is_array($defaultBenefitPackage) && empty($defaultBenefitPackage))) {
            unset($this->DefaultBenefitPackage);
        } else {
            $this->DefaultBenefitPackage = $defaultBenefitPackage;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsAccessCardNotDedicated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAccessCardNotDedicated()
    {
        return isset($this->IsAccessCardNotDedicated) ? $this->IsAccessCardNotDedicated : null;
    }
    /**
     * Set IsAccessCardNotDedicated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAccessCardNotDedicated
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setIsAccessCardNotDedicated($isAccessCardNotDedicated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccessCardNotDedicated) && !is_bool($isAccessCardNotDedicated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccessCardNotDedicated, true), gettype($isAccessCardNotDedicated)), __LINE__);
        }
        if (is_null($isAccessCardNotDedicated) || (is_array($isAccessCardNotDedicated) && empty($isAccessCardNotDedicated))) {
            unset($this->IsAccessCardNotDedicated);
        } else {
            $this->IsAccessCardNotDedicated = $isAccessCardNotDedicated;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsAutoRenewableByScheduledJob value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoRenewableByScheduledJob()
    {
        return isset($this->IsAutoRenewableByScheduledJob) ? $this->IsAutoRenewableByScheduledJob : null;
    }
    /**
     * Set IsAutoRenewableByScheduledJob value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoRenewableByScheduledJob
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setIsAutoRenewableByScheduledJob($isAutoRenewableByScheduledJob = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoRenewableByScheduledJob) && !is_bool($isAutoRenewableByScheduledJob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoRenewableByScheduledJob, true), gettype($isAutoRenewableByScheduledJob)), __LINE__);
        }
        if (is_null($isAutoRenewableByScheduledJob) || (is_array($isAutoRenewableByScheduledJob) && empty($isAutoRenewableByScheduledJob))) {
            unset($this->IsAutoRenewableByScheduledJob);
        } else {
            $this->IsAutoRenewableByScheduledJob = $isAutoRenewableByScheduledJob;
        }
        return $this;
    }
    /**
     * Get IsAvailableForDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForDisplay()
    {
        return isset($this->IsAvailableForDisplay) ? $this->IsAvailableForDisplay : null;
    }
    /**
     * Set IsAvailableForDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForDisplay
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setIsAvailableForDisplay($isAvailableForDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForDisplay) && !is_bool($isAvailableForDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForDisplay, true), gettype($isAvailableForDisplay)), __LINE__);
        }
        if (is_null($isAvailableForDisplay) || (is_array($isAvailableForDisplay) && empty($isAvailableForDisplay))) {
            unset($this->IsAvailableForDisplay);
        } else {
            $this->IsAvailableForDisplay = $isAvailableForDisplay;
        }
        return $this;
    }
    /**
     * Get IsAvailableForSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableForSale()
    {
        return isset($this->IsAvailableForSale) ? $this->IsAvailableForSale : null;
    }
    /**
     * Set IsAvailableForSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableForSale
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setIsAvailableForSale($isAvailableForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForSale) && !is_bool($isAvailableForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForSale, true), gettype($isAvailableForSale)), __LINE__);
        }
        if (is_null($isAvailableForSale) || (is_array($isAvailableForSale) && empty($isAvailableForSale))) {
            unset($this->IsAvailableForSale);
        } else {
            $this->IsAvailableForSale = $isAvailableForSale;
        }
        return $this;
    }
    /**
     * Get IsFreezeAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFreezeAllowed()
    {
        return isset($this->IsFreezeAllowed) ? $this->IsFreezeAllowed : null;
    }
    /**
     * Set IsFreezeAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFreezeAllowed
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setIsFreezeAllowed($isFreezeAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFreezeAllowed) && !is_bool($isFreezeAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFreezeAllowed, true), gettype($isFreezeAllowed)), __LINE__);
        }
        if (is_null($isFreezeAllowed) || (is_array($isFreezeAllowed) && empty($isFreezeAllowed))) {
            unset($this->IsFreezeAllowed);
        } else {
            $this->IsFreezeAllowed = $isFreezeAllowed;
        }
        return $this;
    }
    /**
     * Get JointMembershipAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getJointMembershipAvailable()
    {
        return isset($this->JointMembershipAvailable) ? $this->JointMembershipAvailable : null;
    }
    /**
     * Set JointMembershipAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $jointMembershipAvailable
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setJointMembershipAvailable($jointMembershipAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($jointMembershipAvailable) && !is_bool($jointMembershipAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($jointMembershipAvailable, true), gettype($jointMembershipAvailable)), __LINE__);
        }
        if (is_null($jointMembershipAvailable) || (is_array($jointMembershipAvailable) && empty($jointMembershipAvailable))) {
            unset($this->JointMembershipAvailable);
        } else {
            $this->JointMembershipAvailable = $jointMembershipAvailable;
        }
        return $this;
    }
    /**
     * Get JointMembershipPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointMembershipPlanId()
    {
        return isset($this->JointMembershipPlanId) ? $this->JointMembershipPlanId : null;
    }
    /**
     * Set JointMembershipPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jointMembershipPlanId
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setJointMembershipPlanId($jointMembershipPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($jointMembershipPlanId) && !is_string($jointMembershipPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jointMembershipPlanId, true), gettype($jointMembershipPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($jointMembershipPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $jointMembershipPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($jointMembershipPlanId, true)), __LINE__);
        }
        if (is_null($jointMembershipPlanId) || (is_array($jointMembershipPlanId) && empty($jointMembershipPlanId))) {
            unset($this->JointMembershipPlanId);
        } else {
            $this->JointMembershipPlanId = $jointMembershipPlanId;
        }
        return $this;
    }
    /**
     * Get JointMembershipPrintingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointMembershipPrintingOption()
    {
        return isset($this->JointMembershipPrintingOption) ? $this->JointMembershipPrintingOption : null;
    }
    /**
     * Set JointMembershipPrintingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JointMembershipPrintingOption::valueIsValid()
     * @uses \patest\EnumType\JointMembershipPrintingOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $jointMembershipPrintingOption
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setJointMembershipPrintingOption($jointMembershipPrintingOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JointMembershipPrintingOption::valueIsValid($jointMembershipPrintingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JointMembershipPrintingOption', is_array($jointMembershipPrintingOption) ? implode(', ', $jointMembershipPrintingOption) : var_export($jointMembershipPrintingOption, true), implode(', ', \patest\EnumType\JointMembershipPrintingOption::getValidValues())), __LINE__);
        }
        if (is_null($jointMembershipPrintingOption) || (is_array($jointMembershipPrintingOption) && empty($jointMembershipPrintingOption))) {
            unset($this->JointMembershipPrintingOption);
        } else {
            $this->JointMembershipPrintingOption = $jointMembershipPrintingOption;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get MaxEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxEndDate()
    {
        return isset($this->MaxEndDate) ? $this->MaxEndDate : null;
    }
    /**
     * Set MaxEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maxEndDate
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setMaxEndDate($maxEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxEndDate) && !is_string($maxEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxEndDate, true), gettype($maxEndDate)), __LINE__);
        }
        if (is_null($maxEndDate) || (is_array($maxEndDate) && empty($maxEndDate))) {
            unset($this->MaxEndDate);
        } else {
            $this->MaxEndDate = $maxEndDate;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Membership_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Membership_Media $media
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setMedia(\patest\StructType\Membership_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get MinStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinStartDate()
    {
        return isset($this->MinStartDate) ? $this->MinStartDate : null;
    }
    /**
     * Set MinStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minStartDate
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setMinStartDate($minStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($minStartDate) && !is_string($minStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minStartDate, true), gettype($minStartDate)), __LINE__);
        }
        if (is_null($minStartDate) || (is_array($minStartDate) && empty($minStartDate))) {
            unset($this->MinStartDate);
        } else {
            $this->MinStartDate = $minStartDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumberCounterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberCounterId()
    {
        return isset($this->NumberCounterId) ? $this->NumberCounterId : null;
    }
    /**
     * Set NumberCounterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberCounterId
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setNumberCounterId($numberCounterId = null)
    {
        // validation for constraint: string
        if (!is_null($numberCounterId) && !is_string($numberCounterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberCounterId, true), gettype($numberCounterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($numberCounterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $numberCounterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($numberCounterId, true)), __LINE__);
        }
        if (is_null($numberCounterId) || (is_array($numberCounterId) && empty($numberCounterId))) {
            unset($this->NumberCounterId);
        } else {
            $this->NumberCounterId = $numberCounterId;
        }
        return $this;
    }
    /**
     * Get NumberPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberPrefix()
    {
        return isset($this->NumberPrefix) ? $this->NumberPrefix : null;
    }
    /**
     * Set NumberPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberPrefix
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setNumberPrefix($numberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($numberPrefix) && !is_string($numberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberPrefix, true), gettype($numberPrefix)), __LINE__);
        }
        if (is_null($numberPrefix) || (is_array($numberPrefix) && empty($numberPrefix))) {
            unset($this->NumberPrefix);
        } else {
            $this->NumberPrefix = $numberPrefix;
        }
        return $this;
    }
    /**
     * Get NumberSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberSize()
    {
        return isset($this->NumberSize) ? $this->NumberSize : null;
    }
    /**
     * Set NumberSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberSize
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setNumberSize($numberSize = null)
    {
        // validation for constraint: int
        if (!is_null($numberSize) && !(is_int($numberSize) || ctype_digit($numberSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberSize, true), gettype($numberSize)), __LINE__);
        }
        if (is_null($numberSize) || (is_array($numberSize) && empty($numberSize))) {
            unset($this->NumberSize);
        } else {
            $this->NumberSize = $numberSize;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PriceTypesBenefits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMembership_PriceTypeBenefitPair|null
     */
    public function getPriceTypesBenefits()
    {
        return isset($this->PriceTypesBenefits) ? $this->PriceTypesBenefits : null;
    }
    /**
     * Set PriceTypesBenefits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMembership_PriceTypeBenefitPair $priceTypesBenefits
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setPriceTypesBenefits(\patest\StructType\RecordSetOfMembership_PriceTypeBenefitPair $priceTypesBenefits = null)
    {
        if (is_null($priceTypesBenefits) || (is_array($priceTypesBenefits) && empty($priceTypesBenefits))) {
            unset($this->PriceTypesBenefits);
        } else {
            $this->PriceTypesBenefits = $priceTypesBenefits;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get SaleLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSaleLimit()
    {
        return isset($this->SaleLimit) ? $this->SaleLimit : null;
    }
    /**
     * Set SaleLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $saleLimit
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setSaleLimit($saleLimit = null)
    {
        // validation for constraint: int
        if (!is_null($saleLimit) && !(is_int($saleLimit) || ctype_digit($saleLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saleLimit, true), gettype($saleLimit)), __LINE__);
        }
        if (is_null($saleLimit) || (is_array($saleLimit) && empty($saleLimit))) {
            unset($this->SaleLimit);
        } else {
            $this->SaleLimit = $saleLimit;
        }
        return $this;
    }
    /**
     * Get SchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeId()
    {
        return isset($this->SchemeId) ? $this->SchemeId : null;
    }
    /**
     * Set SchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeId
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setSchemeId($schemeId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeId) && !is_string($schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeId, true), gettype($schemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeId, true)), __LINE__);
        }
        if (is_null($schemeId) || (is_array($schemeId) && empty($schemeId))) {
            unset($this->SchemeId);
        } else {
            $this->SchemeId = $schemeId;
        }
        return $this;
    }
    /**
     * Get SchemeLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeLevelId()
    {
        return isset($this->SchemeLevelId) ? $this->SchemeLevelId : null;
    }
    /**
     * Set SchemeLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeLevelId
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setSchemeLevelId($schemeLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeLevelId) && !is_string($schemeLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeLevelId, true), gettype($schemeLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeLevelId, true)), __LINE__);
        }
        if (is_null($schemeLevelId) || (is_array($schemeLevelId) && empty($schemeLevelId))) {
            unset($this->SchemeLevelId);
        } else {
            $this->SchemeLevelId = $schemeLevelId;
        }
        return $this;
    }
    /**
     * Get SchemeLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSchemeLevelName()
    {
        return isset($this->SchemeLevelName) ? $this->SchemeLevelName : null;
    }
    /**
     * Set SchemeLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $schemeLevelName
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setSchemeLevelName(\patest\StructType\GlobalString $schemeLevelName = null)
    {
        if (is_null($schemeLevelName) || (is_array($schemeLevelName) && empty($schemeLevelName))) {
            unset($this->SchemeLevelName);
        } else {
            $this->SchemeLevelName = $schemeLevelName;
        }
        return $this;
    }
    /**
     * Get SchemeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSchemeName()
    {
        return isset($this->SchemeName) ? $this->SchemeName : null;
    }
    /**
     * Set SchemeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $schemeName
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setSchemeName(\patest\StructType\GlobalString $schemeName = null)
    {
        if (is_null($schemeName) || (is_array($schemeName) && empty($schemeName))) {
            unset($this->SchemeName);
        } else {
            $this->SchemeName = $schemeName;
        }
        return $this;
    }
    /**
     * Get ShowTimeGenerateNfcPass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowTimeGenerateNfcPass()
    {
        return isset($this->ShowTimeGenerateNfcPass) ? $this->ShowTimeGenerateNfcPass : null;
    }
    /**
     * Set ShowTimeGenerateNfcPass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showTimeGenerateNfcPass
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setShowTimeGenerateNfcPass($showTimeGenerateNfcPass = null)
    {
        // validation for constraint: boolean
        if (!is_null($showTimeGenerateNfcPass) && !is_bool($showTimeGenerateNfcPass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showTimeGenerateNfcPass, true), gettype($showTimeGenerateNfcPass)), __LINE__);
        }
        if (is_null($showTimeGenerateNfcPass) || (is_array($showTimeGenerateNfcPass) && empty($showTimeGenerateNfcPass))) {
            unset($this->ShowTimeGenerateNfcPass);
        } else {
            $this->ShowTimeGenerateNfcPass = $showTimeGenerateNfcPass;
        }
        return $this;
    }
    /**
     * Get TargetAutoRenewalMembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetAutoRenewalMembershipDefinitionId()
    {
        return isset($this->TargetAutoRenewalMembershipDefinitionId) ? $this->TargetAutoRenewalMembershipDefinitionId : null;
    }
    /**
     * Set TargetAutoRenewalMembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetAutoRenewalMembershipDefinitionId
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setTargetAutoRenewalMembershipDefinitionId($targetAutoRenewalMembershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($targetAutoRenewalMembershipDefinitionId) && !is_string($targetAutoRenewalMembershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetAutoRenewalMembershipDefinitionId, true), gettype($targetAutoRenewalMembershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetAutoRenewalMembershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetAutoRenewalMembershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetAutoRenewalMembershipDefinitionId, true)), __LINE__);
        }
        if (is_null($targetAutoRenewalMembershipDefinitionId) || (is_array($targetAutoRenewalMembershipDefinitionId) && empty($targetAutoRenewalMembershipDefinitionId))) {
            unset($this->TargetAutoRenewalMembershipDefinitionId);
        } else {
            $this->TargetAutoRenewalMembershipDefinitionId = $targetAutoRenewalMembershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get UseDefaultCounter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseDefaultCounter()
    {
        return isset($this->UseDefaultCounter) ? $this->UseDefaultCounter : null;
    }
    /**
     * Set UseDefaultCounter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useDefaultCounter
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setUseDefaultCounter($useDefaultCounter = null)
    {
        // validation for constraint: boolean
        if (!is_null($useDefaultCounter) && !is_bool($useDefaultCounter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useDefaultCounter, true), gettype($useDefaultCounter)), __LINE__);
        }
        if (is_null($useDefaultCounter) || (is_array($useDefaultCounter) && empty($useDefaultCounter))) {
            unset($this->UseDefaultCounter);
        } else {
            $this->UseDefaultCounter = $useDefaultCounter;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Membership_MembershipDefinition
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
